<?php
/**
 * Body Classes.
 * @package Architect Contractor
 */

if (!function_exists('architect_contractor_body_classes')) :

    function architect_contractor_body_classes($architect_contractor_classes)
    {
        $architect_contractor_defaults = architect_contractor_get_default_theme_options();
        $architect_contractor_layout = architect_contractor_get_final_sidebar_layout();

        // Adds a class of hfeed to non-singular pages.
        if (!is_singular()) {
            $architect_contractor_classes[] = 'hfeed';
        }

        // Sidebar layout logic
        $architect_contractor_classes[] = $architect_contractor_layout;

        // Copyright alignment
        $copyright_alignment = get_theme_mod('architect_contractor_copyright_alignment', 'Default');
        $architect_contractor_classes[] = 'copyright-' . strtolower($copyright_alignment);

        return $architect_contractor_classes;
    }

endif;

add_filter('body_class', 'architect_contractor_body_classes');