<?php
/**
 * Custom pagination function that act independently of the theme templates.
 *
 * @package aquaparallax
 */
function aquaparallax_pagination($numpages = '', $pagerange = '', $paged='') {

  if (empty($pagerange)) {
    $pagerange = 2;
  }

  /**
   * This first part of our function is a fallback
   * for aquaparallax pagination inside a regular loop that
   * uses the global $paged and global $wp_query variables.
   * 
   * It's good because we can now override default pagination
   * in our theme, and use this function in default quries
   * and aquaparallax queries.
   */


  
  if (empty($paged)) {
    $paged = 1;
  }
  if ($numpages == '') {
    
    $numpages = $wp_query->max_num_pages;

    if(!$numpages) {
        $numpages = 1;
    }
  }

 
  /** 
   * We construct the pagination arguments to enter into our paginate_links
   * function. 
   */
  $pagination_args = array(
    'base'            => get_pagenum_link(1) . '%_%',
    'format'          => 'page/%#%',
    'total'           => $numpages,
    'current'         => $paged,
    'show_all'        => False,
    'end_size'        => 1,
    'mid_size'        => $pagerange,
    'prev_next'       => True,
    'prev_text'       => esc_html('&laquo;', 'aquaparallax'),
    'next_text'       => esc_html('&raquo;', 'aquaparallax'),
    'type'            => 'plain',
    'add_args'        => false,
    'add_fragment'    => ''
  );

  $paginate_links = paginate_links($pagination_args);



  if ($paginate_links) {
    echo "<nav class='aqua-pagination'>";
      echo "<span class='page-numbers page-num'>Page " . $paged . " of " . $numpages . "</span> ";
      echo $paginate_links;
    echo "</nav>";
  }

}