<?php
// Global variables define
define('APPOINTMENT_DARK_PARENT_TEMPLATE_DIR_URI', get_template_directory_uri());
define('APPOINTMENT_DARK_TEMPLATE_DIR_URI', get_stylesheet_directory_uri());
define('APPOINTMENT_DARK_TEMPLATE_DIR', trailingslashit(get_stylesheet_directory()));

if (!function_exists('wp_body_open')) {

    function wp_body_open() {
        /**
         * Triggered after the opening <body> tag.
         */
        do_action('wp_body_open');
    }

}
add_action('wp_enqueue_scripts', 'appointment_dark_theme_css', 999);

function appointment_dark_theme_css() {

    $appointment_dark_options = theme_setup_data();
    $current_options = wp_parse_args(  get_option( 'appointment_options', array() ), $appointment_dark_options );

    wp_enqueue_style('appointment-dark-parent-style', APPOINTMENT_DARK_PARENT_TEMPLATE_DIR_URI . '/style.css');
    wp_style_add_data('appointment-dark-parent-style', 'rtl', 'replace');
    wp_enqueue_style('bootstrap-style', APPOINTMENT_DARK_PARENT_TEMPLATE_DIR_URI . '/css/bootstrap.css');
    wp_style_add_data('bootstrap-style', 'rtl', 'replace');
    wp_enqueue_style('appointment-dark-theme-menu', APPOINTMENT_DARK_PARENT_TEMPLATE_DIR_URI . '/css/theme-menu.css');
    wp_style_add_data('appointment-dark-theme-menu', 'rtl', 'replace');


    if($current_options['link_color_enable'] == true) {
        appointment_custom_light();
    }
    else {
        wp_enqueue_style('appointment-dark-default-css', APPOINTMENT_DARK_TEMPLATE_DIR_URI . "/css/default.css");
    }
    wp_enqueue_style('appointment-dark-element-style', APPOINTMENT_DARK_PARENT_TEMPLATE_DIR_URI . '/css/element.css');
    wp_enqueue_style('appointment-dark-media-responsive', APPOINTMENT_DARK_PARENT_TEMPLATE_DIR_URI . '/css/media-responsive.css');
    wp_style_add_data('appointment-dark-media-responsive', 'rtl', 'replace');
    wp_dequeue_style('appointment-default', APPOINTMENT_DARK_PARENT_TEMPLATE_DIR_URI . '/css/default.css');

}

/*
 * Let WordPress manage the document title.
 */

function appointment_dark_setup() {
    add_theme_support('title-tag');
    add_theme_support('automatic-feed-links');
    require( APPOINTMENT_DARK_TEMPLATE_DIR . '/functions/customizer/customizer-copyright.php');
    load_theme_textdomain('appointment-dark', APPOINTMENT_DARK_TEMPLATE_DIR . '/languages');

    //About Theme
    $theme = wp_get_theme(); // gets the current theme
    if ('Appointment Dark' == $theme->name) {
        if (is_admin()) {
            require APPOINTMENT_DARK_TEMPLATE_DIR . '/admin/admin-init.php';
        }
    }
}

add_action('after_setup_theme', 'appointment_dark_setup');

function appointment_dark_default_data() {

    return $theme_data = array(
        // general settings
        'footer_menu_bar_enabled' => '',
        'footer_social_media_enabled' => 0,
        'footer_social_media_facebook_link' => '',
        'footer_facebook_media_enabled' => 1,
        'footer_social_media_twitter_link' => '',
        'footer_twitter_media_enabled' => 1,
        'footer_social_media_linkedin_link' => '',
        'footer_linkedin_media_enabled' => 1,
        'footer_social_media_googleplus_link' => '',
        'footer_googleplus_media_enabled' => 1,
        'footer_social_media_skype_link' => '',
        'footer_skype_media_enabled' => 1,

        //Home contact callout setting
        'front_callout_enable'=> false,
        'front_contact_title' => 'Sed ut perspiciatis unde',
        'front_contact1_title'=> 'Non proident, sunt in culpa ',
        'front_contact1_val'=> esc_html__('+99 999 99 999','appointment-dark'),
        'contact_one_icon' => esc_html__('fa fa-phone','appointment-dark'),

        'front_contact2_title'=> ' Neque porro quisquam',
        'front_contact2_val'=> 'Ullamco laboris nisi',
        'contact_two_icon' => 'fa-regular fa-clock',


        'front_contact3_title'=> 'Ipsum quia dolor sit amet',
        'front_contact3_val'=>esc_html__('abc@example.com','appointment-dark'),
        'contact_three_icon' =>esc_html__('fa fa-envelope','appointment-dark'),


    );
}

add_action('customize_register', 'appointment_dark_remove_custom', 1000);
function appointment_dark_remove_custom($wp_customize) {
    $wp_customize->remove_section('copyright_section_one');
}

$appointment_dark_theme = wp_get_theme();
if( $appointment_dark_theme->name == 'Appointment Dark' || $appointment_dark_theme->name == 'Appointment Dark child' || $appointment_dark_theme->name == 'Appointment Dark Child' ) {
    // Notice to add required plugin
    function appointment_dark_admin_plugin_notice_warn() {
        $screen = get_current_screen();
        if( $screen->id == 'themes'){
            $theme_name = wp_get_theme();
            if ( get_option( 'dismissed-appointment_dark_comanion_plugin', false ) ) {
               return;
            }
            if ( function_exists('webriti_companion_activate')) {
                return;
            }?>

            <div class="updated notice is-dismissible appointment-dark-theme-notice">

                <div class="owc-header">
                    <h2 class="theme-owc-title">               
                        <svg height="60" width="60" id="Layer_1" data-name="Layer 1" xmlns="http://www.w3.org/2000/svg" viewBox="0 0 70 70"><defs><style>.cls-1{font-size:33px;font-family:Verdana-Bold, Verdana;font-weight:700;}</style></defs><title>Artboard 1</title><text class="cls-1" transform="translate(-0.56 51.25)">WC</text></svg>
                        <?php echo esc_html('Webriti Companion','appointment-dark');?>
                    </h2>
                </div>

                <div class="appointment-dark-theme-content">
                    <h3><?php printf (esc_html__('Thank you for installing the %1$s theme.', 'appointment-dark'), esc_html($theme_name)); ?></h3>

                    <p><?php esc_html_e( 'We highly recommend you to install and activate the', 'appointment-dark' ); ?>
                        <b><?php esc_html_e( 'Webriti Companion', 'appointment-dark' ); ?></b> plugin.
                        <br>
                        <?php esc_html_e( 'This plugin will unlock enhanced features to build a beautiful website.', 'appointment-dark' ); ?>
                    </p>
                    <button class="install-plugin-button-welcome-page" data-plugin-url="<?php echo esc_url( 'https://webriti.com/extensions/webriti-companion.zip');?>" data-plugin-slug="<?php esc_attr_e( 'webriti-companion','appointment-dark');?>"><?php echo esc_html__( 'Install', 'appointment-dark' ); ?></button>
                </div>
            </div>
            
            <script type="text/javascript">
                jQuery(function($) {
                $( document ).on( 'click', '.appointment-dark-theme-notice .notice-dismiss', function () {
                    var type = $( this ).closest( '.appointment-dark-theme-notice' ).data( 'notice' );
                    $.ajax( ajaxurl,
                      {
                        type: 'POST',
                        data: {
                          action: 'dismissed_notice_handler',
                          type: type,
                        }
                      } );
                  } );
              });
            </script>
            <?php
        }
    }
    add_action( 'admin_notices', 'appointment_dark_admin_plugin_notice_warn' );
    add_action( 'wp_ajax_dismissed_notice_handler', 'appointment_dark_ajax_notice_handler');

    function appointment_dark_ajax_notice_handler() {
        update_option( 'dismissed-appointment_dark_comanion_plugin', TRUE );
    }

    function appointment_dark_notice_style(){?>
        <style type="text/css">
            label.tg-label.breadcrumbs img {
                width: 6%;
                padding: 0;
            }
            .appointment-dark-theme-notice .theme-owc-title{
                display: flex;
                align-items: center;
                height: 100%;
                margin: 0;
                font-size: 1.5em;
            }
            .appointment-dark-theme-notice p{
                font-size: 14px;
            }
            .updated.notice.appointment-dark-theme-notice h3{
                margin: 0;
            }
            div.appointment-dark-theme-notice.updated {
                border-left-color: #ee591f;
            }
            .appointment-dark-theme-content{
                padding: 0 0 1.2rem 3.57rem;
            }
        </style>
    <?php
    }
    add_action('admin_enqueue_scripts','appointment_dark_notice_style');
}

// Hook the AJAX action for logged-in users
add_action('wp_ajax_appointment_dark_check_plugin_status', 'appointment_dark_check_plugin_status');

function appointment_dark_check_plugin_status() {
    if (!current_user_can('install_plugins')) {
        wp_send_json_error('You do not have permission to manage plugins.');
        return;
    }

    if (!isset($_POST['plugin_slug'])) {
        wp_send_json_error('No plugin slug provided.');
        return;
    }

    $plugin_slug = sanitize_text_field($_POST['plugin_slug']);
    $plugin_main_file = $plugin_slug . '/' . $plugin_slug . '.php'; // Adjust this based on your plugin structure

    // Check if the plugin exists
    $plugins = get_plugins();
    if (isset($plugins[$plugin_main_file])) {
        if (is_plugin_active($plugin_main_file)) {
            wp_send_json_success(array('status' => 'activated'));
        } else {
            wp_send_json_success(array('status' => 'installed'));
        }
    } else {
        wp_send_json_success(array('status' => 'not_installed'));
    }
}

// Existing AJAX installation function for installing and activating
add_action('wp_ajax_appointment_dark_install_activate_plugin', 'appointment_dark_install_and_activate_plugin');

function appointment_dark_install_and_activate_plugin() {
    if (!current_user_can('install_plugins')) {
        wp_send_json_error('You do not have permission to install plugins.');
        return;
    }

    if (!isset($_POST['plugin_url'])) {
        wp_send_json_error('No plugin URL provided.');
        return;
    }

    // Include necessary WordPress files for plugin installation
    include_once(ABSPATH . 'wp-admin/includes/file.php');
    include_once(ABSPATH . 'wp-admin/includes/misc.php');
    include_once(ABSPATH . 'wp-admin/includes/class-wp-upgrader.php');
    include_once(ABSPATH . 'wp-admin/includes/plugin.php');

    $plugin_url = esc_url($_POST['plugin_url']);
    $plugin_slug = sanitize_text_field($_POST['plugin_slug']);
    $plugin_main_file = $plugin_slug . '/' . $plugin_slug . '.php'; // Ensure this matches your plugin structure

    // Download the plugin file
    WP_Filesystem();
    $temp_file = download_url($plugin_url);

    if (is_wp_error($temp_file)) {
        wp_send_json_error($temp_file->get_error_message());
        return;
    }

    // Unzip the plugin to the plugins folder
    $plugin_folder = WP_PLUGIN_DIR;
    $result = unzip_file($temp_file, $plugin_folder);
    
    // Clean up temporary file
    unlink($temp_file);

    if (is_wp_error($result)) {
        wp_send_json_error($result->get_error_message());
        return;
    }

    // Activate the plugin if it was installed
    $activate_result = activate_plugin($plugin_main_file);

    

    // Return success with redirect URL
    wp_send_json_success(array('redirect_url' => admin_url('admin.php?page=appointment-dark-welcome')));
}

// Enqueue JavaScript for the button functionality
add_action('admin_enqueue_scripts', 'appointment_dark_enqueue_plugin_installer_script',11);

function appointment_dark_enqueue_plugin_installer_script(){
    global $hook_suffix;
    wp_dequeue_script('appointment-plugin-installer-js');
    wp_enqueue_script('appointment-dark-plugin-installer-js',  APPOINTMENT_DARK_TEMPLATE_DIR_URI . '/admin/assets/js/plugin-installer.js', array('jquery'), null, true);
    wp_localize_script('appointment-dark-plugin-installer-js', 'pluginInstallerAjax', array(
        'ajax_url' => admin_url('admin-ajax.php'),
        'hook_suffix' => $hook_suffix,
        'nonce' => wp_create_nonce('plugin_installer_nonce'),

    ));
}