<?php

/**
 * AoneImportDemoData class
 *
 * @package     Aone
 * @author      Mohit Thummar <mohit@8therate.com>
 * @link        https://www.8therate.com
 * @since       1.0.0
 */

if (!defined('ABSPATH')) {
    exit; // Exit if accessed directly.
}

if (!class_exists('AoneImportDemoData')) {

    class AoneImportDemoData
    {
        public static $_instance;

        public static function instance()
        {
            if (!isset(static::$_instance)) {
                static::$_instance = new static;
            }
            return static::$_instance;
        }

        public function __construct()
        {
            add_action('after_setup_theme', array($this, 'hooks'), 5);
            // $this->hooks();
        }

        public function hooks()
        {
            if ('y' == get_theme_mod('import_demo_data_completed', 'n')) {
                add_filter('ocdi/plugin_intro_text', array($this, 'ocdi_plugin_intro_text_1'));

                return; // Demo Data already imported
            }

            // phpcs:ignore WPThemeReview.CoreFunctionality.FileInclude.FileIncludeFound
            require_once get_template_directory() . '/inc/class-tgm-plugin-activation.php';

            add_action('tgmpa_register',            array($this, 'tgmpa_register'));
            add_action('ocdi/after_import',         array($this, 'ocdi_after_import'));
        }

        public function ocdi_plugin_intro_text_1($text)
        {
            ob_start();
?>
            <div class="notice notice-warning">
                <p style="font-size: 16px;">
                    <?php esc_html_e('It Looks like you already imported demo data for this theme. Please reset WordPress to import demo data again.', 'aone'); ?>
                </p>
            </div>
<?php
            return $text . ob_get_clean();
        }

        public function tgmpa_register()
        {
            /*
            * Array of plugin arrays. Required keys are name and slug.
            * If the source is NOT from the .org repo, then source is also required.
            */
            $plugins = array(
                array(
                    'name' => 'One Click Demo Import',
                    'slug' => 'one-click-demo-import',
                    'required' => false,
                ),
                array(
                    'name' => 'Elementor',
                    'slug' => 'elementor',
                    'required' => false,
                ),
                array(
                    'name' => 'Elementor Header & Footer Builder',
                    'slug' => 'header-footer-elementor',
                    'required' => false,
                ),
                array(
                    'name' => 'Contact Form 7',
                    'slug' => 'contact-form-7',
                    'required' => false,
                ),
                array(
                    'name' => 'Contact Form 7 Database Addon - CFDB7',
                    'slug' => 'contact-form-cfdb7',
                    'required' => false,
                ),
            );

            /*
             * Array of configuration settings. Amend each line as needed.
             */
            $config = array(
                'id' => 'aone',                             // Unique ID for hashing notices for multiple instances of TGMPA.
                'default_path' => '',                       // Default absolute path to bundled plugins.
                'menu' => 'tgmpa-install-plugins',          // Menu slug.
                'has_notices' => true,                      // Show admin notices or not.
                'dismissable' => true,                      // If false, a user cannot dismiss the nag message.
                'dismiss_msg' => '',                        // If 'dismissable' is false, this message will be output at top of nag.
                'is_automatic' => false,                    // Automatically activate plugins after installation or not.
                'message' => '',                            // Message to output right before the plugins table.
            );

            tgmpa($plugins, $config);
        }

        public function ocdi_after_import()
        {
            // Mark demo import completed
            set_theme_mod('import_demo_data_completed', 'y');

            // Assign menus to their locations.
            $main_menu = get_term_by('name', 'Main Menu', 'nav_menu');

            if (isset($main_menu->term_id)) {
                set_theme_mod(
                    'nav_menu_locations',
                    array('menu-1' => $main_menu->term_id)
                );
            }

            // Get the front page.
            $front_page = get_posts(array(
                'post_type' => 'page',
                'title' => 'Home',
                'numberposts' => 1,
            ));

            // Get the blog page.
            $blog_page = get_posts(array(
                'post_type' => 'page',
                'title' => 'Blog',
                'numberposts' => 1,
            ));

            if (!empty($front_page)) {
                update_option('page_on_front', $front_page[0]->ID);
            }
            if (!empty($blog_page)) {
                update_option('page_for_posts', $blog_page[0]->ID);
            }
            if (!empty($front_page) || !empty($blog_page)) {
                update_option('show_on_front', 'page');
            }

            // Reset Permalink Settings
            global $wp_rewrite;
            if (isset($wp_rewrite)) {

                $wp_rewrite->set_permalink_structure('\/%postname%\/'); // Write the rule

                update_option('rewrite_rules', false); // Set the option rewrite_rules

                $wp_rewrite->flush_rules(true); // Flush the rules and tell it to write htaccess

            }

            if (class_exists('Elementor\Plugin')) {

                // Get the elementor_library Demo Kit.
                $elementor_kit = get_posts(array(
                    'post_type' => 'elementor_library',
                    'title' => 'Demo Kit',
                    'numberposts' => 1,
                ));

                if (!empty($elementor_kit)) {

                    $elementor_instance = \Elementor\Plugin::instance();

                    // Update active elementor_library kit
                    $elementor_instance->kits_manager->revert(
                        0,
                        $elementor_kit[0]->ID,
                        $elementor_instance->kits_manager->get_active_id()
                    );

                    // Elementor clear cache
                    $elementor_instance->files_manager->clear_cache();
                }
            }
        }
    }
}

AoneImportDemoData::instance();
