<?php

/**
 * AoneHeaderFooterElementor class
 *
 * @package     Aone
 * @author      Mohit Thummar <mohit@8therate.com>
 * @link        https://www.8therate.com
 * @since       1.0.0
 */

if (!defined('ABSPATH')) {
    exit; // Exit if accessed directly.
}

if (!class_exists('AoneHeaderFooterElementor')) {

    class AoneHeaderFooterElementor
    {
        public static $_instance;

        public static function instance()
        {
            if (!isset(static::$_instance)) {
                static::$_instance = new static;
            }
            return static::$_instance;
        }

        public function __construct()
        {
            add_action('after_setup_theme', array($this, 'hooks'), 5);
            // $this->hooks();
        }

        public function hooks()
        {
            add_action('hfe_header_enabled',            array($this, 'hfe_header_enabled'));
            add_action('hfe_footer_enabled',            array($this, 'hfe_footer_enabled'));
            add_action('hfe_before_footer_enabled',     array($this, 'hfe_before_footer_enabled'));
            add_action('get_hfe_header_id',             array($this, 'get_hfe_header_id'));
            add_action('get_hfe_footer_id',             array($this, 'get_hfe_footer_id'));
            add_action('get_hfe_before_footer_id',      array($this, 'get_hfe_before_footer_id'));

            add_action('add_meta_boxes',                array($this, 'add_meta_boxes'));
            add_action('save_post',                     array($this, 'save_post'));

            add_action('customize_register',            array($this, 'customize_register'));

            add_filter('body_class',                    array($this, 'body_class'));
            add_action('wp_footer',                     array($this, 'wp_footer'));
        }

        public function hfe_enabled()
        {
            return class_exists('Header_Footer_Elementor');
        }

        public function hfe_header_enabled($default)
        {
            return boolval($this->get_hfe_area_id('hfe_header', $default));
        }

        public function hfe_footer_enabled($default)
        {
            return boolval($this->get_hfe_area_id('hfe_footer', $default));
        }

        public function hfe_before_footer_enabled($default)
        {
            return boolval($this->get_hfe_area_id('hfe_before_footer', $default));
        }

        public function get_hfe_header_id($default)
        {
            return absint($this->get_hfe_area_id('hfe_header', $default));
        }

        public function get_hfe_footer_id($default)
        {
            return absint($this->get_hfe_area_id('hfe_footer', $default));
        }

        public function get_hfe_before_footer_id($default)
        {
            return absint($this->get_hfe_area_id('hfe_before_footer', $default));
        }

        protected $hfe_area_id_cache = [];

        public function get_hfe_area_id($area, $default)
        {
            $cache_key = strval($area) . '_' . strval($default);

            if (!array_key_exists($cache_key, $this->hfe_area_id_cache)) {
                $this->hfe_area_id_cache[$cache_key] = $this->_get_hfe_area_id($area, $default);
            }

            return $this->hfe_area_id_cache[$cache_key];
        }

        protected function _get_hfe_area_id($area, $default)
        {
            if (!in_array($area, array('hfe_header', 'hfe_footer', 'hfe_before_footer'))) {
                return 0;
            }

            if ('hfe_before_footer' == $area) {
                if (!$this->hfe_footer_enabled(true)) {
                    return 0;
                }
            }

            $post_id = false;
            if (is_home() || is_category() || is_tag()) {
                $post_id = get_option('page_for_posts');
            } else {
                $post_id = get_the_ID();
            }

            $post_id = apply_filters('aone_get_hfe_area_id_of_post_id', $post_id, $area, $default);

            if ($post_id) {

                $area_id = get_post_meta($post_id, "aone_{$area}", true);
                $area_id = ('' != $area_id) ? $area_id : 'customizer';

                if ('theme' == $area_id) {
                    return 0;
                }
                if (is_numeric($area_id)) {
                    return $area_id;
                }
                if ('plugin' == $area_id) {
                    return $default;
                }
            }

            $area_id = get_theme_mod($area, 'theme');

            if ('theme' == $area_id) {
                return 0;
            }
            if (is_numeric($area_id)) {
                return $area_id;
            }

            return $default;
        }

        public function add_meta_boxes()
        {
            add_meta_box(
                'hfe_header_footer_metabox',
                __('Custom Header Footer', 'aone'),
                array($this, 'hfe_header_footer_metabox'),
                apply_filters('aone_chf_metabox_screens', array('post', 'page'))
            );
        }

        public function hfe_header_footer_metabox($post)
        {
            $hfe_header_options_html = $this->get_options_html(
                $this->get_custom_header_options(),
                get_post_meta($post->ID, 'aone_hfe_header', true),
                'customizer'
            );
            $hfe_footer_options_html = $this->get_options_html(
                $this->get_custom_footer_options(),
                get_post_meta($post->ID, 'aone_hfe_footer', true),
                'customizer'
            );
            $hfe_before_footer_options_html = $this->get_options_html(
                $this->get_custom_before_footer_options(),
                get_post_meta($post->ID, 'aone_hfe_before_footer', true),
                'customizer'
            );
?>
            <div id="aone_hfe_header_wrap">
                <p class="post-attributes-label-wrapper">
                    <label class="post-attributes-label" for="aone_hfe_header"><?php esc_html_e('Custom Header', 'aone'); ?></label>
                    <!-- <br> --><small><?php esc_html_e('Select Custom Header.', 'aone'); ?></small>
                </p>
                <select id="aone_hfe_header" name="aone_hfe_header" style="width: 100%;">
                    <?php echo wp_kses(
                        $hfe_header_options_html,
                        array(
                            'option' => array(
                                'value' => array(),
                                'selected' => array(),
                            )
                        )
                    ); ?>
                </select>
            </div>

            <div id="aone_hfe_footer_wrap">
                <p class="post-attributes-label-wrapper">
                    <label class="post-attributes-label" for="aone_hfe_footer"><?php esc_html_e('Custom Footer', 'aone'); ?></label>
                    <!-- <br> --><small><?php esc_html_e('Select Custom Footer.', 'aone'); ?></small>
                </p>
                <select id="aone_hfe_footer" name="aone_hfe_footer" style="width: 100%;">
                    <?php echo wp_kses(
                        $hfe_footer_options_html,
                        array(
                            'option' => array(
                                'value' => array(),
                                'selected' => array(),
                            )
                        )
                    ); ?>
                </select>
            </div>

            <div id="aone_hfe_before_footer_wrap">
                <p class="post-attributes-label-wrapper">
                    <label class="post-attributes-label" for="aone_hfe_before_footer"><?php esc_html_e('Custom Before Footer', 'aone'); ?></label>
                    <!-- <br> --><small><?php esc_html_e('Select Custom Before Footer.', 'aone'); ?></small>
                </p>
                <select id="aone_hfe_before_footer" name="aone_hfe_before_footer" style="width: 100%;">
                    <?php echo wp_kses(
                        $hfe_before_footer_options_html,
                        array(
                            'option' => array(
                                'value' => array(),
                                'selected' => array(),
                            )
                        )
                    ); ?>
                </select>
            </div>

            <script>
                jQuery(function($) {
                    var aone_hfe_footer_change = function() {
                        if ('theme' == $('#aone_hfe_footer').val()) {
                            $('#aone_hfe_before_footer_wrap').slideUp();
                        } else {
                            $('#aone_hfe_before_footer_wrap').slideDown();
                        }
                    };
                    $('#aone_hfe_footer').change(aone_hfe_footer_change);
                    aone_hfe_footer_change();
                });
            </script>
<?php
        }

        public function save_post($post_id)
        {
            if (defined('DOING_AUTOSAVE') && DOING_AUTOSAVE) {
                return;
            }
            if ($parent_id = wp_is_post_revision($post_id)) {
                $post_id = $parent_id;
            }
            $fields = array(
                'aone_hfe_header',
                'aone_hfe_footer',
                'aone_hfe_before_footer',
            );
            foreach ($fields as $field) {
                if (array_key_exists($field, $_POST)) {
                    update_post_meta($post_id, $field, sanitize_text_field(wp_unslash($_POST[$field])));
                }
            }
        }

        public function get_custom_header_options($add_customizer = true)
        {
            $options = array();
            if ($add_customizer) {
                $options['customizer'] = __('Customizer Default', 'aone');
            }
            $options['theme'] = __('Theme Default', 'aone');

            if ($this->hfe_enabled()) {
                $options['plugin'] = __('Plugin Default', 'aone');

                $options = $this->get_hfe_template_type_options('type_header', $options);
            }

            return $options;
        }

        public function get_custom_footer_options($add_customizer = true)
        {
            $options = array();
            if ($add_customizer) {
                $options['customizer'] = __('Customizer Default', 'aone');
            }
            $options['theme'] = __('Theme Default', 'aone');

            if ($this->hfe_enabled()) {
                $options['plugin'] = __('Plugin Default', 'aone');

                $options = $this->get_hfe_template_type_options('type_footer', $options);
            }

            return $options;
        }

        public function get_custom_before_footer_options($add_customizer = true)
        {
            $options = array();
            if ($add_customizer) {
                $options['customizer'] = __('Customizer Default', 'aone');
            }
            $options['theme'] = __('None', 'aone');

            if ($this->hfe_enabled()) {
                $options['plugin'] = __('Plugin Default', 'aone');

                $options = $this->get_hfe_template_type_options('type_before_footer', $options);
            }

            return $options;
        }

        public function get_hfe_template_type_options($hfe_template_type, $options = array())
        {
            $posts = get_posts(array(
                'post_type' => 'elementor-hf',
                'orderby' => 'title',
                'order' => 'asc',
                'meta_key'   => 'ehf_template_type',
                'meta_value' => $hfe_template_type,
                'numberposts' => 100,
            ));
            foreach ($posts as $post) {
                $options[$post->ID] = $post->post_title;
            }
            return $options;
        }

        public function get_options_html($options, $selected = '', $default = '')
        {
            $selected = ('' != $selected) ? $selected : $default;
            $options_html = '';
            foreach ($options as $value => $label) {
                $options_html .= '<option value="' . esc_attr($value) . '" ' . ($value == $selected ? 'selected' : '') . '>'
                    . esc_html($label)
                    . '</option>';
            }
            return $options_html;
        }

        function sanitize_checkbox_field($checked)
        {
            return boolval($checked);
        }

        public function customize_register($wp_customize)
        {

            $section_description = __('Set Custom Header Footer.', 'aone');
            if (!$this->hfe_enabled()) {
                $section_description = __('Set Custom Header Footer. Use Elementor Header & Footer Builder to create custom Header and Footer', 'aone');
            }

            $wp_customize->add_section(
                'aone_hfe_header_footer',
                array(
                    'title' => __('Custom Header Footer', 'aone'),
                    'priority' => 30,
                    'description' => $section_description,
                )
            );

            $wp_customize->add_setting(
                'hfe_header',
                array(
                    'default' => 'theme',
                    'sanitize_callback' => 'sanitize_text_field',
                )
            );

            $wp_customize->add_setting(
                'header_logo_enabled',
                array(
                    'default' => false,
                    'sanitize_callback' => array($this, 'sanitize_checkbox_field'),
                )
            );

            $wp_customize->add_setting(
                'header_sitetitle_enabled',
                array(
                    'default' => true,
                    'sanitize_callback' => array($this, 'sanitize_checkbox_field'),
                )
            );

            $wp_customize->add_setting(
                'header_tagline_enabled',
                array(
                    'default' => false,
                    'sanitize_callback' => array($this, 'sanitize_checkbox_field'),
                )
            );

            $wp_customize->add_setting(
                'header_sticky_enabled',
                array(
                    'default' => false,
                    'sanitize_callback' => array($this, 'sanitize_checkbox_field'),
                )
            );

            $wp_customize->add_setting(
                'hfe_footer',
                array(
                    'default' => 'theme',
                    'sanitize_callback' => 'sanitize_text_field',
                )
            );

            $wp_customize->add_setting(
                'hfe_before_footer',
                array(
                    'default' => 'theme',
                    'sanitize_callback' => 'sanitize_text_field',
                )
            );

            $wp_customize->add_control(
                'hfe_header',
                array(
                    'settings' => 'hfe_header',
                    'section' => 'aone_hfe_header_footer',
                    'type' => 'select',
                    'label' => __('Custom Header', 'aone'),
                    'description' => __('Select Custom Header.', 'aone'),
                    'choices' => $this->get_custom_header_options(false),
                )
            );

            $wp_customize->add_control(
                'header_logo_enabled',
                array(
                    'settings' => 'header_logo_enabled',
                    'section' => 'aone_hfe_header_footer',
                    'type' => 'checkbox',
                    'label' => __('Show Logo In Header', 'aone'),
                    'active_callback' => array($this, 'site_branding_active_callback'),
                )
            );

            $wp_customize->add_control(
                'header_sitetitle_enabled',
                array(
                    'settings' => 'header_sitetitle_enabled',
                    'section' => 'aone_hfe_header_footer',
                    'type' => 'checkbox',
                    'label' => __('Show Site Title In Header', 'aone'),
                    'active_callback' => array($this, 'site_branding_active_callback'),
                )
            );

            $wp_customize->add_control(
                'header_tagline_enabled',
                array(
                    'settings' => 'header_tagline_enabled',
                    'section' => 'aone_hfe_header_footer',
                    'type' => 'checkbox',
                    'label' => __('Show Tagline In Header', 'aone'),
                    'active_callback' => array($this, 'site_branding_active_callback'),
                )
            );

            $wp_customize->add_control(
                'header_sticky_enabled',
                array(
                    'settings' => 'header_sticky_enabled',
                    'section' => 'aone_hfe_header_footer',
                    'type' => 'checkbox',
                    'label' => __('Sticky Header', 'aone'),
                )
            );

            $wp_customize->add_control(
                'hfe_footer',
                array(
                    'settings' => 'hfe_footer',
                    'section' => 'aone_hfe_header_footer',
                    'type' => 'select',
                    'label' => __('Custom Footer', 'aone'),
                    'description' => __('Select Custom Footer.', 'aone'),
                    'choices' => $this->get_custom_footer_options(false),
                )
            );

            $wp_customize->add_control(
                'hfe_before_footer',
                array(
                    'settings' => 'hfe_before_footer',
                    'section' => 'aone_hfe_header_footer',
                    'type' => 'select',
                    'label' => __('Custom Before Footer', 'aone'),
                    'description' => __('Select Custom Before Footer.', 'aone'),
                    'choices' => $this->get_custom_before_footer_options(false),
                    'active_callback' => array($this, 'hfe_before_footer_active_callback'),
                )
            );
        }

        public function site_branding_active_callback()
        {
            return ('theme' == get_theme_mod('hfe_header', 'theme'));
        }

        public function hfe_before_footer_active_callback()
        {
            return ('theme' != get_theme_mod('hfe_footer', 'theme'));
        }

        public function body_class($classes)
        {
            if (get_theme_mod('header_sticky_enabled')) {
                $classes[] = 'has-sticky-header';
            }
            return $classes;
        }

        public function wp_footer()
        {
            printf('<div class="aone-footer-credit-to-author">');
            /* translators: 1: Theme name, 2: Theme author. */
            printf(esc_html__('Theme: %1$s by %2$s.', 'aone'), 'Aone', '<a target="_blank" href="https://www.8therate.com/">8therate.com</a>');
            printf('</div>');
        }
    }
}

AoneHeaderFooterElementor::instance();
