<?php

/**
 * The header for our theme
 *
 * This is the template that displays all of the <head> section and everything up until <div id="content">
 *
 * @link https://developer.wordpress.org/themes/basics/template-files/#template-partials
 *
 * @package aone
 */

?>
<!doctype html>
<html <?php language_attributes(); ?>>

<head>
	<meta charset="<?php bloginfo('charset'); ?>">
	<meta name="viewport" content="width=device-width, initial-scale=1">
	<link rel="profile" href="https://gmpg.org/xfn/11">

	<?php wp_head(); ?>
</head>

<body <?php body_class(); ?>>

	<?php wp_body_open(); ?>

	<div id="page" class="site">
		<a class="skip-link screen-reader-text" href="#primary"><?php esc_html_e('Skip to content', 'aone'); ?></a>

		<header id="masthead" class="site-header">
			<div class="site-header-inner">
				<div class="wpm-container site-primary-header-wrap">

					<div class="site-branding">

						<?php if (get_theme_mod('header_logo_enabled')) : ?>
							<?php the_custom_logo(); ?>
						<?php endif; ?>

						<?php if (get_theme_mod('header_sitetitle_enabled', true)) : ?>
							<span class="site-title">
								<a href="<?php echo esc_url(home_url('/')); ?>" rel="home">
									<?php bloginfo('name'); ?>
								</a>
							</span>
						<?php endif; ?>

						<?php if (get_theme_mod('header_tagline_enabled')) : ?>
							<p class="site-description">
								<?php bloginfo('description'); ?>
							</p>
						<?php endif; ?>

					</div><!-- .site-branding -->

					<nav id="site-navigation" class="main-navigation">
						<button class="menu-toggle" aria-controls="primary-menu" aria-expanded="false"><span class="toggle-icon"></span></button>
						<?php
						wp_nav_menu(
							array(
								'theme_location' => 'menu-1',
								'menu_id'        => 'primary-menu',
							)
						);
						?>
					</nav><!-- #site-navigation -->

				</div><!-- .wpm-container -->
			</div><!-- .site-header-inner -->
		</header><!-- #masthead -->