<?php
/**
* Template part for displaying front page introduction.
*
* @package ansupa
*/

// Get the content type.
$trending_posts = get_theme_mod( 'ansupa_trending_posts', 'post' );
// Bail if the section is disabled.
if ( 'disable' === $trending_posts ) {
    return;
}

$trending_posts_title    = get_theme_mod( 'ansupa_trending_posts_title', __( 'Trending POST', 'ansupa') );

$trending_posts_excerpt = get_theme_mod( 'ansupa_trending_posts_excerpt', 20 );

$get_content = ansupa_get_section_content( 'trending_posts', $trending_posts, 3  );
?>

<div id="trending" class="pt clear padding">
    <div class="section-content">
        <div class="trending-post-wrapper">

            <?php $i=1; foreach ( $get_content as $content ):

            if ($i !== 3): ?>

                <article class="has-post-thumbnail">
                    <div class="featured-image" style="background-image:url('<?php echo esc_url( get_the_post_thumbnail_url( $content['id'] ) ) ; ?>')">                       
                    </div><!-- .featured-image -->

                    <div class="entry-container">
                        <header class="entry-header">
                            <h2 class="entry-title"><a href="<?php echo esc_url( $content['url'] ); ?>" tabindex="0"><?php echo esc_html( $content['title'] ); ?></a></h2>
                        </header>
                    </div><!-- .entry-container -->
                </article>
            <?php endif;

            $i++; endforeach; ?>

        </div><!-- .trending-post-wrapper -->

        <div class="trending-post">
            <?php $j=1; foreach ( $get_content as $content ):

            if ( $j == 3 ): ?>
                <article>
                    <div class="entry-container">
                        <div class="entry-meta">
                            <span class="cat-links">
                                <?php the_category( '', '', $content['id'] ); ?>
                            </span><!-- .cat-links -->
                        </div><!-- .entry-meta -->

                        <header class="entry-header">
                            <h2 class="entry-title"><a href="<?php echo esc_url( $content['url'] ); ?>" tabindex="0"><?php echo esc_html( $content['title'] ); ?></a></h2>
                        </header>

                        <div class="featured-image" style="background-image:url('<?php echo esc_url( get_the_post_thumbnail_url( $content['id'] ) ) ; ?>')"></div>

                        <div class="entry-content">
                            <p><?php echo esc_html( wp_trim_words( $content['content'], $trending_posts_excerpt ) ); ?></p>
                        </div><!-- .entry-content -->

                        <div class="footer-meta">
                            <?php 

                            ansupa_post_author() ;

                            ansupa_posted_on( $content['id'] );

                            ?>

                            <span class="comment"><a class="url fn n" href="<?php echo esc_url( $content['url'] ); ?>"><?php echo get_comments_number( $content['id'] ); ?></a></span>
                        
                        </div><!-- .entry-meta -->
                    </div><!-- .entry-container -->
                </article>

            <?php endif;

            $j++; endforeach; ?>
        </div><!-- .trending -->
    </div><!-- .section-content -->
</div><!-- #trending -->