<?php
/**
 * Template part for displaying front page introduction.
 *
 * @package ansupa
 */

// Get the content type.
$recent_posts = get_theme_mod( 'ansupa_recent_posts', 'disable' );
// Bail if the section is disabled.
if ( 'disable' === $recent_posts ) {
	return;
}
$recent_posts_count    = get_theme_mod( 'ansupa_recent_posts_count', 3 ) ;

$recent_posts_title    = get_theme_mod( 'ansupa_recent_posts_title', __( 'RECENT POST', 'ansupa') );

$recent_posts_excerpt = get_theme_mod( 'ansupa_recent_posts_excerpt', 30 );

$col_class = get_theme_mod( 'ansupa_recent_posts_column', 'col-3' );

$get_content = ansupa_get_section_content( 'recent_posts', $recent_posts, $recent_posts_count  );
?>

<div id="recent-post">
    <div class="container">
        <?php if( !empty( $recent_posts_title ) ): ?>
            <div class="section-header">
                <h2 class="section-title"><?php echo esc_html( $recent_posts_title ); ?></h2>
            </div><!-- .section-header -->
        <?php endif; ?>

        <div class="section-content <?php echo esc_attr( $col_class ); ?>">

            <?php foreach ( $get_content as $content ): ?>

                <article>
                    <div class="entry-container">
                        <div class="entry-meta">
                            <span class="cat-links">
                                <?php the_category( '', '', $content['id'] ) ?>
                            </span><!-- .cat-links -->
                        </div><!-- .entry-meta -->

                        <header class="entry-header">
                            <h2 class="entry-title"><a href="<?php echo esc_url( $content['url'] ); ?>" tabindex="0"><?php echo esc_html( $content['title'] ); ?></a></h2>
                        </header>

                        <div class="featured-image" style="background-image:url('<?php echo esc_url( get_the_post_thumbnail_url( $content['id'] ) ) ; ?>')"></div>

                        <div class="entry-content">
                            <p><?php echo esc_html( wp_trim_words( $content['content'], $recent_posts_excerpt ) ); ?></p>
                        </div><!-- .entry-content -->

                        <div class="footer-meta">
                            <?php 

                            ansupa_post_author() ;

                            ansupa_posted_on( $content['id'] );

                            ?>

                            <span class="comment"><a class="url fn n" href="<?php echo esc_url( $content['url'] ); ?>"><?php echo get_comments_number( $content['id'] ); ?></a></span>

                        </div><!-- .entry-meta -->
                    </div><!-- .entry-container -->
                </article>

            <?php endforeach; ?>

        </div>
    </div>
</div><!-- #recent-post -->