<?php
/**
 * Template part for displaying front page introduction.
 *
 * @package ansupa
 */

// Get the content type.
$latest_posts = get_theme_mod( 'ansupa_latest_posts', 'disable' );
// Bail if the section is disabled.
if ( 'disable' === $latest_posts ) {
    return;
}
$latest_posts_excerpt = get_theme_mod( 'ansupa_latest_posts_excerpt', 45 ) ;
$section_title    = get_theme_mod( 'ansupa_latest_posts_title', __( 'LATEST ARTICLES', 'ansupa') ) ;
$get_content = ansupa_get_section_content( 'latest_posts', $latest_posts, 1  );

?>

<div id="latest" class="pt padding container">
    <div class="section-content">

      <?php foreach ( $get_content as $content ): ?>

        <article>
          <div class="entry-meta">
            <span class="cat-links">
              <?php the_category( '', '', $content['id'] ); ?>
            </span><!-- .cat-links -->
          </div><!-- .entry-meta -->

          <header class="entry-header">
            <h2 class="entry-title"><a href="<?php echo esc_url( $content['url'] ) ; ?>" tabindex="0"><?php echo esc_html( $content['title'] ); ?></a></h2>
          </header>

          <div class="featured-image" style="background-image:url('<?php echo esc_url( get_the_post_thumbnail_url( $content['id'] ) ) ; ?>')">
            <?php if( !empty( get_theme_mod( 'ansupa_latest_posts_video_url') ) ): ?>
                <div class="video-button">
                    <a href="<?php echo esc_url( get_theme_mod( 'ansupa_latest_posts_video_url') ); ?>" class="popup-youtube">
                       <svg viewBox="0 0 41.999 41.999">
                            <path d="M36.068,20.176l-29-20C6.761-0.035,6.363-0.057,6.035,0.114C5.706,0.287,5.5,0.627,5.5,0.999v40
                            c0,0.372,0.206,0.713,0.535,0.886c0.146,0.076,0.306,0.114,0.465,0.114c0.199,0,0.397-0.06,0.568-0.177l29-20
                            c0.271-0.187,0.432-0.494,0.432-0.823S36.338,20.363,36.068,20.176z M7.5,39.095V2.904l26.239,18.096L7.5,39.095z"/>
                        </svg>
                    </a>
                </div>
              <?php endif; ?>
          </div>

          <div class="entry-content">
           <p><?php echo esc_html( wp_trim_words( $content['content'], $latest_posts_excerpt ) ); ?></p>
         </div><!-- .entry-content -->

         <div class="footer-meta">
          
          <?php

          ansupa_post_author() ;

          ansupa_posted_on( $content['id'] );

          ?>

            <?php if( $latest_posts !== 'page' ): ?>
          <span class="comment"><a class="url fn n" href="<?php echo esc_url( $content['url'] ); ?>"><?php echo get_comments_number( $content['id'] ); ?></a></span>
        <?php endif; ?>
        </div><!-- .entry-meta -->
      </article>

    <?php endforeach; ?>

  </div>
</div>
            </div><!-- #latest-post -->