<?php
/**
 * Template part for displaying content  in post.php
 *
 * @link https://developer.wordpress.org/themes/basics/template-hierarchy/
 *
 * @package ansupa
 */
?>
<article id="post-<?php the_ID(); ?>" <?php post_class( 'hentry' ); ?>>
	<?php
	$ansupa_enable_single_featured_img = get_theme_mod( 'ansupa_enable_single_featured_img', true );
	if ( has_post_thumbnail() && $ansupa_enable_single_featured_img ) : ?>
		<div class="featured-image">
			<?php the_post_thumbnail( 'full', array( 'alt' => the_title_attribute( 'echo=0' ) ) ); ?>
		</div><!-- .featured-post-image -->
	<?php endif; ?>

	<div class="entry-meta">
		<?php

		$single_author_enable = get_theme_mod( 'ansupa_enable_single_author', true );
		if ( $single_author_enable ) {
			ansupa_post_author();
		}
		
		$single_date_enable = get_theme_mod( 'ansupa_enable_single_date', true );
		if ( $single_date_enable ) {
			ansupa_posted_on();
		}

		echo ansupa_cats();
		?>
	</div><!-- .entry-meta -->
	<div class="entry-container">
		<div class="entry-content">

			<?php
			the_content( );
			wp_link_pages( array(
				'before' => '<div class="page-links">' . esc_html__( 'Pages:', 'ansupa' ),
				'after'  => '</div>',
			) );
			?>
		</div><!-- .entry-content -->
		
	</div><!-- .entry-container -->
	<div class="entry-meta">
		<?php ansupa_tags(); ?>
	</div><!-- .entry-meta -->
</article><!-- #post-<?php the_ID(); ?> -->