<?php
/**
 * The sidebar containing the main widget area
 *
 * @link https://developer.wordpress.org/themes/basics/template-files/#template-partials
 *
 * @package ansupa
 */

if ( is_archive() || ansupa_is_latest_posts() || is_404() || is_search() ) {
	$archive_sidebar = get_theme_mod( 'ansupa_archive_sidebar', 'right' ); 
	if ( 'no' === $archive_sidebar ) {
		return;
	}
} elseif ( is_single() ) {
    $ansupa_post_sidebar_meta = get_post_meta( get_the_ID(), 'ansupa-select-sidebar', true );
	$global_post_sidebar = get_theme_mod( 'ansupa_global_post_layout', 'right' ); 

	if ( ! empty( $ansupa_post_sidebar_meta ) && ( 'no' === $ansupa_post_sidebar_meta ) ) {
		return;
	} elseif ( empty( $ansupa_post_sidebar_meta ) && 'no' === $global_post_sidebar ) {
		return;
	}
} elseif ( ansupa_is_frontpage_blog() || is_page() ) {
	if ( ansupa_is_frontpage_blog() ) {
		$page_id = get_option( 'page_for_posts' );
	} else {
		$page_id = get_the_ID();
	}
	
    $ansupa_page_sidebar_meta = get_post_meta( $page_id, 'ansupa-select-sidebar', true );
	$global_page_sidebar = get_theme_mod( 'ansupa_global_page_layout', 'right' ); 

	if ( ! empty( $ansupa_page_sidebar_meta ) && ( 'no' === $ansupa_page_sidebar_meta ) ) {
		return;
	} elseif ( empty( $ansupa_page_sidebar_meta ) && 'no' === $global_page_sidebar ) {
		return;
	}
}

if ( ! is_active_sidebar( 'sidebar-1' ) ) {
	return;
}
?>

<aside id="secondary" class="widget-area" role="complementary">
	<?php dynamic_sidebar( 'sidebar-1' ); ?>
</aside><!-- #secondary -->
