<?php
/**
 * Global Layout
 */
// Global Layout
$wp_customize->add_section(
	'ansupa_global_layout',
	array(
		'title' => esc_html__( 'Global Layout', 'ansupa' ),
		'panel' => 'ansupa_general_panel',
	)
);

// Global site layout setting
$wp_customize->add_setting(
	'ansupa_site_layout',
	array(
		'sanitize_callback' => 'ansupa_sanitize_select',
		'default' => 'wide',
		'transport'	=> 'postMessage',
	)
);

$wp_customize->add_control(
	'ansupa_site_layout',
	array(
		'section'		=> 'ansupa_global_layout',
		'label'			=> esc_html__( 'Site layout', 'ansupa' ),
		'type'			=> 'radio',
		'choices'		=> array( 
			'boxed' => esc_html__( 'Boxed', 'ansupa' ), 
			'wide' => esc_html__( 'Wide', 'ansupa' ), 
			'frame' => esc_html__( 'Frame', 'ansupa' ), 
		),
	)
);

// Global archive layout setting
$wp_customize->add_setting(
	'ansupa_archive_sidebar',
	array(
		'sanitize_callback' => 'ansupa_sanitize_select',
		'default' => 'right',
	)
);

$wp_customize->add_control(
	'ansupa_archive_sidebar',
	array(
		'section'		=> 'ansupa_global_layout',
		'label'			=> esc_html__( 'Archive Sidebar', 'ansupa' ),
		'description'			=> esc_html__( 'This option works on all archive pages like: 404, search, date, category, "Your latest posts" and so on.', 'ansupa' ),
		'type'			=> 'radio',
		'choices'		=> array( 
			'left' => esc_html__( 'Left', 'ansupa' ), 
			'right' => esc_html__( 'Right', 'ansupa' ), 
			'no' => esc_html__( 'No Sidebar', 'ansupa' ), 
		),
	)
);

// Global page layout setting
$wp_customize->add_setting(
	'ansupa_global_page_layout',
	array(
		'sanitize_callback' => 'ansupa_sanitize_select',
		'default' => 'right',
	)
);

$wp_customize->add_control(
	'ansupa_global_page_layout',
	array(
		'section'		=> 'ansupa_global_layout',
		'label'			=> esc_html__( 'Global page sidebar', 'ansupa' ),
		'description'			=> esc_html__( 'This option works only on single pages including "Posts page". This setting can be overridden for single page from the metabox too.', 'ansupa' ),
		'type'			=> 'radio',
		'choices'		=> array( 
			'left' => esc_html__( 'Left', 'ansupa' ), 
			'right' => esc_html__( 'Right', 'ansupa' ), 
			'no' => esc_html__( 'No Sidebar', 'ansupa' ), 
		),
	)
);

// Global post layout setting
$wp_customize->add_setting(
	'ansupa_global_post_layout',
	array(
		'sanitize_callback' => 'ansupa_sanitize_select',
		'default' => 'right',
	)
);

$wp_customize->add_control(
	'ansupa_global_post_layout',
	array(
		'section'		=> 'ansupa_global_layout',
		'label'			=> esc_html__( 'Global post sidebar', 'ansupa' ),
		'description'			=> esc_html__( 'This option works only on single posts. This setting can be overridden for single post from the metabox too.', 'ansupa' ),
		'type'			=> 'radio',
		'choices'		=> array( 
			'left' => esc_html__( 'Left', 'ansupa' ), 
			'right' => esc_html__( 'Right', 'ansupa' ), 
			'no' => esc_html__( 'No Sidebar', 'ansupa' ), 
		),
	)
);