<?php
/**
 * Blog/Archive section 
 */
// Blog/Archive section 
$wp_customize->add_section(
	'ansupa_archive_settings',
	array(
		'title' => esc_html__( 'Archive/Blog', 'ansupa' ),
		'description' => esc_html__( 'Settings for archive pages including blog page too.', 'ansupa' ),
		'panel' => 'ansupa_general_panel',
	)
);

// Archive excerpt length setting
$wp_customize->add_setting(
	'ansupa_archive_excerpt_length',
	array(
		'sanitize_callback' => 'ansupa_sanitize_number_range',
		'default' => 20,
	)
);

$wp_customize->add_control(
	'ansupa_archive_excerpt_length',
	array(
		'section'		=> 'ansupa_archive_settings',
		'label'			=> esc_html__( 'Excerpt more length:', 'ansupa' ),
		'type'			=> 'number',
		'input_attrs'   => array( 'min' => 5 ),
	)
);

// Date enable setting
$wp_customize->add_setting(
	'ansupa_enable_archive_author',
	array(
		'sanitize_callback' => 'ansupa_sanitize_checkbox',
		'default' => true,
	)
);

$wp_customize->add_control(
	'ansupa_enable_archive_author',
	array(
		'section'		=> 'ansupa_archive_settings',
		'label'			=> esc_html__( 'Enable author.', 'ansupa' ),
		'type'			=> 'checkbox',
	)
);

// Date enable setting
$wp_customize->add_setting(
	'ansupa_enable_archive_date',
	array(
		'sanitize_callback' => 'ansupa_sanitize_checkbox',
		'default' => true,
	)
);

$wp_customize->add_control(
	'ansupa_enable_archive_date',
	array(
		'section'		=> 'ansupa_archive_settings',
		'label'			=> esc_html__( 'Enable date.', 'ansupa' ),
		'type'			=> 'checkbox',
	)
);

// Category enable setting
$wp_customize->add_setting(
	'ansupa_enable_archive_cat',
	array(
		'sanitize_callback' => 'ansupa_sanitize_checkbox',
		'default' => true,
	)
);

$wp_customize->add_control(
	'ansupa_enable_archive_cat',
	array(
		'section'		=> 'ansupa_archive_settings',
		'label'			=> esc_html__( 'Enable category.', 'ansupa' ),
		'type'			=> 'checkbox',
	)
);

// Category enable setting
$wp_customize->add_setting(
	'ansupa_enable_archive_comment',
	array(
		'sanitize_callback' => 'ansupa_sanitize_checkbox',
		'default' => true,
	)
);

$wp_customize->add_control(
	'ansupa_enable_archive_comment',
	array(
		'section'		=> 'ansupa_archive_settings',
		'label'			=> esc_html__( 'Enable comment.', 'ansupa' ),
		'type'			=> 'checkbox',
	)
);

// blog image enable setting
$wp_customize->add_setting(
	'ansupa_enable_archive_featured_img',
	array(
		'sanitize_callback' => 'ansupa_sanitize_checkbox',
		'default' => true,
	)
);

$wp_customize->add_control(
	'ansupa_enable_archive_featured_img',
	array(
		'section'		=> 'ansupa_archive_settings',
		'label'			=> esc_html__( 'Enable featured image.', 'ansupa' ),
		'type'			=> 'checkbox',
	)
);

// Content type setting
$wp_customize->add_setting(
	'ansupa_enable_archive_content_type',
	array(
		'sanitize_callback' => 'ansupa_sanitize_select',
		'default' => 'excerpt',
	)
);

$wp_customize->add_control(
	'ansupa_enable_archive_content_type',
	array(
		'section'		=> 'ansupa_archive_settings',
		'label'			=> esc_html__( 'Content type:', 'ansupa' ),
		'choices'		=> array(
			'full-content' => esc_html__( 'Full content', 'ansupa' ), 
			'excerpt' => esc_html__( 'Excerpt', 'ansupa' ), 
		),
		'type'			=> 'radio',
	)
);

// Pagination type setting
$wp_customize->add_setting(
	'ansupa_archive_pagination_type',
	array(
		'sanitize_callback' => 'ansupa_sanitize_select',
		'default' => 'numeric',
	)
);

$archive_pagination_description = '';
$archive_pagination_choices = array( 
			'disable' => esc_html__( '--Disable--', 'ansupa' ),
			'numeric' => esc_html__( 'Numeric', 'ansupa' ),
			'older_newer' => esc_html__( 'Older / Newer', 'ansupa' ),
		);
if ( ! class_exists( 'JetPack' ) ) {
	$archive_pagination_description = sprintf( esc_html__( 'We recommend to install %1$sJetpack%2$s and enable %3$sInfinite Scroll%4$s feature for automatic loading of posts.', 'ansupa' ), '<a target="_blank" href="http://wordpress.org/plugins/jetpack">', '</a>', '<b>', '</b>' );
} else {
	$archive_pagination_choices['infinite_scroll'] = esc_html__( 'Infinite Load', 'ansupa' );
}
$wp_customize->add_control(
	'ansupa_archive_pagination_type',
	array(
		'section'		=> 'ansupa_archive_settings',
		'label'			=> esc_html__( 'Pagination type:', 'ansupa' ),
		'description'			=>  $archive_pagination_description,
		'type'			=> 'select',
		'choices'		=> $archive_pagination_choices,
	)
);

$wp_customize->add_setting(
	'ansupa_archive_layout',
	array(
		'sanitize_callback' => 'ansupa_sanitize_select',
		'default' => 'col-2',
	)
);

$wp_customize->add_control(
	'ansupa_archive_layout',
	array(
		'section'		=> 'ansupa_archive_settings',
		'label'			=> esc_html__( 'Archive Layout', 'ansupa' ),
		'type'			=> 'select',
		'choices'		=> array(
				'col-1' 		=> esc_html__( 'Column One', 'ansupa' ),
				'col-2' 		=> esc_html__( 'Column Two', 'ansupa' ),
				'col-3' 		=> esc_html__( 'Column Three', 'ansupa' ),
		),
	)
);