<?php
/**
 * Theme Ostrich Customizer
 *
 * @package ansupa
 *
 * trending_posts section
 */

$wp_customize->add_section(
	'ansupa_trending_posts',
	array(
		'title' => esc_html__( 'Trending Posts Section', 'ansupa' ),
		'panel' => 'ansupa_home_panel',
	)
);

// trending_posts enable settings
$wp_customize->add_setting(
	'ansupa_trending_posts',
	array(
		'sanitize_callback' => 'ansupa_sanitize_select',
		'default' => 'disable'
	)
);

$wp_customize->add_control(
	'ansupa_trending_posts',
	array(
		'section'		=> 'ansupa_trending_posts',
		'label'			=> esc_html__( 'Content type:', 'ansupa' ),
		'description'			=> esc_html__( 'Choose where you want to render the content from.', 'ansupa' ),
		'type'			=> 'select',
		'choices'		=> array( 
				'disable' => esc_html__( '--Disable--', 'ansupa' ),
				'post' => esc_html__( 'Post', 'ansupa' ),
		 	)
	)
);

// post_trending_posts number setting
$wp_customize->add_setting(
	'ansupa_trending_posts_excerpt',
	array(
		'sanitize_callback' => 'ansupa_sanitize_number_range',
		'default' => 20,
	)
);

$wp_customize->add_control(
	'ansupa_trending_posts_excerpt',
	array(
		'section'		=> 'ansupa_trending_posts',
		'label'			=> esc_html__( 'Number of excerpt text:', 'ansupa' ),
		'description'			=> esc_html__( 'Min: 5 | Max: 100', 'ansupa' ),
		'type'			=> 'number',
		'input_attrs'	=> array( 'min' => 5, 'max' => 100 ),
		'active_callback'	=> 'ansupa_if_trending_posts_enabled',
	)
);

for ($i=1; $i <= 3; $i++) { 
	// trending_posts post setting
	$wp_customize->add_setting(
		'ansupa_trending_posts_post_'.$i,
		array(
			'sanitize_callback' => 'ansupa_sanitize_dropdown_pages',
		)
	);

	$wp_customize->add_control(
		'ansupa_trending_posts_post_'.$i,
		array(
			'section'		=> 'ansupa_trending_posts',
			'label'			=> esc_html__( 'Post ', 'ansupa' ).$i,
			'active_callback' => 'ansupa_if_trending_posts_enabled',
			'type'			=> 'select',
			'choices'		=> ansupa_get_post_choices(),
		)
	);
}