<?php
/**
 * Theme Ostrich Customizer
 *
 * @package ansupa
 *
 * recent_posts section
 */

$wp_customize->add_section(
	'ansupa_recent_posts',
	array(
		'title' => esc_html__( 'Recent Posts Section', 'ansupa' ),
		'panel' => 'ansupa_home_panel',
	)
);

// recent_posts enable settings
$wp_customize->add_setting(
	'ansupa_recent_posts',
	array(
		'sanitize_callback' => 'ansupa_sanitize_select',
		'default' => 'disable'
	)
);

$wp_customize->add_control(
	'ansupa_recent_posts',
	array(
		'section'		=> 'ansupa_recent_posts',
		'label'			=> esc_html__( 'Content type:', 'ansupa' ),
		'description'			=> esc_html__( 'Choose where you want to render the content from.', 'ansupa' ),
		'type'			=> 'select',
		'choices'		=> array( 
				'disable' => esc_html__( '--Disable--', 'ansupa' ),
				'post' => esc_html__( 'Post', 'ansupa' ),
		 	)
	)
);

$wp_customize->add_setting(
	'ansupa_recent_posts_title',
	array(
		'sanitize_callback' => 'sanitize_text_field',
		'transport'	=> 'postMessage',
		'default'	=>  __('RECENT POST', 'ansupa'),
	)
);

$wp_customize->add_control(
	'ansupa_recent_posts_title',
	array(
		'section'		=> 'ansupa_recent_posts',
		'label'			=> esc_html__( 'Section Title:', 'ansupa' ),		
		'active_callback' => 'ansupa_if_recent_posts_enabled',
		
	)
);

$wp_customize->selective_refresh->add_partial( 
	'ansupa_recent_posts_title', 
	array(
        'selector'            => '#recent-post h2.section-title',
		'render_callback'     => 'ansupa_recent_posts_partial_title',
	) 
);

// post_recent_posts number setting
$wp_customize->add_setting(
	'ansupa_recent_posts_count',
	array(
		'sanitize_callback' => 'ansupa_sanitize_number_range',
		'default' => 3,
	)
);

$wp_customize->add_control(
	'ansupa_recent_posts_count',
	array(
		'section'		=> 'ansupa_recent_posts',
		'label'			=> esc_html__( 'Number of posts:', 'ansupa' ),
		'description'			=> esc_html__( 'Min: 1 | Max: 30', 'ansupa' ),
		'type'			=> 'number',
		'input_attrs'	=> array( 'min' => 1, 'max' => 30 ),
		'active_callback'	=> 'ansupa_if_recent_posts_enabled',
	)
);

$recent_posts_count = get_theme_mod( 'ansupa_recent_posts_count', 3 );

// post_recent_posts number setting
$wp_customize->add_setting(
	'ansupa_recent_posts_excerpt',
	array(
		'sanitize_callback' => 'ansupa_sanitize_number_range',
		'default' => 30,
	)
);

$wp_customize->add_control(
	'ansupa_recent_posts_excerpt',
	array(
		'section'		=> 'ansupa_recent_posts',
		'label'			=> esc_html__( 'Number of excerpt text:', 'ansupa' ),
		'description'			=> esc_html__( 'Min: 5 | Max: 100', 'ansupa' ),
		'type'			=> 'number',
		'input_attrs'	=> array( 'min' => 5, 'max' => 100 ),
		'active_callback'	=> 'ansupa_if_recent_posts_enabled',
	)
);

// recent_posts enable settings
$wp_customize->add_setting(
	'ansupa_recent_posts_column',
	array(
		'sanitize_callback' => 'ansupa_sanitize_select',
		'default' => 'col-3'
	)
);

$wp_customize->add_control(
	'ansupa_recent_posts_column',
	array(
		'section'		=> 'ansupa_recent_posts',
		'label'			=> esc_html__( 'Service Column Layout', 'ansupa' ),
		'description'			=> esc_html__( 'Choose column which are suitable for your section', 'ansupa' ),
		'type'			=> 'select',
		'active_callback'	=> 'ansupa_if_recent_posts_enabled',
		'choices'		=> array( 
				'col-3' => esc_html__( 'Three Column', 'ansupa' ),
				'col-4' => esc_html__( 'Four Column', 'ansupa' ),
		 	)
	)
);

for ($i=1; $i <= $recent_posts_count ; $i++) { 
	// recent_posts post setting
	$wp_customize->add_setting(
		'ansupa_recent_posts_post_'.$i,
		array(
			'sanitize_callback' => 'ansupa_sanitize_dropdown_pages',
		)
	);

	$wp_customize->add_control(
		'ansupa_recent_posts_post_'.$i,
		array(
			'section'		=> 'ansupa_recent_posts',
			'label'			=> esc_html__( 'Post ', 'ansupa' ).$i,
			'active_callback' => 'ansupa_if_recent_posts_enabled',
			'type'			=> 'select',
			'choices'		=> ansupa_get_post_choices(),
		)
	);
}