<?php
/**
 * Theme Ostrich Customizer
 *
 * @package ansupa
 *
 * latest_posts section
 */
$wp_customize->add_section(
	'ansupa_latest_posts',
	array(
		'title' => esc_html__( 'Latest Article', 'ansupa' ),
		'panel' => 'ansupa_home_panel',
	)
);

// blog enable settings
$wp_customize->add_setting(
	'ansupa_latest_posts',
	array(
		'sanitize_callback' => 'ansupa_sanitize_select',
		'default' => 'disable',
	)
);
$wp_customize->add_control(
	'ansupa_latest_posts',
	array(
		'section'		=> 'ansupa_latest_posts',
		'label'			=> esc_html__( 'Content type:', 'ansupa' ),
		'description'			=> esc_html__( 'Choose where you want to render the content from.', 'ansupa' ),
		'type'			=> 'select',
		'choices'		=> array(
				'disable' => esc_html__( '--Disable--', 'ansupa' ),
				'post' => esc_html__( 'Post', 'ansupa' ),
		 	)
	)
);

$wp_customize->add_setting(
	'ansupa_latest_posts_title',
	array(
		'sanitize_callback' => 'sanitize_text_field',
		'default' => esc_html__( 'LATEST ARTICLES', 'ansupa' ),
		'transport'	=> 'postMessage',
	)
);

$wp_customize->add_control(
	'ansupa_latest_posts_title',
	array(
		'section'		=> 'ansupa_latest_posts',
		'label'			=> esc_html__( 'Title:', 'ansupa' ),
		'active_callback'	=> 'ansupa_if_latest_posts_enabled',
	)
);

$wp_customize->selective_refresh->add_partial( 
	'ansupa_latest_posts_title', 
	array(
        'selector'            => '#latest h2.section-title',
		'render_callback'     => 'ansupa_latest_posts_partial_title',
	) 
);

// post_latest_posts number setting
$wp_customize->add_setting(
	'ansupa_latest_posts_excerpt',
	array(
		'sanitize_callback' => 'ansupa_sanitize_number_range',
		'default' => 45,
	)
);

$wp_customize->add_control(
	'ansupa_latest_posts_excerpt',
	array(
		'section'		=> 'ansupa_latest_posts',
		'label'			=> esc_html__( 'Number of excerpt text:', 'ansupa' ),
		'description'			=> esc_html__( 'Min: 5 | Max: 100', 'ansupa' ),
		'type'			=> 'number',
		'input_attrs'	=> array( 'min' => 5, 'max' => 100 ),
		'active_callback'	=> 'ansupa_if_latest_posts_enabled',
	)
);

for ($i=1; $i <= 1 ; $i++) {
	// blog post setting
	$wp_customize->add_setting(
		'ansupa_latest_posts_post_'.$i,
		array(
			'sanitize_callback' => 'ansupa_sanitize_dropdown_pages',
		)
	);
	$wp_customize->add_control(
		'ansupa_latest_posts_post_'.$i,
		array(
			'section'		=> 'ansupa_latest_posts',
			'label'			=> esc_html__( 'Post ', 'ansupa' ).$i,
			'active_callback' => 'ansupa_if_latest_posts_enabled',
			'type'			=> 'select',
			'choices'		=> ansupa_get_post_choices(),
		)
	);

}

$wp_customize->add_setting(
	'ansupa_latest_posts_video_url',
	array(
		'sanitize_callback' => 'esc_url_raw',
	)
);

$wp_customize->add_control(
	'ansupa_latest_posts_video_url',
	array(
		'section'		=> 'ansupa_latest_posts',
		'label'			=> esc_html__( 'Video Url:', 'ansupa' ),
		'type'			=> 'url',
		'active_callback'	=> 'ansupa_if_latest_posts_enabled',
	)
);