<?php
/**
 * Theme Ostrich Customizer
 *
 * @package ansupa
 *
 * design section
 */

$wp_customize->add_section(
	'ansupa_design',
	array(
		'title' => esc_html__( 'Design and Fashion Section', 'ansupa' ),
		'panel' => 'ansupa_home_panel',
	)
);

// design enable settings
$wp_customize->add_setting(
	'ansupa_design',
	array(
		'sanitize_callback' => 'ansupa_sanitize_select',
		'default' => 'disable'
	)
);

$wp_customize->add_control(
	'ansupa_design',
	array(
		'section'		=> 'ansupa_design',
		'label'			=> esc_html__( 'Content type:', 'ansupa' ),
		'description'			=> esc_html__( 'Choose where you want to render the content from.', 'ansupa' ),
		'type'			=> 'select',
		'choices'		=> array( 
				'disable' => esc_html__( '--Disable--', 'ansupa' ),
				'post' => esc_html__( 'Post', 'ansupa' ),
		 	)
	)
);

// post_design number setting
$wp_customize->add_setting(
	'ansupa_design_count',
	array(
		'sanitize_callback' => 'ansupa_sanitize_number_range',
		'default' => 5,
	)
);

$wp_customize->add_control(
	'ansupa_design_count',
	array(
		'section'		=> 'ansupa_design',
		'label'			=> esc_html__( 'Number of posts:', 'ansupa' ),
		'description'			=> esc_html__( 'Min: 1 | Max: 30', 'ansupa' ),
		'type'			=> 'number',
		'input_attrs'	=> array( 'min' => 1, 'max' => 30 ),
		'active_callback'	=> 'ansupa_if_design_enabled',
	)
);

$design_count = get_theme_mod( 'ansupa_design_count', 5 );

// design enable settings
$wp_customize->add_setting(
	'ansupa_design_autoplay',
	array(
		'sanitize_callback' => 'ansupa_sanitize_select',
		'default' => 'false',
	)
);

$wp_customize->add_control(
	'ansupa_design_autoplay',
	array(
		'section'		=> 'ansupa_design',
		'label'			=> esc_html__( 'Autoplay Enable/Disable', 'ansupa' ),
		'description'			=> esc_html__( 'If you want to autoplay design then choose Enable otherwise choose Disable', 'ansupa' ),
		'type'			=> 'select',
		'choices'		=> array( 
			'true' 	=> esc_html__( 'Enable', 'ansupa' ),
			'false' => esc_html__( 'Disable', 'ansupa' ),
		),
		'active_callback'	=> 'ansupa_if_design_enabled',
	)
);

for ($i=1; $i <= $design_count ; $i++) { 
	// design post setting
	$wp_customize->add_setting(
		'ansupa_design_post_'.$i,
		array(
			'sanitize_callback' => 'ansupa_sanitize_dropdown_pages',
		)
	);

	$wp_customize->add_control(
		'ansupa_design_post_'.$i,
		array(
			'section'		=> 'ansupa_design',
			'label'			=> esc_html__( 'Post ', 'ansupa' ).$i,
			'active_callback' => 'ansupa_if_design_enabled',
			'type'			=> 'select',
			'choices'		=> ansupa_get_post_choices(),
		)
	);
}