<?php
/**
 * Theme Ostrich Customizer
 *
 * @package ansupa
 *
 * blog_posts section
 */

$wp_customize->add_section(
	'ansupa_blog_posts',
	array(
		'title' => esc_html__( 'Blog Posts Section', 'ansupa' ),
		'panel' => 'ansupa_home_panel',
	)
);


ansupa_select_setting( $wp_customize, array(
	'section_id' => 'ansupa_blog_posts', 
	'setting_id' => 'ansupa_blog_posts', 
	'setting_value' => 'disable', 
	'setting_label' => esc_html__( 'Content Type', 'ansupa' ), 
	'setting_desc' => esc_html__( 'description', 'ansupa' ), 
	'setting_choices' => array( 
			'disable' => esc_html__( '--Disable--', 'ansupa' ),
			'post' => esc_html__( 'Post', 'ansupa' ),
			'cat' => esc_html__( 'Category', 'ansupa' ),
	 	),
	'setting_active_callback' => '' 
	)
);

ansupa_text_setting( $wp_customize, array(
	'section_id' => 'ansupa_blog_posts', 
	'setting_id' => 'ansupa_blog_posts_title', 
	'setting_value' => esc_html__( 'Section Title', 'ansupa' ), 
	'setting_label' => esc_html__( 'Section Title', 'ansupa' ), 
	'setting_desc' => '', 
	'setting_active_callback' => 'ansupa_if_blog_posts_enabled' 
	)
);

ansupa_number_setting( $wp_customize, array(
	'section_id' => 'ansupa_blog_posts', 
	'setting_id' => 'ansupa_blog_posts_count', 
	'setting_value' => 4, 
	'setting_label' => esc_html__( 'Post Counter', 'ansupa' ), 
	'setting_desc' => '', 
	'setting_active_callback' => 'ansupa_if_blog_posts_enabled' 
	)
);

$blog_posts_count = get_theme_mod( 'ansupa_blog_posts_count', 4 );

ansupa_number_setting( $wp_customize, array(
	'section_id' => 'ansupa_blog_posts', 
	'setting_id' => 'ansupa_blog_posts_excerpt', 
	'setting_value' => 20, 
	'setting_label' => esc_html__( 'Content Excerpt', 'ansupa' ), 
	'setting_desc' => '', 
	'setting_active_callback' => 'ansupa_if_blog_posts_enabled' 
	)
);


for ($i=1; $i <= $blog_posts_count ; $i++) { 

ansupa_select_setting( $wp_customize, array(
	'section_id' => 'ansupa_blog_posts', 
	'setting_id' => 'ansupa_blog_posts_post_'.$i, 
	'setting_value' => '', 
	'setting_label' => esc_html__( 'Select Post ', 'ansupa' ).$i, 
	'setting_desc' => '', 
	'setting_choices' => ansupa_get_post_choices(),
	'setting_active_callback' => 'ansupa_if_blog_posts_post' 
	)
);

}

ansupa_select_setting( $wp_customize, array(
	'section_id' => 'ansupa_blog_posts', 
	'setting_id' => 'ansupa_blog_posts_cat', 
	'setting_value' => '', 
	'setting_label' => esc_html__( 'Select Category ', 'ansupa' ), 
	'setting_desc' => '', 
	'setting_choices' => ansupa_get_post_cat_choices(),
	'setting_active_callback' => 'ansupa_if_blog_posts_cat' 
	)
);


ansupa_image_setting( $wp_customize, array(
	'section_id' => 'ansupa_blog_posts', 
	'setting_id' => 'ansupa_blog_posts_image', 
	'setting_value' => '', 
	'setting_label' => esc_html__( 'Select Image ', 'ansupa' ), 
	'setting_desc' => '', 
	'setting_active_callback' => 'ansupa_if_blog_posts_enabled' 
	)
);

ansupa_color_setting( $wp_customize, array(
	'section_id' => 'ansupa_blog_posts', 
	'setting_id' => 'ansupa_blog_posts_color', 
	'setting_value' => '', 
	'setting_label' => esc_html__( 'Select color ', 'ansupa' ), 
	'setting_desc' => '', 
	'setting_active_callback' => 'ansupa_if_blog_posts_enabled' 
	)
);

