<?php


function ansupa_select_setting( $wp_customize, $parameter=array() ) {

	$wp_customize->add_setting(
		$parameter['setting_id'],
		array(
			'sanitize_callback' => 'ansupa_sanitize_select',
			'default' => $parameter['setting_value'],
		)
	);

	$wp_customize->add_control(
		$parameter['setting_id'],
		array(
			'section'		=> $parameter['section_id'],
			'label'			=> $parameter['setting_label'],
			'description'			=> $parameter['setting_desc'],
			'type'			=> 'select',
			'active_callback' => $parameter['setting_active_callback'],
			'choices'		=> $parameter['setting_choices']
		)
	);
}

function ansupa_text_setting( $wp_customize, $parameter=array() ) {

	$wp_customize->add_setting(
		$parameter['setting_id'],
		array(
			'sanitize_callback' => 'sanitize_text_field',
			'default' => $parameter['setting_value'],
		)
	);

	$wp_customize->add_control(
		$parameter['setting_id'],
		array(
			'section'		=> $parameter['section_id'],
			'label'			=> $parameter['setting_label'],
			'description'			=> $parameter['setting_desc'],
			'type'			=> 'text',
			'active_callback' => $parameter['setting_active_callback'],
		)
	);
}

function ansupa_number_setting( $wp_customize, $parameter=array() ) {

	$wp_customize->add_setting(
		$parameter['setting_id'],
		array(
			'sanitize_callback' => 'ansupa_sanitize_number_range',
			'default' => $parameter['setting_value'],
		)
	);

	$wp_customize->add_control(
		$parameter['setting_id'],
		array(
			'section'		=> $parameter['section_id'],
			'label'			=> $parameter['setting_label'],
			'description'			=> $parameter['setting_desc'],
			'type'			=> 'number',
			'input_attrs'	=> array( 'min' => 0 ),
			'active_callback' => $parameter['setting_active_callback'],
		)
	);
}

function ansupa_image_setting( $wp_customize, $parameter=array() ) {

	$wp_customize->add_setting(
		$parameter['setting_id'],
		array(
			'sanitize_callback' => 'ansupa_sanitize_number_range',
			'default' => $parameter['setting_value'],
		)
	);

	$wp_customize->add_control(  new WP_Customize_Image_Control( $wp_customize,
		$parameter['setting_id'],
		array(
			'section'		=> $parameter['section_id'],
			'label'			=> $parameter['setting_label'],
			'description'			=> $parameter['setting_desc'],
			'active_callback' => $parameter['setting_active_callback'],
			)
		)
	);
}


function ansupa_color_setting( $wp_customize, $parameter=array() ) {

	$wp_customize->add_setting(
		$parameter['setting_id'],
		array(
			'sanitize_callback' => 'ansupa_sanitize_number_range',
			'default' => $parameter['setting_value'],
		)
	);

	$wp_customize->add_control(  new WP_Customize_Color_Control( $wp_customize,
		$parameter['setting_id'],
		array(
			'section'		=> $parameter['section_id'],
			'label'			=> $parameter['setting_label'],
			'description'			=> $parameter['setting_desc'],
			'active_callback' => $parameter['setting_active_callback'],
			)
		)
	);
}

