<?php
/**
 * Theme Ostrich Customizer
 *
 * @package ansupa
 */

/**
 * Get all the default values of the theme mods.
 */
function ansupa_get_default_mods() {
	$ansupa_default_mods = array(
		// Footer copyright
		'ansupa_copyright_txt' => esc_html__( 'Copyright &copy; [the-year] [site-link]  |  ', 'ansupa' ),
		'ansupa_power_by_txt'	=> sprintf( esc_html__( 'Theme: %1$s by %2$s.', 'ansupa' ), 'ansupa', '<a href="' . esc_url( 'http://themeostrich.com/' ) . '">Theme Ostrichs</a>' ),
	);

	return apply_filters( 'ansupa_default_mods', $ansupa_default_mods );
}

/**
 * Add postMessage support for site title and description for the Theme Customizer.
 *
 * @param WP_Customize_Manager $wp_customize Theme Customizer object.
 */
function ansupa_customize_register( $wp_customize ) {

	// Custom Controller
	require get_parent_theme_file_path( '/inc/customizer/custom-controller.php' );

	require get_parent_theme_file_path( '/inc/customizer/helper-function.php' );

	$default = ansupa_get_default_mods();

	$wp_customize->get_setting( 'blogname' )->transport         = 'postMessage';
	$wp_customize->get_setting( 'blogdescription' )->transport  = 'postMessage';
	$wp_customize->get_setting( 'header_textcolor' )->transport = 'postMessage';

	if ( isset( $wp_customize->selective_refresh ) ) {
		$wp_customize->selective_refresh->add_partial( 'blogname', array(
			'selector'        => '.site-title a',
			'render_callback' => 'ansupa_customize_partial_blogname',
		) );
		$wp_customize->selective_refresh->add_partial( 'blogdescription', array(
			'selector'        => '.site-description',
			'render_callback' => 'ansupa_customize_partial_blogdescription',
		) );
	}

	//Color Panel

	// Header tagline color setting
	$wp_customize->add_setting(	
		'ansupa_header_tagline',
		array(
			'sanitize_callback' => 'ansupa_sanitize_hex_color',
			'default' => '#929292',
			'transport'	=> 'postMessage',
		)
	);

	$wp_customize->add_control(
		new WP_Customize_Color_Control( 
		$wp_customize,
			'ansupa_header_tagline',
			array(
				'section'		=> 'colors',
				'label'			=> esc_html__( 'Site tagline Color:', 'ansupa' ),
			)
		)
	);


	// Header text display setting
	$wp_customize->add_setting(	
		'ansupa_header_text_display',
		array(
			'sanitize_callback' => 'ansupa_sanitize_checkbox',
			'default' => true,
			'transport'	=> 'postMessage',
		)
	);

	$wp_customize->add_control(
		'ansupa_header_text_display',
		array(
			'section'		=> 'title_tagline',
			'type'			=> 'checkbox',
			'label'			=> esc_html__( 'Display Site Title and Tagline', 'ansupa' ),
		)
	);

	// Your latest posts title setting
	$wp_customize->add_setting(	
		'ansupa_your_latest_posts_title',
		array(
			'sanitize_callback' => 'sanitize_text_field',
			'default' => esc_html__( 'Blogs', 'ansupa' ),
			'transport'	=> 'postMessage',
		)
	);

	$wp_customize->add_control(
		'ansupa_your_latest_posts_title',
		array(
			'section'		=> 'static_front_page',
			'label'			=> esc_html__( 'Title:', 'ansupa' ),
			'active_callback' => 'ansupa_is_latest_posts'
		)
	);

	$wp_customize->selective_refresh->add_partial( 
		'ansupa_your_latest_posts_title', 
		array(
	        'selector'            => '.home.blog #page-header .page-title',
			'render_callback'     => 'ansupa_your_latest_posts_partial_title',
    	) 
    );

    $wp_customize->add_setting( 'ansupa_enable_content', array(
		'sanitize_callback'   => 'ansupa_sanitize_checkbox',
		'default'             => false,
	) );

	$wp_customize->add_control( 'ansupa_enable_content', array(
		'label'       	=> esc_html__( 'Enable Content', 'ansupa' ),
		'description' 	=> esc_html__( 'Check to enable content on static front page only.', 'ansupa' ),
		'section'     	=> 'static_front_page',
		'type'        	=> 'checkbox',
	) );


	/**
	 * 
	 * Front Section
	 * 
	 */ 

	// Home sections panel
	$wp_customize->add_panel(
		'ansupa_home_panel',
		array(
			'title' => esc_html__( 'Homepage Options', 'ansupa' ),
			'priority' => 105
		)
	);

	//top-bar
    require get_parent_theme_file_path( '/inc/customizer/homepage/top-bar.php' );
	
	//design
    require get_parent_theme_file_path( '/inc/customizer/homepage/design.php' );

    //recent-posts
	require get_parent_theme_file_path( '/inc/customizer/homepage/recent-posts.php' );

    //latest-posts
	require get_parent_theme_file_path( '/inc/customizer/homepage/latest-posts.php' ); 

    //trending-posts
	require get_parent_theme_file_path( '/inc/customizer/homepage/trending-posts.php' ); 

    //blog
	require get_parent_theme_file_path( '/inc/customizer/homepage/blog.php' );  

    // theme options
	$wp_customize->add_panel(
		'ansupa_general_panel',
		array(
			'title' => esc_html__( 'Theme Options', 'ansupa' ),
			'priority' => 107
		)
	);

	require get_parent_theme_file_path( '/inc/customizer/theme-options/general-setting.php' );

	require get_parent_theme_file_path( '/inc/customizer/theme-options/layout.php' );

	require get_parent_theme_file_path( '/inc/customizer/theme-options/post.php' );

	require get_parent_theme_file_path( '/inc/customizer/theme-options/page.php' );

	require get_parent_theme_file_path( '/inc/customizer/theme-options/archive.php' );

	require get_parent_theme_file_path( '/inc/customizer/theme-options/footer.php' );

	/**
	 * Reset all settings
	 */
	// Reset settings section
	$wp_customize->add_section(
		'ansupa_reset_sections',
		array(
			'title' => esc_html__( 'Reset all', 'ansupa' ),
			'description' => esc_html__( 'Reset all settings to default.', 'ansupa' ),
			'panel' => 'ansupa_general_panel',
		)
	);

	// Reset sortable order setting
	$wp_customize->add_setting(
		'ansupa_reset_settings',
		array(
			'sanitize_callback' => 'ansupa_sanitize_checkbox',
			'default' => false,
			'transport'	=> 'postMessage',
		)
	);

	$wp_customize->add_control(
		'ansupa_reset_settings',
		array(
			'section'		=> 'ansupa_reset_sections',
			'label'			=> esc_html__( 'Reset all settings?', 'ansupa' ),
			'type'			=> 'checkbox',
		)
	);
}
add_action( 'customize_register', 'ansupa_customize_register' );


// Sanitize Callback
require get_parent_theme_file_path( '/inc/customizer/sanitize-callback.php' );

// active Callback
require get_parent_theme_file_path( '/inc/customizer/active-callback.php' );

// Partial Refresh
require get_parent_theme_file_path( '/inc/customizer/partial-refresh.php' );


/**
 * Render the site title for the selective refresh partial.
 *
 * @return void
 */
function ansupa_customize_partial_blogname() {
	bloginfo( 'name' );
}

/**
 * Render the site tagline for the selective refresh partial.
 *
 * @return void
 */
function ansupa_customize_partial_blogdescription() {
	bloginfo( 'description' );
}

/**
 * Binds JS handlers to make Theme Customizer preview reload changes asynchronously.
 */
function ansupa_customize_preview_js() {
	wp_enqueue_script( 'ansupa-customizer', get_theme_file_uri( '/assets/js/customizer.js' ), array( 'customize-preview' ), '20151215', true );
}
add_action( 'customize_preview_init', 'ansupa_customize_preview_js' );

/**
 * Binds JS handlers for Customizer controls.
 */
function ansupa_customize_control_js() {


	wp_enqueue_style( 'ansupa-customize-style', get_theme_file_uri( '/assets/css/customize-controls.css' ), array(), '20151215' );
	
	wp_enqueue_script( 'ansupa-customize-control', get_theme_file_uri( '/assets/js/customize-control.js' ), array( 'jquery', 'customize-controls' ), '20151215', true );

	$localized_data = array( 
		'refresh_msg' => esc_html__( 'Refresh the page after Save and Publish.', 'ansupa' ),
		'reset_msg' => esc_html__( 'Warning!!! This will reset all the settings. Refresh the page after Save and Publish to reset all.', 'ansupa' ),
	);

	wp_localize_script( 'ansupa-customize-control', 'localized_data', $localized_data );
}
add_action( 'customize_controls_enqueue_scripts', 'ansupa_customize_control_js' );
