<?php
/**
 * Theme Ostrich 
 *
 * @package ansupa
 * active callbacks.
 * 
 */

/*===================Topbar=========================*/
/**
 * Check if the top_bar is enabled.
 */
function ansupa_if_top_bar_enabled( $control ) {
	return $control->manager->get_setting( 'ansupa_top_bar' )->value();
}


/*========================Design and Fashion==============================*/
/**
 * Check if the design is enabled
 */
function ansupa_if_design_enabled( $control ) {
	return 'disable' != $control->manager->get_setting( 'ansupa_design' )->value();
}

/*========================recent_posts==============================*/
/**
 * Check if the recent_posts is enabled
 */
function ansupa_if_recent_posts_enabled( $control ) {
	return 'disable' != $control->manager->get_setting( 'ansupa_recent_posts' )->value();
}

/*==========================Latest Posts=========================*/
/**
 * Check if the latest_posts is enabled
 */
function ansupa_if_latest_posts_enabled( $control ) {
	return 'disable' != $control->manager->get_setting( 'ansupa_latest_posts' )->value();
}

/*========================trending_posts==============================*/
/**
 * Check if the trending_posts is enabled
 */
function ansupa_if_trending_posts_enabled( $control ) {
	return 'disable' != $control->manager->get_setting( 'ansupa_trending_posts' )->value();
}

/*========================blog_posts==============================*/
/**
 * Check if the blog_posts is enabled
 */
function ansupa_if_blog_posts_enabled( $control ) {
	return 'disable' != $control->manager->get_setting( 'ansupa_blog_posts' )->value();
}

/**
 * Check if the blog_posts is category
 */
function ansupa_if_blog_posts_cat( $control ) {
	return 'cat' === $control->manager->get_setting( 'ansupa_blog_posts' )->value();
}

/**
 * Check if the blog_posts is post
 */
function ansupa_if_blog_posts_post( $control ) {
	return 'post' === $control->manager->get_setting( 'ansupa_blog_posts' )->value();
}

/*===================Footer=========================*/
/**
 * Check if the footer text is enabled
 */
function ansupa_if_footer_text_enable( $control ) {
	return $control->manager->get_setting( 'ansupa_enable_footer_text' )->value();
}

