<?php
/**
 * The header for our theme
 *
 * This is the template that displays all of the <head> section and everything up until <div id="content">
 *
 * @link https://developer.wordpress.org/themes/basics/template-files/#template-partials
 *
 * @package ansupa
 */
?>
<!doctype html>
<html <?php language_attributes(); ?> >
<head>
	<meta charset="<?php bloginfo( 'charset' ); ?>">
	<meta name="viewport" content="width=device-width, initial-scale=1">
	<link rel="profile" href="https://gmpg.org/xfn/11">

	<?php wp_head(); ?>
</head>
 
<body <?php body_class(); ?>>

<?php do_action( 'wp_body_open' ); ?>
<div id="page" class="site">
	<a class="skip-link screen-reader-text" href="#content"><?php esc_html_e( 'Skip to content', 'ansupa' ); ?></a>
    
    <div class="menu-overlay"></div>

<?php if ( get_theme_mod( 'ansupa_top_bar', 'true' ) == true ): ?>
    <div id="top-bar" class="relative">
        <div class="container">

            <nav id="secondary-navigation" class="main-navigation" role="navigation" aria-label="Primary Menu">
                <button class="menu-toggle" aria-controls="secondary-menu" aria-expanded="false">
                    <svg viewBox="0 0 40 40" class="icon-menu">
                        <rect y="7" width="40" height="2"></rect>
                        <rect y="19" width="40" height="2"></rect>
                        <rect y="31" width="40" height="2"></rect>
                    </svg>

                    <svg viewBox="0 0 612 612" class="icon-close">
                        <polygon points="612,36.004 576.521,0.603 306,270.608 35.478,0.603 0,36.004 270.522,306.011 0,575.997 35.478,611.397 
                        306,341.411 576.521,611.397 612,575.997 341.459,306.011"></polygon>
                    </svg>
                    <span class="menu-label"><?php echo esc_html__('Menu', 'ansupa'); ?></span>
                </button><!-- .menu-toggle -->
                <?php 
                if ( get_theme_mod( 'ansupa_top_bar_menu', true )) {
                if ( has_nav_menu( 'secondary' ) ) : ?>                    
                    <?php
                    wp_nav_menu( array(
                        'theme_location' => 'secondary',
                        'container'      => 'ul',
                        'menu_id'        => 'secondary-menu',
                        'menu_class'     => 'menu nav-menu',                    
                    ) );
                    ?>
                    <?php elseif( current_user_can( 'edit_theme_options' ) ): ?>
                        <ul id="secondary-menu" class="menu nav-menu">
                            <li><a href="<?php echo esc_url( admin_url( 'nav-menus.php' ) ); ?>"><?php echo esc_html__( 'Add a menu', 'ansupa' );?></a></li>
                        </ul>
                    <?php endif;

                    } ?> 

                    <?php 
                    if ( get_theme_mod( 'ansupa_top_bar_social_menu', true )) {
                        if ( has_nav_menu( 'social' ) ) :
                            ?>
                            <div class="social-icons">
                                <?php  
                                wp_nav_menu( array(
                                    'theme_location' => 'social',
                                    'container' => false,
                                    'menu_class' => 'menu',
                                    'echo' => true,
                                    'depth' => 1,
                                    'link_before' => '<span class="screen-reader-text">',
                                    'link_after' => '</span>',
                                ) );
                                ?>
                            </div><!-- .social-icons -->
                            <?php elseif( current_user_can( 'edit_theme_options' ) ): ?>
                                <div class="social-icons">
                                   <ul class="menu">
                                    <a href="<?php echo esc_url( admin_url( 'nav-menus.php' ) ); ?>"><?php echo esc_html__( 'Add a menu', 'ansupa' );?></a>
                                </ul>
                            </div>
                            <?php
                        endif;
                    }
                    ?>
                </nav><!-- .main-navigation-->

            </div><!-- .container -->
        </div><!-- #top-bar -->   

<?php endif; ?>
    <?php get_template_part( 'template-parts/header' );  ?>
    
	<div id="content" class="site-content">
