<?php
/**
 * Template Name: Home Page
 */

get_header();
?>

<main id="primary">

    <?php 
    $forest_safari_main_slider_wrap = absint(get_theme_mod('forest_safari_enable_slider', 0));
    if($forest_safari_main_slider_wrap == 1){ 
    ?>
        <section id="main-slider-wrap">
            <div class="owl-carousel">
                <?php for ($forest_safari_i=1; $forest_safari_i <= 3; $forest_safari_i++) { ?>
                    <div class="main-slider-inner-box">
                        <?php if ( get_theme_mod('forest_safari_slider_image'.$forest_safari_i) ) : ?>
                            <img src="<?php echo esc_url( get_theme_mod('forest_safari_slider_image'.$forest_safari_i) ); ?>">
                            <div class="main-slider-content-box">
                                <?php if ( get_theme_mod('forest_safari_slider_heading'.$forest_safari_i) ) : ?><h3><?php echo esc_html( get_theme_mod('forest_safari_slider_heading'.$forest_safari_i) ); ?></h3><?php endif; ?>
                                <?php if ( get_theme_mod('forest_safari_slider_text'.$forest_safari_i) ) : ?><p><?php echo esc_html( get_theme_mod('forest_safari_slider_text'.$forest_safari_i) ); ?></p><?php endif; ?>
                                <div class="main-slider-button">
                                    <?php if ( get_theme_mod('forest_safari_slider_button1_link'.$forest_safari_i) ||  get_theme_mod('forest_safari_slider_button1_text'.$forest_safari_i )) : ?><a href="<?php echo esc_url( get_theme_mod('forest_safari_slider_button1_link'.$forest_safari_i) ); ?>"><?php echo esc_html( get_theme_mod('forest_safari_slider_button1_text'.$forest_safari_i) ); ?></a><?php endif; ?>
                                </div>
                            </div>
                        <?php endif; ?>
                    </div>
                <?php } ?>
            </div>
        </section>
    <?php } ?>

    <?php 
    $forest_safari_main_expert_wrap = absint(get_theme_mod('forest_safari_enable_aboutus', 0));
    if($forest_safari_main_expert_wrap == 1){ 
    ?>
        <section id="main-expert-wrap">
            <div class="container"> 
                <div class="flex-row">
                    <div class="aboutus-left">
                        <?php if ( get_theme_mod('forest_safari_aboutus_short_heading') ) : ?>
                            <h5><?php echo esc_html( get_theme_mod('forest_safari_aboutus_short_heading') ); ?></h5>
                        <?php endif; ?>
                        <?php if ( get_theme_mod('forest_safari_aboutus_heading') ) : ?>
                            <h3><?php echo esc_html( get_theme_mod('forest_safari_aboutus_heading') ); ?></h3>
                        <?php endif; ?>
                        <?php if ( get_theme_mod('forest_safari_aboutus_text') ) : ?>
                            <p><?php echo esc_html( get_theme_mod('forest_safari_aboutus_text') ); ?></p>
                        <?php endif; ?>
                        <div class="main-about-button">
                            <?php if ( get_theme_mod('animal_sanctuary_about_button1_link') ||  get_theme_mod('animal_sanctuary_about_button1_text')) : ?><a href="<?php echo esc_url( get_theme_mod('animal_sanctuary_about_button1_link') ); ?>"><?php echo esc_html( get_theme_mod('animal_sanctuary_about_button1_text') ); ?></a>
                            <?php endif; ?>
                        </div>
                    </div>
                    <div class="aboutus-center">
                        <div class="box-image">
                            <?php if ( get_theme_mod('forest_safari_aboutus_image') ) : ?><img src="<?php echo esc_url( get_theme_mod('forest_safari_aboutus_image') ); ?>"><?php endif; ?>
                        </div>
                    </div>
                    <div class="aboutus-right">
                        <div class="progress-block">
                            <?php
                            $animal_sanctuary_rescue_percentage   = get_theme_mod('animal_sanctuary_rescue_percentage', 0);
                            $animal_sanctuary_adoption_percentage = get_theme_mod('animal_sanctuary_adoption_percentage', 0);
                            $animal_sanctuary_wildlife_percentage = get_theme_mod('animal_sanctuary_wildlife_percentage', 0);
                            ?>

                            <?php if ( intval( $animal_sanctuary_rescue_percentage ) > 0 ) : ?>
                                <div class="progress-row">
                                    <div class="progress-label">
                                        <?php echo esc_html__('Rescue & Rehabilitation', 'animal-sanctuary'); ?>
                                        <span class="progress-value">
                                            <?php 
                                            /* translators: %d%% is a percentage value */
                                            printf( esc_html__( '%d%%', 'animal-sanctuary' ), intval($animal_sanctuary_rescue_percentage) ); ?>
                                        </span>
                                    </div>
                                    <div class="progress-bar">
                                        <div class="progress-fill" style="width:<?php echo esc_attr( intval($animal_sanctuary_rescue_percentage) . '%' ); ?>"></div>
                                    </div>
                                </div>
                            <?php endif; ?>

                            <?php if ( intval( $animal_sanctuary_adoption_percentage ) > 0 ) : ?>
                                <div class="progress-row">
                                    <div class="progress-label">
                                        <?php echo esc_html__('Adoption & Rehoming', 'animal-sanctuary'); ?>
                                        <span class="progress-value">
                                            <?php 
                                            /* translators: %d%% is a percentage value */
                                            printf( esc_html__( '%d%%', 'animal-sanctuary' ), intval($animal_sanctuary_adoption_percentage) ); ?>
                                        </span>
                                    </div>
                                    <div class="progress-bar">
                                        <div class="progress-fill" style="width:<?php echo esc_attr( intval($animal_sanctuary_adoption_percentage) . '%' ); ?>"></div>
                                    </div>
                                </div>
                            <?php endif; ?>

                            <?php if ( intval( $animal_sanctuary_wildlife_percentage ) > 0 ) : ?>
                                <div class="progress-row last-bar">
                                    <div class="progress-label">
                                        <?php echo esc_html__('Wildlife Protection', 'animal-sanctuary'); ?>
                                        <span class="progress-value">
                                            <?php 
                                            /* translators: %d%% is a percentage value */
                                            printf( esc_html__( '%d%%', 'animal-sanctuary' ), intval($animal_sanctuary_wildlife_percentage) ); ?>
                                        </span>
                                    </div>
                                    <div class="progress-bar">
                                        <div class="progress-fill" style="width:<?php echo esc_attr( intval($animal_sanctuary_wildlife_percentage) . '%' ); ?>"></div>
                                    </div>
                                </div>
                            <?php endif; ?>
                        </div>
                        <?php 
                            $animal_sanctuary_total_yr_experience = get_theme_mod( 'animal_sanctuary_total_yr_experience', '' );
                            if ( $animal_sanctuary_total_yr_experience ) : ?>
                                <div class="satified-box mb-md-0 mb-2">
                                <div class="start-yr-content">
                                    <div class="start-yr mb-2"><?php echo esc_html( $animal_sanctuary_total_yr_experience ); ?></div>
                                    <div class="year-text mt-3"><?php esc_html_e( 'Years Of Experience', 'animal-sanctuary' ); ?></div>
                                </div>
                                </div>
                        <?php endif; ?>
                    </div>
                </div>
            </div>
        </section>
    <?php } ?>
</main>
<?php
get_footer();