<?php
/**
 * The header for our theme
 *
 * @package Animal Sanctuary
 */

?>
<!doctype html>
<html <?php language_attributes(); ?>>
<head>
    <meta charset="<?php bloginfo( 'charset' ); ?>">
    <meta name="viewport" content="width=device-width, initial-scale=1">
    <link rel="profile" href="https://gmpg.org/xfn/11">

    <?php wp_head(); ?>
</head>

<body <?php body_class(); ?>>
<?php wp_body_open(); ?>
<div id="page" class="site">
    <a class="skip-link screen-reader-text" href="#primary"><?php esc_html_e( 'Skip to content', 'animal-sanctuary' ); ?></a>

    <?php
        $forest_safari_preloader_wrap = absint(get_theme_mod('forest_safari_enable_preloader', 0));
        if($forest_safari_preloader_wrap == 1){ ?>
            <div id="loader">
                <div class="loader-container">
                    <div id="preloader" class="loader-2">
                        <div class="dot"></div>
                    </div>
                </div>
            </div>
    <?php } ?>

    <header id="masthead" class="site-header">
        <?php $forest_safari_has_header_image = has_header_image(); ?>
        <div class="main-header-wrap">
            <div class="top-box">
                <div class="container">
                    <div class="flex-row">
                        <div class="nav-box-header-left">
                            <?php if ( get_theme_mod('forest_safari_header_topbar_text','For financial peace of mind you can trust Fintech') ) : ?><p><?php echo esc_html( get_theme_mod('forest_safari_header_topbar_text','For financial peace of mind you can trust Fintech') ); ?></p><?php endif; ?>
                        </div>
                        <div class="nav-box-header-right">
                            <?php if ( get_theme_mod('forest_safari_topbar_button1_link','#') ||  get_theme_mod('forest_safari_topbar_button1_text','Help' )) : ?><a href="<?php echo esc_url( get_theme_mod('forest_safari_topbar_button1_link','#') ); ?>"><?php echo esc_html( get_theme_mod('forest_safari_topbar_button1_text','Help') ); ?></a><?php endif; ?>
                            <?php if ( get_theme_mod('forest_safari_topbar_button2_link','#') ||  get_theme_mod('forest_safari_topbar_button2_text','What We Do' )) : ?><a href="<?php echo esc_url( get_theme_mod('forest_safari_topbar_button2_link','#') ); ?>"><?php echo esc_html( get_theme_mod('forest_safari_topbar_button2_text','What We Do') ); ?></a><?php endif; ?>
                            <?php if ( get_theme_mod('forest_safari_topbar_button3_link','#') ||  get_theme_mod('forest_safari_topbar_button3_text','Faqs' )) : ?><a href="<?php echo esc_url( get_theme_mod('forest_safari_topbar_button3_link','#') ); ?>"><?php echo esc_html( get_theme_mod('forest_safari_topbar_button3_text','Faqs') ); ?></a><?php endif; ?>
                        </div>
                        <div class="header-search">
                            <?php if( get_theme_mod( 'forest_safari_header_search',true) == 1) { ?>
                                 <span class="search-bar">
                                <button type="button" class="open-search"><i class="fas fa-search"></i></button>
                            </span>
                            <?php }?>
                        </div>
                    </div>
                    <div class="search-outer">
                        <div class="inner_searchbox">
                            <?php get_search_form(); ?>
                        </div>
                        <button type="button" class="search-close"><i class="fa fa-window-close"></i></button>
                    </div>
                </div>
            </div>
        </div>
        <div class="header-info-box" <?php if (!empty($forest_safari_has_header_image)) { ?> style="background-image: url(<?php echo header_image(); ?>);" <?php } ?> >
            <div class="container">
                <div class="flex-row">
                    <div class="header-info-left">
                        <div class="site-branding">
                            <?php
                            the_custom_logo();
                            if ( is_front_page() && is_home() ) :
                                ?>
                                <?php if( get_theme_mod('forest_safari_site_title_text',true)){ ?>
                                    <h1 class="site-title"><a href="<?php echo esc_url( home_url( '/' ) ); ?>" rel="home"><?php bloginfo( 'name' ); ?></a></h1>
                                <?php } ?>
                                <?php
                            else :
                                ?>
                                <?php if( get_theme_mod('forest_safari_site_title_text',true)){ ?>
                                    <p class="site-title"><a href="<?php echo esc_url( home_url( '/' ) ); ?>" rel="home"><?php bloginfo( 'name' ); ?></a></p>
                                <?php } ?>
                                <?php
                            endif; ?>
                            <?php $forest_safari_description = get_bloginfo( 'description', 'display' );
                                if ( $forest_safari_description || is_customize_preview() ) :
                                ?>
                                <?php if( get_theme_mod('forest_safari_site_tagline_text',false)){ ?>
                                    <p class="site-description"><?php echo $forest_safari_description; ?></p>
                                <?php } ?>
                            <?php endif; ?>
                        </div>
                    </div>
                    <div class="header-info-right">
                        <?php if ( get_theme_mod('forest_safari_header_info_address','') ) : ?><p><i class="<?php echo esc_attr(get_theme_mod('forest_safari_header_location_icon','fas fa-map-marker-alt')); ?>"></i> <?php echo esc_html( get_theme_mod('forest_safari_header_info_address','') ); ?></p><?php endif; ?>
                        <?php if ( get_theme_mod('forest_safari_header_info_phone','') ) : ?>
                            <p class="phone-box">
                                <i class="<?php echo esc_attr(get_theme_mod('forest_safari_header_phone_icon','fas fa-phone-volume')); ?>"></i> 
                                <a href="tel:<?php echo esc_html( get_theme_mod('forest_safari_header_info_phone','') ); ?>">
                                    <?php echo esc_html( get_theme_mod('forest_safari_header_info_phone','') ); ?>
                                </a>
                            </p>
                        <?php endif; ?>
                        <?php if ( get_theme_mod('forest_safari_header_info_email','') ) : ?>
                            <p class="mail-box">
                                <i class="<?php echo esc_attr(get_theme_mod('forest_safari_header_mail_icon','far fa-envelope-open')); ?>"></i> 
                                <a href="mailto:<?php echo esc_html( get_theme_mod('forest_safari_header_info_email','') ); ?>">
                                    <?php echo esc_html( get_theme_mod('forest_safari_header_info_email','') ); ?>
                                </a>
                            </p>
                        <?php endif; ?>
                    </div>
                </div>
            </div>
        </div>

        <div class="header-menu-box <?php echo esc_attr( get_theme_mod( 'forest_safari_enable_sticky_header', false ) ? 'sticky-header' : '' ); ?>">
            <div class="container">
                <div class="flex-row">
                    <div class="nav-box-header-left">
                        <nav id="site-navigation" class="main-navigation">
                            <button class="menu-toggle" aria-controls="primary-menu" aria-expanded="false"><i class="fas fa-bars"></i></button>
                            <?php
                                wp_nav_menu(
                                    array(
                                        'theme_location' => 'menu-1',
                                        'menu_id'        => 'primary-menu',
                                    )
                                );
                            ?>
                        </nav>
                    </div>
                    <div class="nav-box-header-right">
                        <div class="header-button">
                            <?php if ( get_theme_mod('forest_safari_header_button_link','#') ||  get_theme_mod('forest_safari_header_button_text','REQUEST A QUOTE' )) : ?><a href="<?php echo esc_url( get_theme_mod('forest_safari_header_button_link','#') ); ?>"><?php echo esc_html( get_theme_mod('forest_safari_header_button_text','REQUEST A QUOTE') ); ?></a><?php endif; ?>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </header>