<?php

// Enqueue parent and child styles
function animal_sanctuary_child_enqueue_styles() {

    // 1. Load parent theme CSS
    wp_enqueue_style(
        'forest-safari-style', // Parent handle
        get_template_directory_uri() . '/style.css',
        array(),
        FOREST_SAFARI_VERSION
    );

    // 2. Load child theme CSS (depends on parent)
    wp_enqueue_style(
        'forest-safari-child-style',
        get_stylesheet_directory_uri() . '/style.css',
        array('forest-safari-style'),
        wp_get_theme()->get('Version')
    );
}
add_action( 'wp_enqueue_scripts', 'animal_sanctuary_child_enqueue_styles' );

// Enqueue child theme JS in addition to parent JS
function animal_sanctuary_child_scripts() {

    // Load child custom JS
    wp_enqueue_script(
        'forest-safari-child-js',
        get_stylesheet_directory_uri() . '/revolution/assets/js/custom.js', // <-- your file in child theme
        array('jquery'), // load after jQuery
        wp_get_theme()->get('Version'),
        true
    );
}
add_action( 'wp_enqueue_scripts', 'animal_sanctuary_child_scripts' );

// Theme setup
if (!function_exists('animal_sanctuary_setup')) :
    function animal_sanctuary_setup() {
        load_theme_textdomain( 'animal-sanctuary', get_template_directory() . '/languages' );
        add_theme_support('automatic-feed-links');
        add_theme_support('title-tag');
        add_theme_support('custom-header');
        add_theme_support('responsive-embeds');
        add_theme_support('post-thumbnails');
        add_theme_support('align-wide');
        add_editor_style(array('assets/css/editor-style.css'));
        add_theme_support('custom-background', apply_filters('animal_sanctuary_custom_background_args', array(
            'default-color' => 'ffffff',
            'default-image' => '',
        )));

        if ( ! defined( 'FOREST_SAFARI_IMPORT_URL' ) ) {
            define( 'FOREST_SAFARI_IMPORT_URL', esc_url( admin_url( 'themes.php?page=animalsanctuary-demoimport' ) ) );
        }
        if ( ! defined( 'FOREST_SAFARI_WELCOME_MESSAGE' ) ) {
            define( 'FOREST_SAFARI_WELCOME_MESSAGE', __( 'Welcome to Animal Sanctuary', 'animal-sanctuary' ) );
        }
    }
endif;
add_action('after_setup_theme', 'animal_sanctuary_setup');

// Set content width
function animal_sanctuary_content_width() {
    $GLOBALS['content_width'] = apply_filters('animal_sanctuary_content_width', 1170);
}
add_action('after_setup_theme', 'animal_sanctuary_content_width', 0);

/**
 * Register widget area.
 *
 * @link https://developer.wordpress.org/themes/functionality/sidebars/#registering-a-sidebar
 */
function forest_safari_widgets_inist() {
	register_sidebar(
		array(
			'name'          => esc_html__( 'Sidebar', 'forest-safari' ),
			'id'            => 'sidebar-1',
			'description'   => esc_html__( 'Add widgets here.', 'forest-safari' ),
			'before_widget' => '<section id="%1$s" class="widget %2$s">',
			'after_widget'  => '</section>',
			'before_title'  => '<h2 class="widget-title">',
			'after_title'   => '</h2>',
		)
	);

	register_sidebar(
		array(
			'name'          => esc_html__( 'Footer 1', 'forest-safari' ),
			'id'            => 'footer-1',
			'description'   => esc_html__( 'Add widgets here.', 'forest-safari' ),
			'before_widget' => '<section id="%1$s" class="widget %2$s">',
			'after_widget'  => '</section>',
			'before_title'  => '<h2 class="widget-title">',
			'after_title'   => '</h2>',
		)
	);

	register_sidebar(
		array(
			'name'          => esc_html__( 'Footer 2', 'forest-safari' ),
			'id'            => 'footer-2',
			'description'   => esc_html__( 'Add widgets here.', 'forest-safari' ),
			'before_widget' => '<section id="%1$s" class="widget %2$s">',
			'after_widget'  => '</section>',
			'before_title'  => '<h2 class="widget-title">',
			'after_title'   => '</h2>',
		)
	);

	register_sidebar(
		array(
			'name'          => esc_html__( 'Footer 3', 'forest-safari' ),
			'id'            => 'footer-3',
			'description'   => esc_html__( 'Add widgets here.', 'forest-safari' ),
			'before_widget' => '<section id="%1$s" class="widget %2$s">',
			'after_widget'  => '</section>',
			'before_title'  => '<h2 class="widget-title">',
			'after_title'   => '</h2>',
		)
	);
}
add_action( 'widgets_init', 'forest_safari_widgets_inist' );

// Remove customizer settings
function animal_sanctuary_remove_custom($wp_customize) {

    $wp_customize->remove_setting('forest_safari_aboutus_list_icon1');
    $wp_customize->remove_control('forest_safari_aboutus_list_icon1');

    $wp_customize->remove_setting('forest_safari_aboutus_list_icon2');
    $wp_customize->remove_control('forest_safari_aboutus_list_icon2');

    $wp_customize->remove_setting('forest_safari_aboutus_list_icon3');
    $wp_customize->remove_control('forest_safari_aboutus_list_icon3');

    $wp_customize->remove_setting('forest_safari_aboutus_list_icon4');
    $wp_customize->remove_control('forest_safari_aboutus_list_icon4');

    $wp_customize->remove_setting('forest_safari_aboutus_list_icon5');
    $wp_customize->remove_control('forest_safari_aboutus_list_icon5');

    $wp_customize->remove_setting('forest_safari_aboutus_list_icon6');
    $wp_customize->remove_control('forest_safari_aboutus_list_icon6');

    $wp_customize->remove_setting('forest_safari_aboutus_list1');
    $wp_customize->remove_control('forest_safari_aboutus_list1');

    $wp_customize->remove_setting('forest_safari_aboutus_list2');
    $wp_customize->remove_control('forest_safari_aboutus_list2');

    $wp_customize->remove_setting('forest_safari_aboutus_list3');
    $wp_customize->remove_control('forest_safari_aboutus_list3');

    $wp_customize->remove_setting('forest_safari_aboutus_list4');
    $wp_customize->remove_control('forest_safari_aboutus_list4');

    $wp_customize->remove_setting('forest_safari_aboutus_list5');
    $wp_customize->remove_control('forest_safari_aboutus_list5');

    $wp_customize->remove_setting('forest_safari_aboutus_list6');
    $wp_customize->remove_control('forest_safari_aboutus_list6');

}
add_action('customize_register', 'animal_sanctuary_remove_custom', 1000);

function animal_sanctuary_customize_register($wp_customize) {

    // Add settings for button text
    $wp_customize->add_setting('animal_sanctuary_about_button1_text', array(
        'capability' => 'edit_theme_options',
        'transport' => 'refresh',
        'default' => '',
        'sanitize_callback' => 'sanitize_text_field',
    ));
    $wp_customize->add_control('animal_sanctuary_about_button1_text', array(
        'label' => __('Edit Read More Button #1 Text ', 'animal-sanctuary'),
        'description' => __('Edit the Read More button text.', 'animal-sanctuary'),
        'section' => 'forest_safari_aboutus_section', // must exist or be redefined
        'type' => 'text',
    ));

    // Add settings for button URL
    $wp_customize->add_setting('animal_sanctuary_about_button1_link', array(
        'capability' => 'edit_theme_options',
        'transport' => 'refresh',
        'default' => '',
        'sanitize_callback' => 'esc_url_raw',
    ));
    $wp_customize->add_control('animal_sanctuary_about_button1_link', array(
        'label' => __('Edit Read More #1 URL ', 'animal-sanctuary'),
        'description' => __('Edit the Read More button url.', 'animal-sanctuary'),
        'section' => 'forest_safari_aboutus_section',
        'type' => 'url',
    ));

    // Rescue & Rehabilitation
    $wp_customize->add_setting('animal_sanctuary_rescue_percentage', array(
        'default' => '',
        'sanitize_callback' => 'absint',
    ));
    $wp_customize->add_control('animal_sanctuary_rescue_percentage', array(
        'label'   => __('Rescue & Rehabilitation Percentage', 'animal-sanctuary'),
        'section' => 'forest_safari_aboutus_section',
        'type'    => 'number',
        'input_attrs' => array('min' => 0, 'max' => 100, 'step' => 1),
    ));

    // Adoption & Rehoming
    $wp_customize->add_setting('animal_sanctuary_adoption_percentage', array(
        'default' => '',
        'sanitize_callback' => 'absint',
    ));
    $wp_customize->add_control('animal_sanctuary_adoption_percentage', array(
        'label'   => __('Adoption & Rehoming Percentage', 'animal-sanctuary'),
        'section' => 'forest_safari_aboutus_section',
        'type'    => 'number',
        'input_attrs' => array('min' => 0, 'max' => 100, 'step' => 1),
    ));

    // Wildlife Protection
    $wp_customize->add_setting('animal_sanctuary_wildlife_percentage', array(
        'default' => '',
        'sanitize_callback' => 'absint',
    ));
    $wp_customize->add_control('animal_sanctuary_wildlife_percentage', array(
        'label'   => __('Wildlife Protection Percentage', 'animal-sanctuary'),
        'section' => 'forest_safari_aboutus_section',
        'type'    => 'number',
        'input_attrs' => array('min' => 0, 'max' => 100, 'step' => 1),
    ));

    $wp_customize->add_setting('animal_sanctuary_total_yr_experience',array(
        'default'   => '',
        'sanitize_callback' => 'sanitize_text_field'
    ));
    $wp_customize->add_control('animal_sanctuary_total_yr_experience',array(
        'label' => __('Add Total Years Of Experience','animal-sanctuary'),
        'section'   => 'forest_safari_aboutus_section',
        'type'      => 'text'
    ));

}
add_action('customize_register', 'animal_sanctuary_customize_register', 99);


// global color
function animal_sanctuary_dynamic_colors() {
    $animal_sanctuary_primary_color   = get_theme_mod('forest_safari_primary_color', '#057357');

    $animal_sanctuary_custom_css = ':root {';
    $animal_sanctuary_custom_css .= '--secondary-color: ' . esc_attr($animal_sanctuary_primary_color) . ';';
    $animal_sanctuary_custom_css .= '}';

    // Inline CSS in <head>
    echo '<style type="text/css">' . $animal_sanctuary_custom_css . '</style>';
}
add_action('wp_head', 'animal_sanctuary_dynamic_colors');