<?php
/**
 * Title: About me
 * Slug: anastasi/about-me
 * Category: anastasi
 */
?>

<!-- wp:paragraph {"align":"center"} -->
<p class="has-text-align-center"><?php _e('As a nature photographer, I’m driven by the beauty and serenity of the natural world. My focus is on capturing both the grand landscapes and the intricate details that often go unnoticed. Every photo is an attempt to tell a story, showing the raw, unfiltered moments of nature. I believe in letting nature take the lead, waiting patiently to capture its authentic beauty. Through my work, I hope to inspire others to appreciate and protect the world we live in.', 'anastasi'); ?></p>
<!-- /wp:paragraph -->

<!-- wp:paragraph {"align":"center"} -->
<p class="has-text-align-center"><?php _e('My mission is to share with humanity the hidden beauty of our world, revealing the tiniest details that often go unnoticed, yet hold infinite wonder.', 'anastasi'); ?></p>
<!-- /wp:paragraph -->

<!-- wp:group {"style":{"spacing":{"padding":{"top":"var:preset|spacing|10","bottom":"var:preset|spacing|10"}}},"layout":{"type":"flex","flexWrap":"nowrap","justifyContent":"center"}} -->
<div class="wp-block-group" style="padding-top:var(--wp--preset--spacing--10);padding-bottom:var(--wp--preset--spacing--10)">
    <!-- wp:image {"width":"80px","aspectRatio":"1","scale":"cover","sizeSlug":"large","linkDestination":"none","align":"center","style":{"border":{"radius":"300px"}}} -->
    <figure class="wp-block-image aligncenter size-large is-resized has-custom-border">
        <img src="<?php echo esc_url( get_stylesheet_directory_uri() ); ?>/assets/images/anastasi-1.jpg" alt="" style="border-radius:300px;aspect-ratio:1;object-fit:cover;width:80px"/>
    </figure>
    <!-- /wp:image -->

    <!-- wp:group {"style":{"spacing":{"blockGap":"0"}},"layout":{"type":"flex","orientation":"vertical"}} -->
    <div class="wp-block-group">
        <!-- wp:heading {"style":{"elements":{"link":{"color":{"text":"var:preset|color|base"}}},"spacing":{"margin":{"top":"0","bottom":"0"}},"typography":{"fontSize":"1.5rem"}},"textColor":"base"} -->
        <h2 class="wp-block-heading has-base-color has-text-color has-link-color" style="margin-top:0;margin-bottom:0;font-size:1.5rem"><?php _e('Anastasi Fink', 'anastasi'); ?></h2>
        <!-- /wp:heading -->

        <!-- wp:paragraph {"fontSize":"small"} -->
        <p class="has-small-font-size"><?php _e('Photographer', 'anastasi'); ?></p>
        <!-- /wp:paragraph -->
    </div>
    <!-- /wp:group -->
</div>
<!-- /wp:group -->
