<?php
/**
 * Anastasi functions and definitions
 *
 * @link https://developer.wordpress.org/themes/basics/theme-functions/
 *
 * @package Anastasi
 * @since Anastasi 1.0
 */

 function anastasi_fse_styles() {

    wp_enqueue_style(

        'fse-style',

        get_stylesheet_uri(),

        array(),

        wp_get_theme()->get( 'Version' )

    );

}

add_action( 'wp_enqueue_scripts', 'anastasi_fse_styles' );


if ( ! function_exists( 'anastasi_fse_setup' ) ) {

    function anastasi_fse_setup() {

        add_theme_support( 'wp-block-styles' );

        add_editor_style( 'style.css' );

    }

}

add_action( 'after_setup_theme', 'anastasi_fse_setup' );


remove_theme_support( 'core-block-patterns' );


add_filter( 'should_load_remote_block_patterns', '__return_false' );

function anastasi_register_pattern_categories() {

    if ( function_exists( 'anastasi_register_block_pattern_category' ) ) {

        register_block_pattern_category(

            'anastasi',

            array(

                'label' => __( 'Anastasi Patterns', 'anastasi' ),

                'description' => __( 'Anastasi theme Patterns', 'anastasi' ),

            )

        );

    }

}

add_action( 'init', 'anastasi_register_pattern_categories' );


function anastasi_set_default_featured_image($html, $post_id, $post_thumbnail_id, $size, $attr) {
    if (empty($html)) {
        // Set your default image URL here
        $default_image_url = get_template_directory_uri() . '/assets/images/anastasi-1.jpg';
        // Output an img tag with the default image
        $html = '<img src="' . esc_url($default_image_url) . '" alt="' . esc_attr(get_the_title($post_id)) . '" />';
    }
    return $html;
}
add_filter('post_thumbnail_html', 'anastasi_set_default_featured_image', 10, 5);


function anastasi_setup_notice() {
    $notice_option_name = 'anastasi_setup_notice_dismissed';
    $is_dismissed = get_option( $notice_option_name );

    if ( ! $is_dismissed ) {
        $image_url = '/wp-content/themes/anastasi/assets/images/me.png';
        $notice_text = '<img src="' . $image_url . '" style="max-width: 100%;" />
        <div class="anastasi-notice-text">
        <h3 style="margin-top: 0px">'.__('Hi, I\'m Roman Fink, the developer of the Anastasi theme. I hope this theme helps you build your great website','anastasi').' 😉</h3>
        📷 '.__('This theme is inspired by travel photographer Anastasi Fink. Just take a look at her stunning photos:').' <a target="_blank" href="https://anastasifink.com/">anastasifink.com</a><br>
        👉 '.__('If you enjoy using this theme, please take a moment to rate it on the WordPress repository:','anastasi').' <a href="https://wordpress.org/support/theme/anastasi/reviews/#new-post">rate theme.</a><br>
        ☕ '.__('You can support me by buying me a coffee here:','anastasi').' <a href="https://ko-fi.com/romanfink">https://ko-fi.com/romanfink</a><br>
        💬 '.__('If you need any help with your website, feel free to email me:','anastasi').' <i>hello@romanfink.com</i><br>
        🔗 '.__('Visit my website:','anastasi').' <a href="https://romanfink.com">https://romanfink.com</a><br>
        <p style="margin: 5px 0 0;"><b>'.__('Just close this notice to hide it. All the best!','anastasi').'</b></p></div>';
        echo '<div id="anastasi-notice" class="notice notice-info is-dismissible">' . wp_kses_post( $notice_text ) . '</div>';
    }
}

add_action( 'admin_notices', 'anastasi_setup_notice' );


function anastasi_notice_script() {
    if ( ! wp_script_is( 'jquery', 'done' ) ) {
        wp_enqueue_script( 'jquery' );
    }

    wp_enqueue_script( 'anastasi-notice-script', get_template_directory_uri() . '/assets/js/admin-notice.js', array( 'jquery' ), '', true );
}

add_action( 'admin_enqueue_scripts', 'anastasi_notice_script' );


function enqueue_custom_admin_styles() {
    $notice_option_name = 'anastasi_setup_notice_dismissed';
    $is_dismissed = get_option( $notice_option_name );
    if ( ! $is_dismissed ) {
        wp_enqueue_style( 'anastasi-admin-notice', get_template_directory_uri() . '/assets/css/admin-notice.css' );
    }
}

add_action( 'admin_enqueue_scripts', 'enqueue_custom_admin_styles' );


function anastasi_dismiss_notice() {
    update_option( 'anastasi_setup_notice_dismissed', true );
    wp_die();
}

add_action( 'wp_ajax_anastasi_dismiss_notice', 'anastasi_dismiss_notice' );