<?php
// Original Framework http://theundersigned.net/2006/06/wordpress-how-to-theme-options/ 
// Updated and added additional options by Jeremy Clark (http://clarktech.no-ip.com/) and Fabian Schmid (http://www.blog.ordinary.ch)

$themename = "an ordinary theme";
$shortname = "theme_";
$options = array (
array(	"name" => "Number of Columns",
				"id" => $shortname."columns",
				"type" => "radio",
				"before" => "",
				"after" => "Choose wheter the theme shall display one or two columns.",
				"std" => "2",
				"options" => array("2", "1")),
				
array(	"name" => "Color scheme",
				"id" => $shortname."color",
				"type" => "radio",
				"before" => "",
				"after" => "Choose the color scheme for your blog.",
				"std" => "white",
				"options" => array("white", "black")),
				
array(	"name" => "Display the number of posts in brackets for each category.",
				"id" => $shortname."categorycount",
				"type" => "radio",
				"before" => "",
				"after" => "You have to change two lines in a WordPress core file for a correct result => Check out the instruction in the readme.txt file in the theme directory.",
				"std" => "No",
				"options" => array("No", "Yes")),
				
array(	"name" => "Show edit post link",
				"id" => $shortname."editpostlink",
				"type" => "radio",
				"before" => "",
				"after" => "Choose wheter to show or hide the 'edit post' link at the top of each post.",
				"std" => "No",
				"options" => array("No", "Yes")),
			
array(  "name" => "Number of random header pictures",
       	"id" => $shortname."headerpics",
      	"type" => "text",
				"before" => "",
				"after" => "If you have not uploaded as many pictures there will sometimes be a blank area instead.",
				"std" => "3"),

array(  "name" => "Archive type",
       	"id" => $shortname."archivestype",
      	"type" => "select",
				"before" => "",
				"after" => "Choose the type of the archive.",
				"std" => "monthly",
				"options" => array("yearly", "monthly", "weekly", "daily", "postbypost")),

array(  "name" => "Number of posts to be listed in 'Latest posts'",
       	"id" => $shortname."latestpostslimit",
      	"type" => "text",
				"before" => "",
				"after" => "Choose the number of posts that shall be listed in the dropdown menu 'Latest posts'.",
				"std" => "5")
			
    /*array(  "name" => "Textarea",
            "id" => $shortname."_bigger_box",
            "std" => "Default Text",
            "type" => "textarea"),
 
    array(  "name" => "Dropdown Selection Menu",
            "id" => $shortname."_dropdown_menu",
            "type" => "select",
            "std" => "Default",
            "options" => array("Default", "Option 1", "Option 2"))*/
);

function mytheme_add_admin() {

    global $themename, $shortname, $options;
	
    if ( $_GET['page'] == basename(__FILE__) ) {
	
        if ( 'save' == $_REQUEST['action'] ) {
		
                foreach ($options as $value) {
                    update_option( $value['id'], addslashes(htmlentities($_REQUEST[ $value['id'] ] ))); }
					
                foreach ($options as $value) {
                    if( isset( $_REQUEST[ $value['id'] ] ) ) { update_option( $value['id'], addslashes(htmlentities($_REQUEST[ $value['id'] ]  ))); } else { delete_option( $value['id'] ); } }
                header("Location: themes.php?page=controlpanel.php&saved=true");
                die;
				
        } else if( 'reset' == $_REQUEST['action'] ) {
            foreach ($options as $value) {
                delete_option( $value['id'] ); 
                update_option( $value['id'], $value['std'] );
			}
			
            header("Location: themes.php?page=controlpanel.php&reset=true");
            die;
        }
    }
    add_theme_page("options for ".$themename, "an ordinary theme", 'edit_themes', basename(__FILE__), 'mytheme_admin');
}

function mytheme_admin() {

    global $themename, $shortname, $options;

    if ( $_REQUEST['saved'] ) echo '<div id="message" class="updated fade"><p><strong>'.$themename.' settings saved.</strong></p></div>';
    if ( $_REQUEST['reset'] ) echo '<div id="message" class="updated fade"><p><strong>'.$themename.' settings reset.</strong></p></div>';
?>
<div class="wrap">
	<h2><?php echo $themename; ?> settings</h2>
	
	<p>Theme Name: an ordinary theme<br />
		Theme URI: <a href="http://www.blog.ordinary.ch/?page_id=269" target="_blank" alt="Theme URI" title="Theme URI">http://www.blog.ordinary.ch/?page_id=269</a><br />
		Version: 2.5<br />
		Description: A simple theme with two corresponding random pictures in the header and a suckertree navigation thereunder. Optionally one or two columns. Two color schemes available. Widget ready. Please read the readme.txt file.<br />
		Author: Fabian Schmid<br />
		Author URI: <a href="http://www.blog.ordinary.ch/" target="_blank" alt="Author URI" title="Author URI">http://www.blog.ordinary.ch</a><br />
		Tags: one-column, two-columns, fixed-width, white, black, light</p>
		<br />
	<p>First of all, thank you for using 'an ordinary theme' in your blog. Visit 
		<a href="http://www.blog.ordinary.ch/" target="_blank" alt="www.blog.ordinary.ch" title="www.blog.ordinary.ch">my blog</a> 
		for further information about the theme and me. Don't hesitate to ask, if you've got questions about the theme.<br />
		'an ordinary theme' is continuously being refined and updated.<br />
		It is published as an open source theme. You are free to change what ever you like. Of course I'd be happy about you leaving the link to my blog in the footer.<br />
		There are several things you cannot change in the admin section. The most common of them might be the following:</p>
	<ul style="list-style-type: square">
		<li style="margin-left: 20px;">Button labellings, footer text, error messages and so on: Open the translation.php file (which is located in the theme directory) 
			and pick the requested terms. The names for the constants are set as obvious as possible. If you still cannot find the item you want to change, just ask.</li>
		<li style="margin-left: 20px;">Change the header images: For changing the number of header images use the text field below. To change the images themselves navigate 
			to the folder /images in the theme directory. There are the existing images named e.g. leftbanner3.jpg and rightbanner3.jpg. Upload as 
			many pictures as you set at the bottom of this page and rename them to according to the example images.</li>
		<li style="margin-left: 20px;">Removing or adding a navigation item: Go to sidebar.php, copy an existing item and then change it to your wishes.</li>
	</ul>
	<br />
	
	<form method="post">
	<table class="optiontable">
	<?php foreach ($options as $value) { 
		if ($value['type'] == "text") { ?>
			<tr valign="middle">
				<td align="left" colspan="2"><?php echo $value['before']; ?></td>
			</tr>
			<tr valign="top"> 
				<th align="left"><?php echo $value['name']; ?>:</th>
				<td align="left">
					<input name="<?php echo $value['id']; ?>" id="<?php echo $value['id']; ?>" type="<?php echo $value['type']; ?>" value="<?php if ( get_settings( $value['id'] ) != "") { echo stripslashes(get_settings( $value['id'] )); } else { echo stripslashes($value['std']); } ?>" size="40" />
				</td>
			</tr>
			<tr valign="middle">
				<td align="left" colspan="2"><?php echo $value['after']; ?></td>
			</tr>
			<tr><td colspan=2><hr /></td></tr>
		<?php } elseif ($value['type'] == "select") { ?>
			<tr valign="middle">
				<td align="left" colspan="2"><?php echo $value['before']; ?></td>
			</tr>
			<tr valign="middle"> 
				<th align="left"><?php echo $value['name']; ?>:</th>
				<td align="left">
					<select name="<?php echo $value['id']; ?>" id="<?php echo $value['id']; ?>">
					<?php foreach ($value['options'] as $option) { ?>
					<option<?php if ( get_settings( $value['id'] ) == $option) { echo ' selected="selected"'; }?>><?php echo $option; ?></option>
					<?php } ?>
					</select>
				</td>
			</tr>
			<tr valign="middle">
				<td align="left" colspan="2"><?php echo $value['after']; ?></td>
			</tr>
			<tr><td colspan=2><hr /></td></tr>
		<?php } elseif ($value['type'] == "radio") { ?>
			<tr valign="middle">
				<td align="left" colspan="2"><?php echo $value['before']; ?></td>
			</tr>
			<tr valign="middle"> 
				<th align="left"><?php echo $value['name']; ?>:</th>
				<td align="left">
					<?php foreach ($value['options'] as $option) { ?>
					<input name="<?php echo $value['id']; ?>" type="<?php echo $value['type']; ?>" value="<?php echo $option; ?>" <?php if(get_settings($value['id']) == $option){ echo 'checked'; } ?>/> <?php echo $option; ?><br />
					<?php } ?>
				</td>
			</tr>
			<tr valign="middle">
				<td align="left" colspan="2"><?php echo $value['after']; ?></td>
			</tr>
			<tr><td colspan=2><hr /></td></tr>
		<?php } elseif ($value['type'] == "textarea") { ?>
			<tr valign="middle">
				<td align="left" colspan="2"><?php echo $value['before']; ?></td>
			</tr>
			<tr valign="middle">
				<th align="left"><?php echo $value['name']; ?>:</th>
				<td align="left">
					<textarea name="<?php echo $value['id']; ?>" id="<?php echo $value['id']; ?>" cols="40" rows="5"/><?php if ( get_settings( $value['id'] ) != "") { echo stripslashes(get_settings( $value['id'] )); } else { echo stripslashes($value['std']); } ?></textarea>
				</td>
			</tr>
			<tr valign="middle">
				<td align="left" colspan="2"><?php echo $value['after']; ?></td>
			</tr>
			<tr><td colspan=2><hr /></td></tr>
		<?php } ?>
	<?php } ?>
</table>
<p class="submit">
	<input name="save" type="submit" value="Save changes" />    
	<input type="hidden" name="action" value="save" />
</p>
</form>
<form method="post">
<p class="submit">
	<input name="reset" type="submit" value="Reset" />
	<input type="hidden" name="action" value="reset" />
</p>
</form>

<h2>Preview (updated when options are saved)</h2>
<iframe src="../?preview=true" width="100%" height="600" ></iframe>
<br />

<p><b>Change log</b><br />
	<br />
	* Version 2.5 (02.07.2009)<br />
		Removed duplicate comment form in single view<br />
		Ordered attributes in Stylesheet alphabetically<br />
		Removed alt attribute for links in footer due to xhtml validity<br />
	* Version 2.4 (11.06.2009)<br />
		Added WP styles for wrapping text around images (http://codex.wordpress.org/Wrapping_Text_Around_Images)<br />
	* Version 2.3 (24.04.2009)<br />
		Fixed search engine problems<br />
		Fixed navigation problems in IE<7<br />
		Reduced margins and paddings for ul and ol in entries<br />
		Stylesheet cosmetics<br />
	* Version 2.2 (08.04.2009)<br />
		Corrected category bug in sidebar<br />
		Corrected some typing errors<br />
		Added theme name and version to the footer<br />
	* Version 2.1 (07.04.2009)<br />
		Added a couple of settings to the admin panel<br />
		Improved the html and css structure<br />
		Reorganized the file structure<br />
	<br />
	* Version 2.0 (16.03.2009)<br />
		Improved the html structure<br />
	<br />
	* Version 1.9 (13.03.2009)<br />
		Fixed some tiny imperfections<br />
	<br />
	* Version 1.8 (12.02.2009)<br />
		Increased the font size in entries<br />
		Altered the font family in entries<br />
		Added some additional font family stlyes if default font isn't available<br />
		Lit the 'add comment' button<br />
	<br />
	* Version 1.7 (05.02.2009)<br />
		Removed the border for image links<br />
		Altered index.php, single.php and search.php for code cosmetics<br />
	<br />
	* Version 1.6 (29.01.2009)<br />
		Removed the post counting for each category in brackets due to necessary changes in wp core files<br />
		Added an instruction for readding the post counting for categories in brackets<br />
		Lit the alternating comments background color<br />
	<br />
	* Version 1.5 (24.01.2009)<br />
		Added min-height for overall div #contentwrap<br />
		Added important notice to readme<br />
		Altered header.php for 404 error page reasons<br />
	<br />
	* Version 1.4 (23.01.2009)<br />
		Altered comments.php for style reasons<br />
	<br />
	* Version 1.3 (19.01.2009)<br />
		Altered footer for copyright reasons<br />
		Removed non-existent images<br />
		Adjusted theme tags<br />
	<br />
	* Version 1.2 (15.01.2009)<br />
		Altered style.css for style reasons<br />
	<br />
	* Version 1.1 (10.01.2009)<br />
		Altered style.css for style reasons<br />
	<br />
	* Version 1.0 (12.12.2008)<br />
		Initial version</p>
<br />

<p>Thanks to...</p>
<ul style="list-style-type: square">
	<li style="margin-left: 20px;">the whole WordPress team for the great job they do</li>
	<li style="margin-left: 20px;">the script dhtml, javascript and css library <a href="http://www.dynamicdrive.com/" target="_blank" title="www.dynamicdrive.com">www.dynamicdrive.com</a> for the suckertree menu on which this theme's menu is based on</li>
	<li style="margin-left: 20px;">Jeremy Clark for the WordPress Theme Options Framework, released on <a href="http://www.clark-technet.com/2008/09/wordpress-theme-options-framework" target="_blank" title="www.clark-technet.com">www.clark-technet.com</a></li>
</ul>
<br />

<h4>Theme Option page for <?php echo $themename; ?>&nbsp; | &nbsp; Framework by <a href="http://clarktech.no-ip.com/" target="_blank" title="Jeremy Clark">Jeremy Clark</a></h4>
<?php
}
add_action('admin_menu', 'mytheme_add_admin');
?>