<?php
	$wp_customize->add_panel( 'wpdevart_amstore_header_panel', 
	array(
		'title'	=> esc_html__('Header','amstore'),			
		'description'	=> esc_html__('Customize the theme header options','amstore'),		
		'priority'		=> 24
	) 
	);
    $wp_customize->add_section('wpdevart_amstore_header_section',array(
		'title'	=> esc_html__('General','amstore'),					
		'priority'		=> null,
		'panel'         => 'wpdevart_amstore_header_panel'
	));

	$wp_customize->add_setting( 'wpdevart_amstore_header_layout',
	array(
		'default' => esc_html('headerlayoutone'),
		'transport' => 'refresh',
		'sanitize_callback' => 'wpdevart_amstore_text_sanitization'
	)
	);
	$wp_customize->add_control( new Wpdevart_Image_Radio_Button_Custom_Control( $wp_customize, 'wpdevart_amstore_header_layout',
	array(
		'label' => esc_html__( 'Header layout', 'amstore' ),
		'description' => esc_html__( 'Select the position of the header elements', 'amstore' ),
		'section' => 'wpdevart_amstore_header_section',
		'choices' => array(
		'headerlayoutone' => array(
			'image' => trailingslashit( get_template_directory_uri() ) . 'images/header-layout-one.jpg',
			'name' => esc_html__( 'All header elements on one line', 'amstore' )
		),
		'headerlayouttwo' => array(
			'image' => trailingslashit( get_template_directory_uri() ) . 'images/header-layout-two.jpg',
			'name' => esc_html__( 'Logo on the top side of the menu', 'amstore' )
		),
		)
	)
	) );
	$wp_customize->add_setting('wpdevart_amstore_header_bg_color',array(
		'default'	=> apply_filters( 'parent_wpdevart_amstore_header_bg_color', esc_html('#ffffff')),
		'sanitize_callback'	=> 'sanitize_hex_color'	
	));
	$wp_customize->add_control( new WP_Customize_Color_Control( $wp_customize, 'wpdevart_amstore_header_bg_color', array(
        'label' => esc_html__('Header background color','amstore'),
        'section' => 'wpdevart_amstore_header_section',
        'settings' => 'wpdevart_amstore_header_bg_color'
    )));

	$wp_customize->add_setting('wpdevart_amstore_header_gradient_type',array(
		'default'	=> esc_html('to right'),
		'sanitize_callback'	=> 'wpdevart_amstore_text_sanitization'	
	));
	$wp_customize->add_control('wpdevart_amstore_header_gradient_type',array(
			'label'	=> esc_html__('Gradient type','amstore'),
			'section'	=> 'wpdevart_amstore_header_section',
			'setting'	=> 'wpdevart_amstore_header_gradient_type',
			'type' => 'select',
			'choices' => array(
				'to right' => esc_html__('To right','amstore'),
				'to left' => esc_html__('To left','amstore'),
				'to bottom' => esc_html__('To bottom','amstore'),
				'to top' => esc_html__('To top','amstore'),
				'to bottom right' => esc_html__('To bottom right','amstore'),
				'to bottom left' => esc_html__('To bottom left','amstore'),
				'to top right' => esc_html__('To top right','amstore'),
				'to top left' => esc_html__('To top left','amstore'),
				)
	));	
	$wp_customize->add_setting('wpdevart_amstore_header_bg_gradient_color',array(
		'default'	=> apply_filters( 'parent_wpdevart_amstore_header_bg_gradient_color', esc_html('#ffffff')),
		'sanitize_callback'	=> 'sanitize_hex_color'	
	));
	$wp_customize->add_control( new WP_Customize_Color_Control( $wp_customize, 'wpdevart_amstore_header_bg_gradient_color', array(
        'label' => esc_html__('Header gradient color','amstore'),
        'section' => 'wpdevart_amstore_header_section',
        'settings' => 'wpdevart_amstore_header_bg_gradient_color'
    )));
	$wp_customize->add_setting( 'wpdevart_amstore_enable_main_header_border',
    array(
       'default' => esc_html(''),
       'transport' => 'refresh',
       'sanitize_callback' => 'wpdevart_amstore_switch_sanitization'
    )
    );
    $wp_customize->add_control( new Wpdevart_Toggle_Switch_Custom_control( $wp_customize, 'wpdevart_amstore_enable_main_header_border',
        array(
        'label' => esc_html__( 'Hide the header border', 'amstore' ),
        'section' => 'wpdevart_amstore_header_section'
        )
    ) );
	$wp_customize->add_setting('wpdevart_amstore_main_header_border_color',array(
		'default'	=> apply_filters( 'parent_wpdevart_amstore_main_header_border_color', esc_html('#fbf8f8')),
		'sanitize_callback'	=> 'sanitize_hex_color'	
	));
	$wp_customize->add_control( new WP_Customize_Color_Control( $wp_customize, 'wpdevart_amstore_main_header_border_color', array(
        'label' => esc_html__('Header border color','amstore'),
        'section' => 'wpdevart_amstore_header_section',
        'settings' => 'wpdevart_amstore_main_header_border_color'
    )));
	$wp_customize->add_setting( 'wpdevart_amstore_header_show_action_button',
    array(
       'default' => esc_html(''),
       'transport' => 'refresh',
       'sanitize_callback' => 'wpdevart_amstore_switch_sanitization'
    )
    );
    $wp_customize->add_control( new Wpdevart_Toggle_Switch_Custom_control( $wp_customize, 'wpdevart_amstore_header_show_action_button',
        array(
        'label' => esc_html__( 'Hide the action button', 'amstore' ),
        'section' => 'wpdevart_amstore_header_section'
        )
    ) );
	$wp_customize->add_setting('wpdevart_amstore_header_action_button_text',array(
		'default'	=> esc_html('Join Us'),
		'sanitize_callback'	=> 'wpdevart_amstore_text_sanitization'	
	));
    $wp_customize->add_control( new WP_Customize_Control(
        $wp_customize,
        'wpdevart_amstore_header_action_button_text',
            array(
                'label'    => esc_html__('Header action button text','amstore'),
                'section'  => 'wpdevart_amstore_header_section',
                'settings' => 'wpdevart_amstore_header_action_button_text',
                'type'     => 'text'
            )
        )
    );
	$wp_customize->add_setting('wpdevart_amstore_header_action_button_url',array(
		'default'	=> esc_url('#'),
		'sanitize_callback'	=> 'wpdevart_amstore_url_sanitization'
	));
	$wp_customize->add_control('wpdevart_amstore_header_action_button_url',array(
			'label'	=> esc_html__('Header action button URL','amstore'),
			'section'	=> 'wpdevart_amstore_header_section',
			'setting'	=> 'wpdevart_amstore_header_action_button_url'
	));	
	$wp_customize->add_setting('wpdevart_amstore_header_action_button_style',array(
		'default'	=> esc_html('wpdevart_amstore_secondary_button_slide secondary_btn_slide_right'),
		'sanitize_callback'	=> 'wpdevart_amstore_text_sanitization'	
	));
	$wp_customize->add_control('wpdevart_amstore_header_action_button_style',array(
			'label'	=> esc_html__('Header action button color','amstore'),
			'section'	=> 'wpdevart_amstore_header_section',
			'setting'	=> 'wpdevart_amstore_header_action_button_style',
			'type' => 'select',
			'choices' => array(
				'wpdevart_amstore_primary_button_slide primary_btn_slide_right' => esc_html__('Custom Primary', 'amstore'),
				'wpdevart_amstore_secondary_button_slide secondary_btn_slide_right' => esc_html__('Custom Secondary', 'amstore'),
				'wpdevart_amstore_first_button_slide first_btn_slide_right' => esc_html__('WpDevArt Color', 'amstore'),
				'wpdevart_amstore_second_button_slide second_btn_slide_right' => esc_html__('Grapefruit Red', 'amstore'),
				'wpdevart_amstore_third_button_slide third_btn_slide_right' => esc_html__('Blue', 'amstore'),
				'wpdevart_amstore_fourth_button_slide fourth_btn_slide_right' => esc_html__('Black', 'amstore'),
				'wpdevart_amstore_fifth_button_slide fifth_btn_slide_right' => esc_html__('Green', 'amstore'),
				'wpdevart_amstore_sixth_button_slide sixth_btn_slide_right' => esc_html__('Yellow', 'amstore'),
				'wpdevart_amstore_seventh_button_slide seventh_btn_slide_right' => esc_html__('Custom Green', 'amstore'),
				'wpdevart_amstore_eighth_button_slide eighth_btn_slide_right' => esc_html__('White', 'amstore'),
				)
	));

	$wp_customize->add_section('wpdevart_amstore_header_menu_search_section',array(
		'title'	=> esc_html__('Menu and Search','amstore'),					
		'priority'		=> null,
		'panel'         => 'wpdevart_amstore_header_panel'
	));
	$wp_customize->add_setting('wpdevart_amstore_header_search_button_color',array(
		'default'	=> apply_filters( 'parent_wpdevart_amstore_header_search_button_color', esc_html('#fd5e57')),
		'sanitize_callback'	=> 'sanitize_hex_color'	
	));
	$wp_customize->add_control( new WP_Customize_Color_Control( $wp_customize, 'wpdevart_amstore_header_search_button_color', array(
        'label' => esc_html__('Search button color','amstore'),
        'section' => 'wpdevart_amstore_header_menu_search_section',
        'settings' => 'wpdevart_amstore_header_search_button_color'
    )));
	$wp_customize->add_setting('wpdevart_amstore_header_menu_items_color',array(
		'default'	=> apply_filters( 'parent_wpdevart_amstore_header_menu_items_color', esc_html('#000000')),
		'sanitize_callback'	=> 'sanitize_hex_color'	
	));
	$wp_customize->add_control( new WP_Customize_Color_Control( $wp_customize, 'wpdevart_amstore_header_menu_items_color', array(
        'label' => esc_html__('Menu items color','amstore'),
        'section' => 'wpdevart_amstore_header_menu_search_section',
        'settings' => 'wpdevart_amstore_header_menu_items_color'
    )));
	$wp_customize->add_setting('wpdevart_amstore_main_header_sub_menu_bg_color',array(
		'default'	=> apply_filters( 'parent_wpdevart_amstore_main_header_sub_menu_bg_color', esc_html('#ffffff')),
		'sanitize_callback'	=> 'sanitize_hex_color'	
	));
	$wp_customize->add_control( new WP_Customize_Color_Control( $wp_customize, 'wpdevart_amstore_main_header_sub_menu_bg_color', array(
        'label' => esc_html__('Sub menu background color','amstore'),
        'section' => 'wpdevart_amstore_header_menu_search_section',
        'settings' => 'wpdevart_amstore_main_header_sub_menu_bg_color'
    )));
	$wp_customize->add_setting('wpdevart_amstore_main_header_sub_menu_items_color',array(
		'default'	=> apply_filters( 'parent_wpdevart_amstore_main_header_sub_menu_items_color', esc_html('#000000')),
		'sanitize_callback'	=> 'sanitize_hex_color'	
	));
	$wp_customize->add_control( new WP_Customize_Color_Control( $wp_customize, 'wpdevart_amstore_main_header_sub_menu_items_color', array(
        'label' => esc_html__('Sub menu items color','amstore'),
        'section' => 'wpdevart_amstore_header_menu_search_section',
        'settings' => 'wpdevart_amstore_main_header_sub_menu_items_color'
    )));
	$wp_customize->add_setting('wpdevart_amstore_main_header_sub_menu_top_border_color',array(
		'default'	=> apply_filters( 'parent_wpdevart_amstore_main_header_sub_menu_top_border_color', esc_html('#fd5e57')),
		'sanitize_callback'	=> 'sanitize_hex_color'	
	));
	$wp_customize->add_control( new WP_Customize_Color_Control( $wp_customize, 'wpdevart_amstore_main_header_sub_menu_top_border_color', array(
        'label' => esc_html__('Sub menu border color','amstore'),
        'section' => 'wpdevart_amstore_header_menu_search_section',
        'settings' => 'wpdevart_amstore_main_header_sub_menu_top_border_color'
    )));
	$wp_customize->add_setting('wpdevart_amstore_header_mobile_menu_background_color',array(
		'default'	=> apply_filters( 'parent_wpdevart_amstore_header_mobile_menu_background_color', esc_html('#fcfcfc')),
		'sanitize_callback'	=> 'sanitize_hex_color'	
	));
	$wp_customize->add_control( new WP_Customize_Color_Control( $wp_customize, 'wpdevart_amstore_header_mobile_menu_background_color', array(
        'label' => esc_html__('Mobile toolbar background color','amstore'),
        'section' => 'wpdevart_amstore_header_menu_search_section',
        'settings' => 'wpdevart_amstore_header_mobile_menu_background_color'
    )));
	$wp_customize->add_setting('wpdevart_amstore_mobile_menu_bg_gradient_type',array(
		'default'	=> esc_html('to right'),
		'sanitize_callback'	=> 'wpdevart_amstore_text_sanitization'	
	));
	$wp_customize->add_control('wpdevart_amstore_mobile_menu_bg_gradient_type',array(
			'label'	=> esc_html__('Gradient type','amstore'),
			'section'	=> 'wpdevart_amstore_header_menu_search_section',
			'setting'	=> 'wpdevart_amstore_mobile_menu_bg_gradient_type',
			'type' => 'select',
			'choices' => array(
				'to right' => esc_html__('To right','amstore'),
				'to left' => esc_html__('To left','amstore'),
				'to bottom' => esc_html__('To bottom','amstore'),
				'to top' => esc_html__('To top','amstore'),
				'to bottom right' => esc_html__('To bottom right','amstore'),
				'to bottom left' => esc_html__('To bottom left','amstore'),
				'to top right' => esc_html__('To top right','amstore'),
				'to top left' => esc_html__('To top left','amstore'),
				)
	));	
	$wp_customize->add_setting('wpdevart_amstore_mobile_menu_bg_gradient_color',array(
		'default'	=> apply_filters( 'parent_wpdevart_amstore_mobile_menu_bg_gradient_color', esc_html('#fcfcfc')),
		'sanitize_callback'	=> 'sanitize_hex_color'	
	));
	$wp_customize->add_control( new WP_Customize_Color_Control( $wp_customize, 'wpdevart_amstore_mobile_menu_bg_gradient_color', array(
        'label' => esc_html__('Mobile toolbar background gradient color','amstore'),
        'section' => 'wpdevart_amstore_header_menu_search_section',
        'settings' => 'wpdevart_amstore_mobile_menu_bg_gradient_color'
    )));
	$wp_customize->add_setting('wpdevart_amstore_header_descktop_search_button_color',array(
		'default'	=> apply_filters( 'parent_wpdevart_amstore_header_descktop_search_button_color', esc_html('#fd5e57')),
		'sanitize_callback'	=> 'sanitize_hex_color'	
	));
	$wp_customize->add_control( new WP_Customize_Color_Control( $wp_customize, 'wpdevart_amstore_header_descktop_search_button_color', array(
        'label' => esc_html__('Mobile search button color','amstore'),
        'section' => 'wpdevart_amstore_header_menu_search_section',
        'settings' => 'wpdevart_amstore_header_descktop_search_button_color'
    )));

	$wp_customize->add_setting('wpdevart_amstore_header_mobile_menu_button_color',array(
		'default'	=> apply_filters( 'parent_wpdevart_amstore_header_mobile_menu_button_color', esc_html('#fd5e57')),
		'sanitize_callback'	=> 'sanitize_hex_color'	
	));
	$wp_customize->add_control( new WP_Customize_Color_Control( $wp_customize, 'wpdevart_amstore_header_mobile_menu_button_color', array(
        'label' => esc_html__('Mobile menu button color','amstore'),
        'section' => 'wpdevart_amstore_header_menu_search_section',
        'settings' => 'wpdevart_amstore_header_mobile_menu_button_color'
    )));
	$wp_customize->add_setting('wpdevart_amstore_main_header_mobile_menu_background_color',array(
		'default'	=> apply_filters( 'parent_wpdevart_amstore_main_header_mobile_menu_background_color', esc_html('#ffffff')),
		'sanitize_callback'	=> 'sanitize_hex_color'	
	));
	$wp_customize->add_control( new WP_Customize_Color_Control( $wp_customize, 'wpdevart_amstore_main_header_mobile_menu_background_color', array(
        'label' => esc_html__('Mobile menu background color','amstore'),
        'section' => 'wpdevart_amstore_header_menu_search_section',
        'settings' => 'wpdevart_amstore_main_header_mobile_menu_background_color'
    )));
	$wp_customize->add_setting('wpdevart_amstore_main_header_mobile_menu_link_color',array(
		'default'	=> apply_filters( 'parent_wpdevart_amstore_main_header_mobile_menu_link_color', esc_html('#000000')),
		'sanitize_callback'	=> 'sanitize_hex_color'	
	));
	$wp_customize->add_control( new WP_Customize_Color_Control( $wp_customize, 'wpdevart_amstore_main_header_mobile_menu_link_color', array(
        'label' => esc_html__('Mobile menu link color','amstore'),
        'section' => 'wpdevart_amstore_header_menu_search_section',
        'settings' => 'wpdevart_amstore_main_header_mobile_menu_link_color'
    )));
	$wp_customize->add_setting('wpdevart_amstore_main_header_mobile_menu_border_color',array(
		'default'	=> apply_filters( 'parent_wpdevart_amstore_main_header_mobile_menu_border_color', esc_html('#f7f7f7')),
		'sanitize_callback'	=> 'sanitize_hex_color'	
	));
	$wp_customize->add_control( new WP_Customize_Color_Control( $wp_customize, 'wpdevart_amstore_main_header_mobile_menu_border_color', array(
        'label' => esc_html__('Mobile menu borders color','amstore'),
        'section' => 'wpdevart_amstore_header_menu_search_section',
        'settings' => 'wpdevart_amstore_main_header_mobile_menu_border_color'
    )));
	$wp_customize->add_setting('wpdevart_amstore_main_header_mobile_sub_menu_button_bg_color',array(
		'default'	=> apply_filters( 'parent_wpdevart_amstore_main_header_mobile_sub_menu_button_bg_color', esc_html('#fd5e57')),
		'sanitize_callback'	=> 'sanitize_hex_color'	
	));
	$wp_customize->add_control( new WP_Customize_Color_Control( $wp_customize, 'wpdevart_amstore_main_header_mobile_sub_menu_button_bg_color', array(
        'label' => esc_html__('Mobile sub-menu button BG color','amstore'),
        'section' => 'wpdevart_amstore_header_menu_search_section',
        'settings' => 'wpdevart_amstore_main_header_mobile_sub_menu_button_bg_color'
    )));
	$wp_customize->add_setting('wpdevart_amstore_main_header_mobile_sub_menu_button_color',array(
		'default'	=> apply_filters( 'parent_wpdevart_amstore_main_header_mobile_sub_menu_button_color', esc_html('#ffffff')),
		'sanitize_callback'	=> 'sanitize_hex_color'	
	));
	$wp_customize->add_control( new WP_Customize_Color_Control( $wp_customize, 'wpdevart_amstore_main_header_mobile_sub_menu_button_color', array(
        'label' => esc_html__('Mobile sub-menu button color','amstore'),
        'section' => 'wpdevart_amstore_header_menu_search_section',
        'settings' => 'wpdevart_amstore_main_header_mobile_sub_menu_button_color'
    )));

	if ( class_exists( 'WooCommerce' ) ) {
		$wp_customize->add_section('wpdevart_amstore_header_woo_cart',array(
			'title'	=> esc_html__('WooCommerce','amstore'),					
			'priority'		=> null,
			'panel'         => 'wpdevart_amstore_header_panel'
		));
		$wp_customize->add_setting('wpdevart_amstore_woocommerce_account_icon_color',array(
			'default'	=> apply_filters( 'parent_wpdevart_amstore_woocommerce_account_icon_color', esc_html('#fd5e57')),
			'sanitize_callback'	=> 'sanitize_hex_color'	
		));
		$wp_customize->add_control( new WP_Customize_Color_Control( $wp_customize, 'wpdevart_amstore_woocommerce_account_icon_color', array(
			'label' => esc_html__('WooCommerce account icon color','amstore'),
			'section' => 'wpdevart_amstore_header_woo_cart',
			'settings' => 'wpdevart_amstore_woocommerce_account_icon_color'
		)));
		$wp_customize->add_setting('wpdevart_amstore_woocommerce_cart_icon_color',array(
			'default'	=> apply_filters( 'parent_wpdevart_amstore_woocommerce_cart_icon_color', esc_html('#fd5e57')),
			'sanitize_callback'	=> 'sanitize_hex_color'	
		));
		$wp_customize->add_control( new WP_Customize_Color_Control( $wp_customize, 'wpdevart_amstore_woocommerce_cart_icon_color', array(
			'label' => esc_html__('WooCommerce cart icon color','amstore'),
			'section' => 'wpdevart_amstore_header_woo_cart',
			'settings' => 'wpdevart_amstore_woocommerce_cart_icon_color'
		)));
		$wp_customize->add_setting('wpdevart_amstore_woocommerce_cart_icon_number_color',array(
			'default'	=> apply_filters( 'parent_wpdevart_amstore_woocommerce_cart_icon_number_color', esc_html('#ffffff')),
			'sanitize_callback'	=> 'sanitize_hex_color'	
		));
		$wp_customize->add_control( new WP_Customize_Color_Control( $wp_customize, 'wpdevart_amstore_woocommerce_cart_icon_number_color', array(
			'label' => esc_html__('WooCommerce cart number color','amstore'),
			'section' => 'wpdevart_amstore_header_woo_cart',
			'settings' => 'wpdevart_amstore_woocommerce_cart_icon_number_color'
		)));
	};