<?php
    $wp_customize->add_section('wpdevart_amstore_not_found_section',array(
		'title'	=> esc_html__('404 Page','amstore'),					
		'priority'		=> 31
	));
	$wp_customize->add_setting('wpdevart_amstore_not_found_page_bg_color',array(
		'default'	=> apply_filters( 'parent_wpdevart_amstore_not_found_page_bg_color', esc_html('#ffffff')),
		'sanitize_callback'	=> 'sanitize_hex_color'	
	));
    $wp_customize->add_control( new WP_Customize_Color_Control( $wp_customize, 'wpdevart_amstore_not_found_page_bg_color', array(
        'label' => esc_html__('404 Page background color','amstore'),
        'section' => 'wpdevart_amstore_not_found_section',
        'settings' => 'wpdevart_amstore_not_found_page_bg_color'
    )));
	$wp_customize->add_setting('wpdevart_amstore_not_found_image',array(
		'default'	=> esc_url(get_theme_file_uri('/images/wpdevart-default-404.png')),
		'sanitize_callback'	=> 'wpdevart_amstore_url_sanitization'
	));
	$wp_customize->add_control( new WP_Customize_Image_Control( $wp_customize, 'wpdevart_amstore_not_found_image', array(
        'label' => esc_html__('404 page Image','amstore'),
		'description' => esc_html__( 'Recommended image size ~1080*550', 'amstore' ),
        'section' => 'wpdevart_amstore_not_found_section',
        'settings' => 'wpdevart_amstore_not_found_image',
        'button_labels' => array(
                    'select' =>  esc_html__('Select Image', 'amstore'),
                    'remove' =>  esc_html__('Remove Image', 'amstore'),
                    'change' =>  esc_html__('Change Image', 'amstore'),
                    )
    )));
	$wp_customize->add_setting('wpdevart_amstore_not_found_page_title',array(
		'default'	=> esc_html('Oops! Page Not Found'),
		'sanitize_callback'	=> 'wpdevart_amstore_text_sanitization'	
	));
    $wp_customize->add_control( new WP_Customize_Control(
        $wp_customize,
        'wpdevart_amstore_not_found_page_title',
            array(
                'label'    => esc_html__('404 page title','amstore'),
                'section'  => 'wpdevart_amstore_not_found_section',
                'settings' => 'wpdevart_amstore_not_found_page_title',
                'type'     => 'text'
            )
        )
    );
	$wp_customize->add_setting('wpdevart_amstore_not_found_page_description',array(
		'default'	=> esc_html('The page or URL you are trying to access was not found. Use the homepage link below to navigate to the homepage. You can also use the search function.'),
		'sanitize_callback'	=> 'wpdevart_amstore_text_sanitization'	
	));
	$wp_customize->add_control('wpdevart_amstore_not_found_page_description',array(
			'label'	=> esc_html__('404 page description','amstore'),
			'section'	=> 'wpdevart_amstore_not_found_section',
			'setting'	=> 'wpdevart_amstore_not_found_page_description'
	));	
	$wp_customize->add_setting('wpdevart_amstore_not_found_page_button_text',array(
		'default'	=> esc_html('Back to Homepage'),
		'sanitize_callback'	=> 'wpdevart_amstore_text_sanitization'	
	));
	$wp_customize->add_control('wpdevart_amstore_not_found_page_button_text',array(
			'label'	=> esc_html__('404 page button text','amstore'),
			'section'	=> 'wpdevart_amstore_not_found_section',
			'setting'	=> 'wpdevart_amstore_not_found_page_button_text'
	));	
	$wp_customize->add_setting('wpdevart_amstore_not_found_page_button_url',array(
		'default'	=> esc_url(get_home_url()),
		'sanitize_callback'	=> 'wpdevart_amstore_url_sanitization'	
	));
	$wp_customize->add_control('wpdevart_amstore_not_found_page_button_url',array(
			'label'	=> esc_html__('404 page button URL','amstore'),
			'section'	=> 'wpdevart_amstore_not_found_section',
			'setting'	=> 'wpdevart_amstore_not_found_page_button_url'
	));	
	$wp_customize->add_setting('wpdevart_amstore_not_found_page_button_style',array(
		'default'	=> esc_html('wpdevart_amstore_eighth_button_slide eighth_btn_slide_right'),
		'sanitize_callback'	=> 'wpdevart_amstore_text_sanitization'	
	));
	$wp_customize->add_control('wpdevart_amstore_not_found_page_button_style',array(
			'label'	=> esc_html__('Back to Homepage button color','amstore'),
			'section'	=> 'wpdevart_amstore_not_found_section',
			'setting'	=> 'wpdevart_amstore_not_found_page_button_style',
			'type' => 'select',
			'choices' => array(
				'wpdevart_amstore_primary_button_slide primary_btn_slide_right' => esc_html__('Custom Primary', 'amstore'),
				'wpdevart_amstore_secondary_button_slide secondary_btn_slide_right' => esc_html__('Custom Secondary', 'amstore'),
				'wpdevart_amstore_first_button_slide first_btn_slide_right' => esc_html__('WpDevArt Color', 'amstore'),
				'wpdevart_amstore_second_button_slide second_btn_slide_right' => esc_html__('Grapefruit Red', 'amstore'),
				'wpdevart_amstore_third_button_slide third_btn_slide_right' => esc_html__('Blue', 'amstore'),
				'wpdevart_amstore_fourth_button_slide fourth_btn_slide_right' => esc_html__('Black', 'amstore'),
				'wpdevart_amstore_fifth_button_slide fifth_btn_slide_right' => esc_html__('Green', 'amstore'),
				'wpdevart_amstore_sixth_button_slide sixth_btn_slide_right' => esc_html__('Yellow', 'amstore'),
				'wpdevart_amstore_seventh_button_slide seventh_btn_slide_right' => esc_html__('Custom Green', 'amstore'),
				'wpdevart_amstore_eighth_button_slide eighth_btn_slide_right' => esc_html__('White', 'amstore'),
				)
	));	