<?php
/**
 * Template part for displaying the header navigation menu
 *
 * @package ampy
 */

namespace MeanThemes\Ampy;

if ( ! ampy()->is_primary_nav_menu_active() && ! ampy()->is_secondary_nav_menu_active() ) {
	return;
}

?>

<nav id="<?php echo apply_filters( 'ampy_site_navigation_id', 'site-navigation' ); /* phpcs:ignore WordPress.Security.EscapeOutput.OutputNotEscaped */ ?>" class="<?php echo esc_attr( apply_filters( 'ampy_site_navigation_classes', 'main-navigation nav--toggle-sub nav--toggle-small' ) ); ?>" aria-label="<?php esc_attr_e( 'Main menu', 'ampy' ); ?>"
	<?php
	if ( ampy()->is_amp() ) {
		?>
		[class]=" siteNavigationMenu.expanded ? '<?php echo esc_attr( apply_filters( 'ampy_site_navigation_classes', 'main-navigation nav--toggle-sub nav--toggle-small nav--toggled-on' ) ); ?>' : '<?php echo esc_attr( apply_filters( 'ampy_site_navigation_classes', 'main-navigation nav--toggle-sub nav--toggle-small' ) ); ?>' "
		<?php
	}
	?>
>
	<?php
	if ( ampy()->is_amp() ) {
		?>
		<amp-state id="siteNavigationMenu">
			<script type="application/json">
				{
					"expanded": false
				}
			</script>
		</amp-state>
		<?php
	}
	?>

	<?php
	$menu_toggle_button = '<button class="menu-toggle" aria-label="' . esc_html__( 'Open menu', 'ampy' ) . '" aria-controls="primary-menu" aria-expanded="false">
					' . esc_html__( 'Menu', 'ampy' ) . '
					</button>';
	// $menu_toggle_button = apply_filters(
	// 	'ampy_menu_toggle_button',
	// 	array(
	// 		'menu_toggle_button' => $menu_toggle_button,
	// 		'is_amp'             => ampy()->is_amp(),
	// 	)
	// );
	// echo $menu_toggle_button; /* phpcs:ignore WordPress.Security.EscapeOutput.OutputNotEscaped */

	echo wp_kses_post(
		apply_filters(
			'ampy_menu_toggle_button',
			array(
				'menu_toggle_button' => $menu_toggle_button,
				'is_amp'             => ampy()->is_amp(),
			)
		)
	);

	?>

	<div class="primary-menu-container">
		<?php
		if ( ampy()->is_primary_nav_menu_active() ) {
			ampy()->display_primary_nav_menu( array( 'menu_id' => 'primary-menu' ) );
		}

		if ( ampy()->is_secondary_nav_menu_active() ) {
			ampy()->display_secondary_nav_menu( array( 'menu_id' => 'secondary-menu' ) );
		}
		?>
	</div>
</nav><!-- #site-navigation -->
