<?php
/**
 * Template part for displaying the header branding
 *
 * @package ampy
 */

namespace MeanThemes\Ampy;

?>

<div class="site-branding">
	<?php the_custom_logo(); ?>

	<?php
	if ( is_front_page() && is_home() ) {
		?>
		<h1 class="site-title"><a href="<?php echo esc_url( home_url( '/' ) ); ?>" rel="home"><?php bloginfo( 'name' ); ?></a></h1>
		<?php
	} else {
		?>
		<p class="site-title"><a href="<?php echo esc_url( home_url( '/' ) ); ?>" rel="home"><?php bloginfo( 'name' ); ?></a></p>
		<?php
	}
	?>

	<?php
	$ampy_description = get_bloginfo( 'description', 'display' );
	if ( $ampy_description || is_customize_preview() ) {
		?>
		<p class="site-description">
			<?php echo esc_html( $ampy_description ); ?>
		</p>
		<?php
	}
	?>
</div><!-- .site-branding -->
