<?php
/**
 * Template part for displaying the footer info
 *
 * @package ampy
 */

namespace MeanThemes\Ampy;

?>

<div class="site-info">
	<?php
	$site_info = get_theme_mod( 'site_info', '&copy; %year% <a href="%url%">%name%</a>. Design by <a href="https://www.meanthemes.com" target="_blank">MeanThemes</a>.' );

	$site_info = str_replace( '%year%', date( 'Y' ), $site_info );
	$site_info = str_replace( '%name%', esc_attr( get_bloginfo( 'name' ) ), $site_info );
	$site_info = str_replace( '%url%', esc_url( get_home_url() ), $site_info );

	echo wp_kses_post( $site_info );

	if ( function_exists( 'the_privacy_policy_link' ) ) {
		the_privacy_policy_link( '<span class="sep"> | </span>' );
	}
	?>
</div><!-- .site-info -->
