<?php
/**
 * Template part for displaying a post's featured image
 *
 * @package ampy
 */

namespace MeanThemes\Ampy;

// Audio or video attachments can have featured images, so they need to be specifically checked.
$support_slug = get_post_type();
if ( 'attachment' === $support_slug ) {
	if ( wp_attachment_is( 'audio' ) ) {
		$support_slug .= ':audio';
	} elseif ( wp_attachment_is( 'video' ) ) {
		$support_slug .= ':video';
	}
}

if ( post_password_required() || ! post_type_supports( $support_slug, 'thumbnail' ) || ! has_post_thumbnail() ) {
	return;
}

if ( is_singular( get_post_type() ) ) {
	?>
	<div class="post-thumbnail">
		<?php the_post_thumbnail( 'ampy-featured', array( 'class' => 'skip-lazy' ) ); ?>
	</div><!-- .post-thumbnail -->
	<?php
} else {
	?>
	<a class="post-thumbnail" href="<?php the_permalink(); ?>" aria-hidden="true">
		<?php
		global $wp_query;
		global $template;
		global $mt_grid_query;
		if ( 0 === $wp_query->current_post || ( ! empty( $mt_grid_query ) && 0 === $mt_grid_query->current_post ) ) {
			the_post_thumbnail(
				'post-thumbnail',
				array(
					'class' => 'skip-lazy',
					'alt'   => the_title_attribute(
						array(
							'echo' => false,
						)
					),
				)
			);
		} else {
			the_post_thumbnail(
				'post-thumbnail',
				array(
					'alt' => the_title_attribute(
						array(
							'echo' => false,
						)
					),
				)
			);
		}
		if ( get_theme_mod( get_post_type() . '_layout', get_post_type() === 'portfolio' ? 'grid' : 'standard' ) === 'grid' ) {
			if ( get_theme_mod( 'show_grid_read_more', true ) ) {
				echo '<span class="card-label">' . esc_html( get_theme_mod( 'grid_read_more_label', __( 'Learn More...', 'ampy' ) ) ) . '</span>';
			} else {
				echo '<span class="card-label label-disabled"></span>';
			}
		}
		?>
	</a><!-- .post-thumbnail -->
	<?php
}
