<?php
/**
 * Template part for displaying a post's metadata
 *
 * @package ampy
 */

namespace MeanThemes\Ampy;

$post_type_obj = get_post_type_object( get_post_type() );

$time_string = '';
$entry_meta_class = '';

if ( get_theme_mod( get_post_type() . '_layout', get_post_type() === 'portfolio' ? 'grid' : 'standard' ) === 'grid' ) {
	$entry_meta_class = ' ' . get_theme_mod( 'card_meta_align', '' ) ;
}

// Show date only when the post type is 'post' or has an archive.
if ( 'post' === $post_type_obj->name || $post_type_obj->has_archive ) {
	$time_string = '<time class="entry-date published updated" datetime="%1$s">%2$s</time>';
	if ( get_the_time( 'U' ) !== get_the_modified_time( 'U' ) ) {
		$time_string = '<time class="entry-date published" datetime="%1$s">%2$s</time> - <time class="updated" datetime="%3$s">%4$s</time>';
	}

	$time_string = sprintf(
		$time_string,
		esc_attr( get_the_date( 'c' ) ),
		esc_html( get_the_date() ),
		esc_attr( get_the_modified_date( 'c' ) ),
		esc_html( get_the_modified_date() )
	);

	// $time_string = '<a href="' . esc_url( get_permalink() ) . '" rel="bookmark">' . $time_string . '</a>';
}

$author_string = '';

// Show author only if it is not disabled in Customizer and the post type supports it.
if ( get_theme_mod( 'show_author', true ) && post_type_supports( $post_type_obj->name, 'author' ) ) {
	$author_string = sprintf(
		'<span class="author vcard"><a class="url fn n" href="%1$s">%2$s</a></span>',
		esc_url( get_author_posts_url( get_the_author_meta( 'ID' ) ) ),
		esc_html( get_the_author() )
	);
}

$parent_string = '';

// Show parent post only if available and if the post type is 'attachment'.
if ( ! empty( $post->post_parent ) && 'attachment' === get_post_type() ) {
	$parent_string = sprintf(
		'<a href="%1$s">%2$s</a>',
		esc_url( get_permalink( $post->post_parent ) ),
		esc_html( get_the_title( $post->post_parent ) )
	);
}

?>
<div class="entry-meta<?php echo esc_attr( $entry_meta_class ); ?>">
	<?php
	if ( ! empty( $time_string ) ) {
		if ( get_post_type() === 'post' ) {
			?>
			<span class="posted-on">
				<?php
				printf(
					/* translators: %s: post date */
					esc_html_x( 'Posted on %s', 'post date', 'ampy' ),
					$time_string // phpcs:ignore WordPress.Security.EscapeOutput.OutputNotEscaped
				);
				?>
			</span>
			<?php
		} else {
			?>
			<span class="posted-on">
				<?php
				echo wp_kses_post( $time_string );
				?>
			</span>
			<?php
		}
	}

	if ( ! empty( $author_string ) ) {
		?>
		<span class="posted-by">
			<?php
			/* translators: %s: post author */
			$author_byline = _x( 'By %s', 'post author', 'ampy' );
			if ( ! empty( $time_string ) ) {
				/* translators: %s: post author */
				$author_byline = _x( 'by %s', 'post author', 'ampy' );
			}
			printf(
				esc_html( $author_byline ),
				$author_string // phpcs:ignore WordPress.Security.EscapeOutput.OutputNotEscaped
			);
			?>
		</span>
		<?php
	}

	if ( ! empty( $parent_string ) ) {
		?>
		<span class="posted-in">
			<?php
			/* translators: %s: post parent title */
			$parent_note = _x( 'In %s', 'post parent', 'ampy' );
			if ( ! empty( $time_string ) || ! empty( $author_string ) ) {
				/* translators: %s: post parent title */
				$parent_note = _x( 'in %s', 'post parent', 'ampy' );
			}
			printf(
				esc_html( $parent_note ),
				$parent_string // phpcs:ignore WordPress.Security.EscapeOutput.OutputNotEscaped
			);
			?>
		</span>
		<?php
	} else {

		$taxonomies = wp_list_filter(
			get_object_taxonomies( $post, 'objects' ),
			array(
				'public' => true,
			)
		);

		$category_taxonomy = null;

		foreach ( $taxonomies as $taxonomy ) { // phpcs:ignore WordPress.WP.GlobalVariablesOverride.Prohibited
			$category_taxonomy = ( strpos( $taxonomy->name, 'ategory' ) || 'portfolio-item' === $taxonomy->name ) ? $taxonomy : $category_taxonomy;
		}

		if ( $category_taxonomy ) {
			// Show terms for all categories associated with the post.

			/* translators: separator between taxonomy terms */
			$separator = _x( ', ', 'list item separator', 'ampy' );

			$class            = 'category-links term-links';
			$list             = get_the_term_list( $post->ID, $category_taxonomy->name, '', esc_html( $separator ), '' );
			/* translators: %s: list of taxonomy terms */
			$placeholder_text = __( ' in %s', 'ampy' );

			if ( ! empty( $list ) ) {
				?>
				<span class="<?php echo esc_attr( $class ); ?>">
					<?php
					printf(
						esc_html( $placeholder_text ),
						$list // phpcs:ignore WordPress.Security.EscapeOutput.OutputNotEscaped
					);
					?>
				</span>
				<?php
			}
		}
	}
	?>
</div><!-- .entry-meta -->
<?php
