<?php
/**
 * Template part for displaying a post's content
 *
 * @package ampy
 */

namespace MeanThemes\Ampy;

$content_class = '';

if ( get_theme_mod( 'justify_post_text', false ) && get_post_type() === 'post' ) {
	$content_class = ' justify-text';
}
?>

<div class="entry-content<?php echo esc_attr( $content_class ); ?>">
	<?php
	the_content(
		sprintf(
			wp_kses(
				/* translators: %s: Name of current post. Only visible to screen readers */
				__( 'Continue reading<span class="screen-reader-text"> "%s"</span>', 'ampy' ),
				array(
					'span' => array(
						'class' => array(),
					),
				)
			),
			get_the_title()
		)
	);

	wp_link_pages(
		array(
			'before' => '<div class="page-links">' . esc_html__( 'Pages:', 'ampy' ),
			'after'  => '</div>',
		)
	);
	?>
</div><!-- .entry-content -->
