<?php
/**
 * Template part for displaying a post
 *
 * @package ampy
 */

namespace MeanThemes\Ampy;

?>

<article id="post-<?php the_ID(); ?>" <?php post_class( 'entry' ); ?>>
	<?php
	get_template_part( 'template-parts/content/entry_header', get_post_type() );

	if ( is_search() || is_archive() || is_home() ) {
		get_template_part( 'template-parts/content/entry_summary', get_post_type() );
	} else {
		get_template_part( 'template-parts/content/entry_content', get_post_type() );
	}

	if ( ! is_archive() ) {
		get_template_part( 'template-parts/content/entry_footer', get_post_type() );
	}
	?>
</article><!-- #post-<?php the_ID(); ?> -->

<?php
if ( is_singular( get_post_type() ) ) {
	// Show post navigation only when the post type is 'post' or has an archive.
	if ( 'post' === get_post_type() || get_post_type_object( get_post_type() )->has_archive ) {

		// Don't print empty markup if there's nowhere to navigate.
		$previous = ( is_attachment() ) ? get_post( get_post()->post_parent ) : get_adjacent_post( false, '', true );
		$next     = get_adjacent_post( false, '', false );

		if ( $next || $previous ) {
			?>
			<nav class="navigation post-navigation" aria-label="Posts">
				<h2 class="screen-reader-text">Post navigation</h2>
				<div class="nav-links">
					<div class="nav-previous">
						<?php
						if ( $previous ) {
							$previous_title = explode( ':', $previous->post_title );
							if ( ! isset( $previous_title[1] ) ) {
								$previous_title[1] = '';
							}
							echo '<a href="' . esc_url( get_permalink( $previous ) ) . '" rel="prev"><div class="post-navigation-sub"><span>' . esc_html__( 'Previous', 'ampy' ) . '</span></div>' . esc_html( $previous_title[0] ) . '<br><span>' . esc_html( $previous_title[1] ) . '</span></a>';
							//next_post_link( '<span class="nav-next">%link</span>',     _x( '%title&nbsp;<i class="fa fa-angle-right"></i>', 'Next post link', 'understrap' ) );
						}
						?>
					</div>
					<div class="nav-next">
						<?php
						if ( $next ) {
							$next_title = explode( ':', $next->post_title );
							if ( ! isset( $next_title[1] ) ) {
								$next_title[1] = '';
							}
							echo '<a href="' . esc_url( get_permalink( $next ) ) . '" rel="next"><div class="post-navigation-sub"><span>' . esc_html__( 'Next', 'ampy' ) . '</span></div>' . esc_html( $next_title[0] ) . '<br><span>' . esc_html( $next_title[1] ) . '</span></a>';
							//previous_post_link( '<span class="nav-previous">%link</span>', _x( '<i class="fa fa-angle-left"></i>&nbsp;%title', 'Previous post link', 'understrap' ) );
						}
						?>
					</div>
				</div><!-- .nav-links -->
			</nav><!-- .navigation -->
			<?php
		}

		// the_post_navigation(
		// 	array(
		// 		'prev_text' => '<div class="post-navigation-sub"><span>' . esc_html__( 'Previous:', 'ampy' ) . '</span></div>%title',
		// 		'next_text' => '<div class="post-navigation-sub"><span>' . esc_html__( 'Next:', 'ampy' ) . '</span></div>%title',
		// 	)
		// );
	}

	// Show comments only when the post type supports it and when comments are open or at least one comment exists.
	if ( post_type_supports( get_post_type(), 'comments' ) && ( comments_open() || get_comments_number() ) ) {
		comments_template();
	}
}
