<?php
/**
 * Template part for displaying a post
 *
 * @package ampy
 */

namespace MeanThemes\Ampy;

?>

<article id="post-<?php the_ID(); ?>" <?php post_class( 'entry' ); ?>>
	<?php
//	get_template_part( 'template-parts/content/entry_header', get_post_type() );
	?>
<header class="entry-header">
	<?php
	get_template_part( 'template-parts/content/entry_thumbnail', get_post_type() );

	if ( get_theme_mod( 'show_meta' ) ) {
		get_template_part( 'template-parts/content/entry_meta', get_post_type() );
	}

	get_template_part( 'template-parts/content/entry_title', get_post_type() );

	if ( get_theme_mod( 'show_summary', true ) ) {
		get_template_part( 'template-parts/content/entry_summary', get_post_type() );
	}

	?>
</header><!-- .entry-header -->
</article><!-- #post-<?php the_ID(); ?> -->

<?php
if ( is_singular( get_post_type() ) ) {
	// Show post navigation only when the post type is 'post' or has an archive.
	if ( 'post' === get_post_type() || get_post_type_object( get_post_type() )->has_archive ) {
		the_post_navigation(
			array(
				'prev_text' => '<div class="post-navigation-sub"><span>' . esc_html__( 'Previous:', 'ampy' ) . '</span></div>%title',
				'next_text' => '<div class="post-navigation-sub"><span>' . esc_html__( 'Next:', 'ampy' ) . '</span></div>%title',
			)
		);
	}

	// Show comments only when the post type supports it and when comments are open or at least one comment exists.
	if ( post_type_supports( get_post_type(), 'comments' ) && ( comments_open() || get_comments_number() ) ) {
		comments_template();
	}
}
