<?php
/**
 * The main template file
 *
 * This is the most generic template file in a WordPress theme
 * and one of the two required files for a theme (the other being style.css).
 * It is used to display a page when nothing more specific matches a query.
 * E.g., it puts together the home page when no home.php file exists.
 *
 * @link https://codex.wordpress.org/Template_Hierarchy
 *
 * @package ampy
 */

namespace MeanThemes\Ampy;

get_header();

$entry_template = '';

ampy()->print_styles( 'ampy-content' );

if ( ! is_singular() && get_theme_mod( get_post_type() . '_layout', get_post_type() === 'portfolio' ? 'grid' : 'standard' ) === 'grid' ) {
	ampy()->print_styles( 'ampy-card-entries', 'ampy-card-entries' );
	$entry_template = '-grid';
}
?>
	<main id="primary" class="site-main">
		<?php
		if ( have_posts() ) {

			get_template_part( 'template-parts/content/page_header' );

			while ( have_posts() ) {
				the_post();

				get_template_part( 'template-parts/content/entry' . $entry_template, get_post_type() );

				if ( '' === $entry_template && get_theme_mod( 'show_article_separator', true ) ) {
					echo '<hr class="article-sep">';
				}
			}

			if ( ! is_singular() ) {
				get_template_part( 'template-parts/content/pagination' );
			}
		} else {
			get_template_part( 'template-parts/content/error' );
		}
		?>
	</main><!-- #primary -->
<?php
get_sidebar();
get_footer();
