<?php
/**
 * MeanThemes\Ampy\Excerpts\Component class
 *
 * @package ampy
 */

namespace MeanThemes\Ampy\Excerpts;

use MeanThemes\Ampy\Component_Interface;
use function MeanThemes\Ampy\ampy;
use function add_filter;

/**
 * Class for adjusting size and format for post excerpt.
 */
class Component implements Component_Interface {

	/**
	 * Gets the unique identifier for the theme component.
	 *
	 * @return string Component slug.
	 */
	public function get_slug() : string {
		return 'excerpts';
	}

	/**
	 * Adds the action and filter hooks to integrate with WordPress.
	 */
	public function initialize() {

		add_filter( 'excerpt_more', array( $this, 'new_excerpt_more' ) );
		add_filter( 'excerpt_length', array( $this, 'new_excerpt_length' ) );
	}

	/**
	 * Custom Excerpt ending.
	 */
	public function new_excerpt_more() {
		$link = '';

		if ( get_theme_mod( 'show_read_more' ) && get_theme_mod( get_post_type() . '_layout', get_post_type() === 'portfolio' ? 'grid' : 'standard' ) === 'standard' ) {
			$link = sprintf(
				'<a href="%1$s" class="more-link">%2$s</a>',
				esc_url( get_permalink( get_the_ID() ) ),
				/* translators: %s: Post title. */
				sprintf( get_theme_mod( 'read_more_label', __( 'Continue reading', 'ampy' ) ) . '<span class="screen-reader-text"> "%s"</span>', get_the_title( get_the_ID() ) )
			);
		}

		return '&hellip; ' . $link;
	}

	/**
	 * Custom Excerpt length.
	 */
	public function new_excerpt_length() {
		return get_theme_mod( 'summary_length', 12 );
	}


}
