<?php
/**
 * Template Name: Grid Home
 *
 * Render your site front page, whether the front page displays the blog posts index or a static page.
 *
 * @link https://developer.wordpress.org/themes/basics/template-hierarchy/#front-page-display
 *
 * @package ampy
 */

namespace MeanThemes\Ampy;

get_header();

ampy()->print_styles( 'ampy-content', 'ampy-front-page' );

if ( ampy()->is_header_hero_widgets_active() ) {
	echo '<section id="header-hero-widgets" class="site-hero hero-widgets-area widget-area">';

	ampy()->display_header_hero_widgets();

	echo '</section>';
}

?>
<main id="primary" class="site-main">
	<?php

	$paged_param = ( get_query_var( 'paged' ) ) ? get_query_var( 'paged' ) : 1;

	$args = array(
		'post_type'      => get_theme_mod( 'home_post_type', 'portfolio' ),
		'post_status'    => 'publish',
		'posts_per_page' => 9,
		'paged'          => $paged_param,
	);

	global $mt_grid_query;
	$mt_grid_query = new \WP_Query( $args );

	while ( $mt_grid_query->have_posts() ) {
		$mt_grid_query->the_post();

		get_template_part( 'template-parts/content/entry-grid', get_post_type() );
	}

	$GLOBALS['wp_query']->max_num_pages = $mt_grid_query->max_num_pages;
	get_template_part( 'template-parts/content/pagination' );
	wp_reset_postdata();
	?>
</main><!-- #primary -->
<?php

get_footer();
