<?php get_header(); ?>
<div class="twelve columns alpha">
	<div id="heading-holder">
		<?php if (is_front_page()){ ?>
			<h1 id="main-heading"><a href="<?php echo site_url(); ?>"><?php bloginfo('name'); ?></a></h1>			
			<p><?php bloginfo('description'); ?></p>		
		<?php } elseif (is_category()){ ?>
			<h1 id="main-heading">Category / <?php single_cat_title(); ?></h1>
		<?php } elseif (is_tag()) {?>	
			<h1 id="main-heading">Tag / <?php single_tag_title(); ?></h1>	
		<?php } elseif (is_archive()) { ?>
			<h1 id="main-heading">Archives / <?php the_time('F Y'); ?></h1>		
		<?php } elseif (is_search()) { ?>
			<h1 id="main-heading">Search Results</h1>
		<?php } ?>	
	</div>		
	<?php if (have_posts()) : ?>		
		<ul id="posts">
			<?php while (have_posts()) : the_post(); ?>				
				<li id="post-<?php the_ID(); ?>"  <?php post_class(); ?>>					
					<?php if (has_post_thumbnail()) { ?>
						<div class="featured two columns alpha">	
							<?php the_post_thumbnail(array(160,160)); ?>
						</div>
						<div class="ten columns omega">
							<h3><a href="<?php the_permalink() ?>"><?php the_title(); ?></a></h3>
							<?php the_excerpt(); ?>	
							<p class="meta">
								<span class="category"><?php the_category(' / '); ?></span>
								<?php
									$posttags = get_the_tags();
									if ($posttags) {
										echo '<span class="tags">';
									    foreach($posttags as $tag) {
									    	echo '<a href="' . get_tag_link( $tag->term_id ) . '">' . $tag->name.'</a> <span class="slash">/</span> '; 
									  	}
									  	echo '</span>';
									}
								?>														
							</p>															
						</div>												
					<?php } else { ?>					
						<h3><a href="<?php the_permalink() ?>"><?php the_title(); ?></a></h3>						
						<?php the_excerpt(); ?>	
						<p class="meta">
							<span class="category"><?php the_category(' / '); ?></span>
							<?php
								$posttags = get_the_tags();
								if ($posttags) {
									echo '<span class="tags">';
								    foreach($posttags as $tag) {
								    	echo '<a href="' . get_tag_link( $tag->term_id ) . '">' . $tag->name.'</a> <span class="slash">/</span> '; 
								  	}
								  	echo '</span>';
								}
							?>														
						</p>											
					<?php } ?> 				
				</li>						    
			<?php endwhile; ?>
			<?php else : ?>
			<li>Sorry, the post you're looking for couldn't be found.</li>
		</ul>		
	<?php endif; ?>
	<div id="pager"><p><?php posts_nav_link('<span id="infinity">&#8734;</span>','<span id="newer">&laquo;&laquo; Newer Posts</span>','<span id="older">Older Posts &raquo;&raquo;</span>'); ?></p></div>	
</div>
<?php get_sidebar(); ?>	
<?php get_footer(); ?>		