<?php

// define content area width
if (!isset($content_width)) $content_width = 700;

// sets up theme defaults and registers the WordPress features that Alpha Next uses
function alphanexus_setup() {	
	register_nav_menu('header-menu', __('Menu - Header', 'alphanexus'));
	register_nav_menu('footer-menu', __('Menu - Footer', 'alphanexus'));
	add_theme_support('post-thumbnails');
	set_post_thumbnail_size(640, 9999);
	add_theme_support('automatic-feed-links');	
}
add_action('after_setup_theme', 'alphanexus_setup');

// format page titles
function alphanexus_wp_title($title, $sep) {
	global $paged, $page;
	if (is_feed())
		return $title;	
	$title .= get_bloginfo('name');	
	$site_description = get_bloginfo('description','display');
	if ($site_description && (is_home() || is_front_page()))
		$title = "$title $sep $site_description";	
	if ($paged >= 2 || $page >= 2)
		$title = "$title $sep " . sprintf( __('Page %s', 'alphanexus'), max($paged, $page));
	return $title;
}
add_filter( 'wp_title', 'alphanexus_wp_title', 10, 2 );

// load styles
function alphanexus_styles() {
	wp_register_style('googleFonts', 'http://fonts.googleapis.com/css?family=Source+Sans+Pro');
    wp_enqueue_style('googleFonts');
    wp_enqueue_style('style', get_stylesheet_uri());    
}
add_action('wp_enqueue_scripts', 'alphanexus_styles');

// load javascript
function alphanexus_scripts() {
	if(!is_admin()){
		wp_enqueue_script('jquery');
		wp_enqueue_script('scripts', get_template_directory_uri() . '/assets/scripts.js');
	}
	if (is_singular()) wp_enqueue_script('comment-reply');
}
add_action('wp_enqueue_scripts', 'alphanexus_scripts');

//register footer and sidebar widgets
function alphanexus_widgets_init() {
	register_sidebar(array(
		'name' => __('Right Sidebar', 'alphanexus'),
		'id' => 'sidebar-widgets',
		'description' => __('Widgets in this area will appear in the right hand sidebar on all pages and posts.', 'alphanexus'),
		'before_widget' => '<aside id="%1$s" class="widget %2$s">',
		'after_widget' => "</aside>",
		'before_title' => '<h3 class="widget-title">',
		'after_title' => '</h3>'
	));
	register_sidebar(array(
		'name' => __('Footer Left', 'alphanexus'),
		'id' => 'footer-left',
		'description' => __('Widgets in this area will appear in the left column of the footer.', 'alphanexus'),
		'before_widget' => '<aside id="%1$s" class="widget %2$s">',
		'after_widget' => "</aside>",
		'before_title' => '<h3 class="widget-title">',
		'after_title' => '</h3>'
	));
	register_sidebar(array(
		'name' => __('Footer Middle', 'alphanexus'),
		'id' => 'footer-middle',
		'description' => __('Widgets in this area will appear in the middle column of the footer.', 'alphanexus'),
		'before_widget' => '<aside id="%1$s" class="widget %2$s">',
		'after_widget' => "</aside>",
		'before_title' => '<h3 class="widget-title">',
		'after_title' => '</h3>'
	));
	register_sidebar(array(
		'name' => __('Footer Right', 'alphanexus'),
		'id' => 'footer-right',
		'description' => __('Widgets in this area will appear in the right column of the footer.', 'alphanexus'),
		'before_widget' => '<aside id="%1$s" class="widget %2$s">',
		'after_widget' => "</aside>",
		'before_title' => '<h3 class="widget-title">',
		'after_title' => '</h3>'
	));	
}
add_action('widgets_init', 'alphanexus_widgets_init');

// custom header image
$defaults = array(
	'flex-width'    => true,	
	'flex-height'   => false,
	'height'        => 200,
	'header-text'   => false,
	'default-image' => get_template_directory_uri() . '/img/header.jpg'

);
add_theme_support('custom-header', $defaults);

// modify except trimmed output
function alphanexus_excerpt_more($more) {
	global $post;
	return '...';
}
add_filter('excerpt_more', 'alphanexus_excerpt_more');

?>