(function($){
	var $allm_content_area = $('#content-area'),
		allm_content_area_height = $allm_content_area.innerHeight(),
		$allm_sidebar = $('#sidebar'),
		$allm_footer = $('#main_footer');

	$(document).ready(function(){
		var $allm_image_entry = $('.entry.image'),
			$allm_audio_play = $('a.jp-play'),
			$allm_audio_pause = $('a.jp-pause'),
			image_entry_element = 'span.zoom',
			main_speed = 700;
		
		$allm_image_entry.find('.photo').hover(function(){
			$(this).find(image_entry_element).css({ opacity : 0, 'display' : 'block' }).stop(true,true).animate( { opacity: 1 }, main_speed );
		}, function(){
			$(this).find(image_entry_element).stop(true,true).animate( { opacity: 0 }, main_speed );
		});
		
		$allm_audio_play.click( function(){
			var $jp_progress = $(this).parents('.jp-controls').siblings('.jp-progress');
			
			if ( ! $jp_progress.is(':visible') ){
				$(this).parents('.jp-audio').siblings('.audio_info').find('p.meta').animate( { opacity : 0 }, 700 );
				$jp_progress.css( { 'opacity' : 0, 'display' : 'block' } ).animate( { opacity : 1 }, 700 );
			}
			
			$(this).parents('.entry.audio').find('> img').addClass('et_playing');
		} );
		
		$allm_audio_pause.click( function(){
			$(this).parents('.entry.audio').find('> img').removeClass('et_playing');
		} );
	});
	
	$(window).load(function(){
		$('#et_posts').masonry({
			itemSelector : '.entry',
			isAnimated : true
		});
		$('#footer-widgets').masonry({
			itemSelector : '.footer-widget',
			isAnimated : true
		});
		
		allm_calculate_blocks();
	});

	function allm_calculate_blocks(){
		var $allm_content_area_right = $('#content_right'),
			$allm_left_area = $('#left-area'),
			allm_sidebar_top = parseInt( $allm_sidebar.css('padding-top') ),
			allm_content_height = $allm_content_area_right.innerHeight(),
			allm_left_area_height = $allm_left_area.innerHeight();
		
		if ( allm_left_area_height > allm_content_height ) $allm_footer.css( 'height', $allm_footer.height() + allm_left_area_height - allm_content_height );
		else $allm_sidebar.css( 'height', $allm_content_area.height() - $allm_left_area.find('> header').height() - allm_sidebar_top );
	}
	
	$(window).bind( 'smartresize.masonry', function() {
		setTimeout(function() {
			$allm_sidebar.css( 'height', 'auto' );	
			$allm_footer.css( 'height', 'auto' );	
			allm_calculate_blocks();
		}, 1000);
	});
	
	var $comment_form = $('form#commentform'),
		$comment_form_textarea = $('p.comment-form-comment');
		
	$comment_form.find('input, textarea').each(function(index,domEle){
		var $allm_current_input = $(domEle),
			$allm_comment_label = $allm_current_input.siblings('label'),
			allm_comment_label_value = $allm_current_input.siblings('label').text();
		if ( $allm_comment_label.length ) {
			$allm_comment_label.hide();
			if ( $allm_current_input.siblings('span.required') ) { 
				allm_comment_label_value += $allm_current_input.siblings('span.required').text();
				$allm_current_input.siblings('span.required').hide();
			}
			$allm_current_input.val(allm_comment_label_value);
		}
	}).live('focus',function(){
		var allm_label_text = $(this).siblings('label').text();
		if ( $(this).siblings('span.required').length ) allm_label_text += $(this).siblings('span.required').text();
		if ($(this).val() === allm_label_text) $(this).val("");
	}).live('blur',function(){
		var allm_label_text = $(this).siblings('label').text();
		if ( $(this).siblings('span.required').length ) allm_label_text += $(this).siblings('span.required').text();
		if ($(this).val() === "") $(this).val( allm_label_text );
	});

	$comment_form.find('input#submit').click(function(){
		if ($("input#url").val() === $("input#url").siblings('label').text()) $("input#url").val("");
	});
	
	$comment_form_textarea.insertBefore('p.comment-form-author');
})(jQuery)