<div id="category-name">
	<?php 
		$allm_page_title = '';
		$allm_tagline = '';
		if( is_tag() ) {
			$allm_page_title = esc_html__('Posts Tagged &quot;','allmed') . single_tag_title('',false) . '&quot;';
		} elseif (is_day()) {
			$allm_page_title = esc_html__('Posts made in','allmed') . ' ' . get_the_time('F jS, Y');
		} elseif (is_month()) {
			$allm_page_title = esc_html__('Posts made in','allmed') . ' ' . get_the_time('F, Y');
		} elseif (is_year()) {
			$allm_page_title = esc_html__('Posts made in','allmed') . ' ' . get_the_time('Y');
		} elseif (is_search()) {
			$allm_page_title = esc_html__('Search results for','allmed') . ' ' . get_search_query();
		} elseif (is_category()) {
			$allm_page_title = single_cat_title('',false);
			$allm_tagline = category_description();
		} elseif (is_author()) {
			global $wp_query;
			$curauth = $wp_query->get_queried_object();
			$allm_page_title = esc_html__('Posts by ','allmed') . $curauth->nickname;
		} elseif ( is_single() || is_page() ) {
			$allm_page_title = get_the_title();
			if ( is_page() ) $allm_tagline = get_post_meta($post->ID,'Description',true) ? get_post_meta($post->ID,'Description',true) : '';
		}
	?>
	<h1 class="title"><?php echo $allm_page_title; ?></h1>
	<?php if ( $allm_tagline <> '' ) { ?>
		<p class="meta-info"><?php echo wp_kses( $allm_tagline, array( 'span' => array() ) );  ?></p>
	<?php } ?>
	
	<?php if ( is_single() ) { ?>
		<?php get_template_part('includes/postinfo'); ?>
		<?php the_tags(); ?>
	<?php } ?>
</div> <!-- end #category-name -->