<?php 

/* Meta boxes */

function allmed_settings(){
	add_meta_box("allm_post_meta", "ALLMED Settings", "allmed_display_options", "post", "normal", "high");
}
add_action("admin_init", "allmed_settings");

function allmed_display_options($callback_args) {
	global $post;
			
	$allm_fs_video = get_post_meta( $post->ID, '_et_allmed_video_url', true );
	$allm_fs_audio_mp3 = get_post_meta( $post->ID, '_et_allmed_audio_mp3_url', true );
	$allm_fs_audio_ogg = get_post_meta( $post->ID, '_et_allmed_audio_ogg_url', true );
?>
	
	<?php wp_nonce_field( basename( __FILE__ ), 'allm_settings_nonce' ); ?>
	
	<div id="allm_custom_settings" style="margin: 13px 0 17px 4px;">				
		
		<h4 style="font-size: 13px;"><?php esc_html_e('Video Post Format Settings: ','allmed'); ?></h4>
		
		<div class="allm_fs_setting" style="margin: 13px 0 26px 4px;">
			<label for="allm_fs_video" style="color: #000; font-weight: bold;"> <?php esc_html_e('Video url:','allmed'); ?> </label>
			<input type="text" style="width: 30em;" value="<?php echo esc_url($allm_fs_video); ?>" id="allm_fs_video" name="allm_fs_video" size="67" />
			<br />
			
		</div>
		
		<h4 style="font-size: 13px; margin-top: 45px;"><?php esc_html_e('Audio Post Format Settings: ','allmed'); ?></h4>
		
		<div class="allm_fs_setting" style="margin: 13px 0 26px 4px;">
			<label for="allm_fs_audio_mp3" style="color: #000; font-weight: bold;"> <?php esc_html_e('Audio Mp3 Url:','allmed'); ?> </label>
			<input type="text" style="width: 30em;" value="<?php echo esc_url($allm_fs_audio_mp3); ?>" id="allm_fs_audio_mp3" name="allm_fs_audio_mp3" size="67" />
			<br />
			
		</div>
		
		
		
	</div> <!-- #allm_custom_settings -->
		
	<?php
}

add_action( 'save_post', 'allmed_save_details', 10, 2 );
function allmed_save_details( $post_id, $post ){
	global $pagenow;
	if ( 'post.php' != $pagenow ) return $post_id;
		
	if ( defined('DOING_AUTOSAVE') && DOING_AUTOSAVE ) 
		return $post_id;

	$post_type = get_post_type_object( $post->post_type );
	if ( !current_user_can( $post_type->cap->edit_post, $post_id ) )
		return $post_id;
		
	if ( !isset( $_POST['allm_settings_nonce'] ) || !wp_verify_nonce( $_POST['allm_settings_nonce'], basename( __FILE__ ) ) )
        return $post_id;
		
	if ( isset($_POST["allm_fs_video"]) ) update_post_meta( $post_id, "_et_allmed_video_url", esc_url_raw( $_POST["allm_fs_video"] ) );
	if ( isset($_POST["allm_fs_audio_mp3"]) ) update_post_meta( $post_id, "_et_allmed_audio_mp3_url", esc_url_raw( $_POST["allm_fs_audio_mp3"] ) );
	if ( isset($_POST["allm_fs_audio_ogg"]) ) update_post_meta( $post_id, "_et_allmed_audio_ogg_url", esc_url_raw( $_POST["allm_fs_audio_ogg"] ) );
} ?>