<?php 
function allmed_filter_wp_title( $title ) {
	global $page, $paged;
    $site_name = get_bloginfo( 'name' );
    $filtered_title = $site_name . $title;
      return $filtered_title;
	  $site_description = get_bloginfo( 'description', 'allmed' );
	if ( $site_description && ( is_home() || is_front_page() ) )
		echo " | $site_description";
		if ( $paged >= 2 || $page >= 2 )
		echo ' | ' . sprintf( __( 'Page %s', 'allmed' ), max( $paged, $page ) ); 
}
add_filter( 'wp_title', 'allmed_filter_wp_title' );
	function allm_setup_theme(){
		global  $allm_jplayer_instances_on_page, $allmed_favicon_url, $allm_footer_text, $content_width;
		    if ( ! isset( $content_width ) ) 
        $content_width = 630;
		$allm_jplayer_instances_on_page = 0;
        $allm_footer_text = '&copy;'.date('Y').' <a href="'.get_home_url().'">'.get_bloginfo('name').'</a>.'
      .' Powered by <a href="http://wordpress.org">WordPress</a>.';	 
		
		require_once(get_template_directory() . '/custom_functions.php'); 

		require_once(get_template_directory()  . '/includes/functions/comments.php'); 

		load_theme_textdomain( 'allmed', get_template_directory() . '/languages' );
	
		require_once(get_template_directory()  . '/includes/additional_functions.php');

		
		
			if ( ! defined( 'ALLMED_COLOR_LINK' ) )
	  define( 'ALLMED_COLOR_LINK', '#eab910' );
			if ( ! defined( 'ALLMED_COLOR_H' ) )
	  define( 'ALLMED_COLOR_H', '#eab910' );	
	  	if ( ! defined( 'ALLMED_COLOR_TEXT' ) )	
	  define( 'ALLMED_COLOR_TEXT', '#000000' );
	  	if ( ! defined( 'ALLMED_EXCERPT_BACKGROUND' ) )	
	  define( 'ALLMED_EXCERPT_BACKGROUND', '#ebebee' );	
	  	if ( ! defined( 'ALLMED_EXCERPT_BORDER' ) )	
	  define( 'ALLMED_EXCERPT_BORDER', '#506774' );	
	  	if ( ! defined( 'ALLMED_WIDGET_BACKGROUND' ) )	
	  define( 'ALLMED_WIDGET_BACKGROUND', '#ebebee' );		  
	  	if ( ! defined( 'ALLMED_WIDGET_TITLE_BACKGROUND' ) )	
	  define( 'ALLMED_WIDGET_TITLE_BACKGROUND', '#506774' );	
	  	if ( ! defined( 'ALLMED_FOOTER_BACKGROUND' ) )	
	  define( 'ALLMED_FOOTER_BACKGROUND', '#506774' );	
	  	if ( ! defined( 'ALLMED_FOOTER_COLOR' ) )	
	  define( 'ALLMED_FOOTER_COLOR', '#FFFFFF' );	
	  	if ( ! defined( 'ALLMED_WRAPPER_BACKGROUND' ) )	
	  define( 'ALLMED_WRAPPER_BACKGROUND', '#FFFFFF' );
	  	  	if ( ! defined( 'ALLMED_SINGLE_BACKGROUND' ) )	
	  define( 'ALLMED_SINGLE_BACKGROUND', '#ebebee' );
	  	 if ( ! defined( 'ALLMED_SUBMIT_BACKGROUND' ) )	
	  define( 'ALLMED_SUBMIT_BACKGROUND', '#ebebee' );
	  	 if ( ! defined( 'ALLMED_LINE_COLOR' ) )	
	  define( 'ALLMED_LINE_COLOR', '#ebebee' );	  
	  	 if ( ! defined( 'ALLMED_MENU_BACKGROUND' ) )	
	  define( 'ALLMED_MENU_BACKGROUND', '#ebebee' );	
	  	 if ( ! defined( 'ALLMED_WIDGET_H' ) )	
	  define( 'ALLMED_WIDGET_H', '#ffffff' );
	  	 if ( ! defined( 'ALLMED_ENTRY_LINK' ) )	
	  define( 'ALLMED_ENTRY_LINK', '#eab910' );
 	  	 if ( ! defined( 'ALLMED_ENTRY_TEXT' ) )	
	  define( 'ALLMED_ENTRY_TEXT', '#000000' ); 	 
	  
	add_theme_support( 'post-formats', array( 'image', 'audio', 'video') );
	add_theme_support( 'post-thumbnails' );
	set_post_thumbnail_size(270, 180, true);
	add_theme_support( 'custom-background' );
	add_theme_support( 'automatic-feed-links' );	 

	}

add_action( 'after_setup_theme', 'allm_setup_theme' );



function allmed_widget_init() {	
register_sidebar(array(
		'name' => 'Sidebar',
		'before_widget' => '<div id="%1$s" class="widget %2$s">',
		'after_widget' => '</div> <!-- end .widget -->',
		'before_title' => '<h4 class="widget-title">',
		'after_title' => '</h4>',
    ));
	
	register_sidebar(array(
		'name' => 'Footer',
		'before_widget' => '<div id="%1$s" class="footer-widget %2$s">',
		'after_widget' => '</div> <!-- end .footer-widget -->',
		'before_title' => '<h4 class="widgettitle">',
		'after_title' => '</h4>',
    ));
  } 	
add_action( 'widgets_init', 'allmed_widget_init' );


  function allmed_get_option($Aoption_name, $default = null)
  {
    return stripslashes(get_option($Aoption_name, $default));
  };

	
function allm_register_main_menus() {
	register_nav_menus(
		array(
			'primary-menu' => __( 'Primary Menu', 'allmed' )
		)
	);
}
add_action( 'after_setup_theme', 'allm_register_main_menus' );

add_filter('the_content', 'my_fancyboxrel');
function my_fancyboxrel($content) {
       global $post;
       $pattern ="/<a(.*?)href=('|\")(.*?).(bmp|gif|jpeg|jpg|png)('|\")(.*?)>/i";
       $replacement = '<a$1href=$2$3.$4$5 rel="fancybox" title="'.$post->post_title.'"$6>';
       $content = preg_replace($pattern, $replacement, $content);
       return $content;
}


	function allm_get_the_author_posts_link(){
		global $authordata;
		$link = sprintf(
			'<a href="%1$s" title="%2$s" rel="author">%3$s</a>',
			get_author_posts_url( $authordata->ID, $authordata->user_nicename ),
			esc_attr( sprintf( __( 'Posts by %s', 'allmed' ), get_the_author() ) ),
			get_the_author()
		);
		return apply_filters( 'the_author_posts_link', $link );
	}




function allm_short_title($char) {
		global $post;
         $title = get_the_title($post->ID);
         $title = substr($title,0,$char);
         echo $title;
}


	function allm_postinfo_meta( $postinfo, $date_format, $comment_zero, $comment_one, $comment_more ){
		
		
		$postinfo_meta = '';
		
		if ( in_array( 'author', $postinfo ) ){
			$postinfo_meta .= ' ' . esc_html__('By','allmed') . ' ' . allm_get_the_author_posts_link();
		}
			
		if ( in_array( 'date', $postinfo ) )
			$postinfo_meta .= ' ' . esc_html__('Date:','allmed') . ' ' . get_the_time( $date_format );
			
		if ( in_array( 'categories', $postinfo ) )
			$postinfo_meta .= ' ' . esc_html__('in','allmed') . ' ' . get_the_category_list(', ');
			
		if ( in_array( 'comments', $postinfo ) )
			$postinfo_meta .= ' | ' . allm_get_comments_popup_link( $comment_zero, $comment_one, $comment_more );
			
		echo $postinfo_meta;
	}



	function allm_get_comments_popup_link( $zero = false, $one = false, $more = false ){

		
		$id = get_the_ID();
		$number = get_comments_number( $id );

		if ( 0 == $number && !comments_open() && !pings_open() ) return;
		
		if ( $number > 1 )
			$output = str_replace('%', number_format_i18n($number), ( false === $more ) ? __('% Comments', 'allmed') : $more);
		elseif ( $number == 0 )
			$output = ( false === $zero ) ? __('No Comments','allmed') : $zero;
		else // must be one
			$output = ( false === $one ) ? __('1 Comment', 'allmed') : $one;
			
		return '<span class="comments-number">' . '<a href="' . esc_url( get_permalink() . '#respond' ) . '">' . apply_filters('comments_number', $output, $number) . '</a>' . '</span>';
		
	}



	add_action('wp_head', 'allmed_head');

  function allmed_head()
  {  
    if (!is_admin())
	{
	  global $allmed_favicon_url;
?>	
<link rel="shortcut icon" href="<?php echo sanitize_text_field(allmed_get_option('allmed_favicon_url', $allmed_favicon_url)); ?>" type="image/x-icon" />
<?php	
	  $background = get_theme_mod('background_image', false);
	  $bgcolor = get_theme_mod('background_color', false);

?>
<style type="text/css"> 
body, .header, p.meta, .single_view p.meta-info   { color: <?php echo get_option('ALLMED_COLOR_TEXT', ALLMED_COLOR_TEXT); ?>}
#sidebar a, #footer-widgets a, #top-menu a {color:<?php echo get_option('ALLMED_COLOR_LINK', ALLMED_COLOR_LINK); ?>}
#sidebar h4, .widgettitle, .wrap-pagin a {color:<?php echo get_option('ALLMED_WIDGET_H', ALLMED_WIDGET_H); ?>}
h1,h3,h4,h5, .widget_rss a.rsswidget, .post h1 a, #comments h3 {color: <?php echo get_option('ALLMED_COLOR_H', ALLMED_COLOR_H); ?>;}
.entry.normal-post .main_content, .entry.image, .entry.video, .entry.audio, #breadcrumbs  {background:<?php echo get_option('ALLMED_EXCERPT_BACKGROUND', ALLMED_EXCERPT_BACKGROUND); ?>;}
.entry.normal-post .main_content, .entry.image, .entry.video, .entry.audio {border-color:<?php echo get_option('ALLMED_EXCERPT_BORDER', ALLMED_EXCERPT_BORDER); ?>;}
.widget, #footer-widgets ul li, #top-menu  {background:<?php echo get_option('ALLMED_WIDGET_BACKGROUND', ALLMED_WIDGET_BACKGROUND); ?>;}
h4.widget-title, #footer-widgets h4, .wrap-pagin  {background:<?php echo get_option('ALLMED_WIDGET_TITLE_BACKGROUND', ALLMED_WIDGET_TITLE_BACKGROUND); ?>;}
.footer {background:<?php echo get_option('ALLMED_FOOTER_BACKGROUND', ALLMED_FOOTER_BACKGROUND); ?>;}
.footer, .footer a, .footer  .fr a:hover  {color:<?php echo get_option('ALLMED_FOOTER_COLOR', ALLMED_FOOTER_COLOR); ?>;}
.wrapper, #footer-widgets, .foot-max, #sidebar, #left-area, #top-menu:after, #top-menu:before   {background:<?php echo get_option('ALLMED_WRAPPER_BACKGROUND', ALLMED_WRAPPER_BACKGROUND); ?>;}
.single_view, .comment-body, #commentform textarea  {background:<?php echo get_option('ALLMED_SINGLE_BACKGROUND', ALLMED_SINGLE_BACKGROUND); ?>;}
#submit, .reply-container a, .form-submit input, #searchsubmit  {background:<?php echo get_option('ALLMED_SUBMIT_BACKGROUND', ALLMED_SUBMIT_BACKGROUND); ?>;}
#left-area, #footer-widgets {border-color:<?php echo get_option('ALLMED_LINE_COLOR', ALLMED_LINE_COLOR); ?>;}
.content a, .single_view h1.main_title {color:<?php echo get_option('ALLMED_ENTRY_LINK', ALLMED_ENTRY_LINK); ?>;}
.content, .single_view {color:<?php echo get_option('ALLMED_ENTRY_TEXT', ALLMED_ENTRY_TEXT); ?>;}
#top-menu {background:<?php echo get_option('ALLMED_MENU_BACKGROUND', ALLMED_MENU_BACKGROUND); ?>;}
</style>
<?php	  
	};
  };



  function allmed_show_color_picker($Aname, $Aoption, $Adefault)
  {  
?>  
<label for="<?php echo $Aname; ?>">
<input type="text" id="<?php echo $Aname; ?>" 
name="<?php echo $Aname; ?>" value="<?php echo sanitize_text_field(get_option($Aoption, $Adefault)); ?>" /> 
<?php _e('Pick link color', 'allmed'); ?></label>
<div id="<?php echo $Aname.'_p'; ?>"></div>

<script type="text/javascript">
  jQuery(document).ready(function() {
  jQuery('#<?php echo $Aname.'_p'; ?>').hide();
  jQuery('#<?php echo $Aname.'_p'; ?>').farbtastic("#<?php echo $Aname; ?>");
  jQuery("#<?php echo $Aname; ?>").click(function(){jQuery('#<?php echo $Aname.'_p'; ?>').slideToggle()});
});
</script>
<?php
   };
 
 
 	$allm_options = get_option( 'allm_options' );
	$ALLMED_COLOR_LINK = $allm_options['ALLMED_COLOR_LINK'];
	$ALLMED_COLOR_H = $allm_options['ALLMED_COLOR_H'];
	$ALLMED_COLOR_TEXT = $allm_options['ALLMED_COLOR_TEXT'];
	$ALLMED_EXCERPT_BACKGROUND = $allm_options['ALLMED_EXCERPT_BACKGROUND'];
	$ALLMED_EXCERPT_BORDER = $allm_options['ALLMED_EXCERPT_BORDER'];
	$ALLMED_WIDGET_BACKGROUND = $allm_options['ALLMED_WIDGET_BACKGROUND'];
	$ALLMED_WIDGET_TITLE_BACKGROUND = $allm_options['ALLMED_WIDGET_TITLE_BACKGROUND'];
	$ALLMED_FOOTER_BACKGROUND = $allm_options['ALLMED_FOOTER_BACKGROUND'];
	$ALLMED_FOOTER_COLOR = $allm_options['ALLMED_FOOTER_COLOR'];
	$ALLMED_WRAPPER_BACKGROUND = $allm_options['ALLMED_WRAPPER_BACKGROUND'];
	$ALLMED_SINGLE_BACKGROUND = $allm_options['ALLMED_SINGLE_BACKGROUND'];
	$ALLMED_SUBMIT_BACKGROUND = $allm_options['ALLMED_SUBMIT_BACKGROUND'];
	$ALLMED_LINE_COLOR = $allm_options['ALLMED_LINE_COLOR'];
	$ALLMED_MENU_BACKGROUND = $allm_options['ALLMED_MENU_BACKGROUND'];
	$ALLMED_WIDGET_H = $allm_options['ALLMED_WIDGET_H'];
	$ALLMED_ENTRY_LINK = $allm_options['ALLMED_ENTRY_LINK'];
	$ALLMED_ENTRY_TEXT = $allm_options['ALLMED_ENTRY_TEXT'];

	  	  
   function allm_options_update() 
   {
     global $_POST, $allmed_favicon_url, $allm_footer_text;
		
	 if ($_POST['allmed_favicon_url'] != '')
	 {
	   update_option('allmed_favicon_url', $_POST['allmed_favicon_url']);
	 } else 
	 {
	   update_option('allmed_favicon_url', $allmed_favicon_url);	  
	 };
		
		if ($_POST['allm_footer_text'] != '')
	{
	  update_option('allm_footer_text', $_POST['allm_footer_text']);
	} else 
	{
	  update_option('allm_footer_text', $footer_text);	  
	};		
	



  };
	 
    
  
  function allmed_options_validate ( $allmed_options) {  
    $output = array();  
    foreach( $allmed_options as $key => $value ) {  
        if( isset( $allmed_options[$key] ) ) {  
            $output[$key] = strip_tags( stripslashes( $allmed_options[ $key ] ) );        
        }          
    }  
    return apply_filters( 'allmed_options_validate', $output, $allmed_options );    
}  


	  

	
function allmed_general_options_input() {  
 register_setting('allmed_general_options_page','allmed_general_options_page','allmed_options_validate'); 	
}

add_action( 'admin_init', 'allmed_general_options_input' );  


  function allmed_options_admin_menu() 
  {	    
	$allmed_theme_page = add_theme_page(__("Allmed Options", 'allmed'), __("Allmed Options", 'allmed'), 
	  'edit_theme_options', 'allmed_general_options_page', 'allmed_general_options_page');	
 if(!$allmed_theme_page) return;	
    add_action('admin_print_styles-' . $allmed_theme_page, 'allmed_ilc_farbtastic_script'); 
  };

  
  add_action('admin_menu', 'allmed_options_admin_menu');
  
  
  

  function allmed_ilc_farbtastic_script( $hook_suffix ) 
  { 
      wp_enqueue_style( 'farbtastic' );
      wp_enqueue_script( 'farbtastic' );
  };

 

  function allmed_general_options_page()
  {
    global  $_POST, $allmed_favicon_url, $allm_footer_text; 
	
   if ( isset($_POST['update_options']) && $_POST['update_options'] == 'true' ) { allm_options_update(); };?>
	<div class="wrap">
        <div id="icon-options-general" class="icon32"><br /></div>
		<h2><?php _e('Allmed General Options', 'allmed'); ?></h2>

        <form method="post" action="options.php">
		<?php if ( function_exists('wp_nonce_field') ) 
 wp_nonce_field('update-options'); ?>

			
            <table class="form-table">			    		
			    <tr valign="top">
                    <th scope="row"><label for="allmed_favicon_url"><?php _e('Favicon:', 'allmed'); ?></label></th>
                    <td><input type="text" name="allmed_favicon_url" size="95" 
					  value="<?php echo sanitize_text_field(allmed_get_option('allmed_favicon_url', $allmed_favicon_url)); ?>"/>
					<br/>
					<span class="description"> 
					<?php printf(__('<a href="%s" target="_blank">Upload your favicon</a> using WordPress Media Library and insert its URL here', 
					  'allmed'), home_url().'/wp-admin/media-new.php'); ?>
					</span><br/><br/>
					<img src="<?php echo sanitize_text_field(allmed_get_option('allmed_favicon_url', $allmed_favicon_url)); ?>" alt=""/>
					</td>
                </tr>
	
			
				<tr valign="top">
                  <th scope="row"><label><?php _e('Links color:','allmed'); ?></label></th>
                  <td><?php allmed_show_color_picker('ALLMED_COLOR_LINK', 'ALLMED_COLOR_LINK', ALLMED_COLOR_LINK); ?></td>
                </tr>
				
					<tr valign="top">
                  <th scope="row"><label><?php _e('H color:','allmed'); ?></label></th>
                  <td><?php allmed_show_color_picker('ALLMED_COLOR_H', 'ALLMED_COLOR_H', ALLMED_COLOR_H); ?></td>
                </tr>
				
					<tr valign="top">
                  <th scope="row"><label><?php _e('Data color:','allmed'); ?></label></th>
                  <td><?php allmed_show_color_picker('ALLMED_COLOR_TEXT', 'ALLMED_COLOR_TEXT', ALLMED_COLOR_TEXT); ?></td>
                </tr>
					<tr valign="top">
                  <th scope="row"><label><?php _e('Excerpt background color:','allmed'); ?></label></th>
                  <td><?php allmed_show_color_picker('ALLMED_EXCERPT_BACKGROUND', 'ALLMED_EXCERPT_BACKGROUND', ALLMED_EXCERPT_BACKGROUND); ?></td>
                </tr>
				
					<tr valign="top">
                  <th scope="row"><label><?php _e('Excerpt border color:','allmed'); ?></label></th>
                  <td><?php allmed_show_color_picker('ALLMED_EXCERPT_BORDER', 'ALLMED_EXCERPT_BORDER', ALLMED_EXCERPT_BORDER); ?></td>
                </tr>	
					<tr valign="top">
                  <th scope="row"><label><?php _e('Widget background color:','allmed'); ?></label></th>
                  <td><?php allmed_show_color_picker('ALLMED_WIDGET_BACKGROUND', 'ALLMED_WIDGET_BACKGROUND', ALLMED_WIDGET_BACKGROUND); ?></td>
                </tr>	
					<tr valign="top">
                  <th scope="row"><label><?php _e('Widget title background color:','allmed'); ?></label></th>
                  <td><?php allmed_show_color_picker('ALLMED_WIDGET_TITLE_BACKGROUND', 'ALLMED_WIDGET_TITLE_BACKGROUND', ALLMED_WIDGET_TITLE_BACKGROUND); ?></td>
                </tr>
				
					<tr valign="top">
                  <th scope="row"><label><?php _e('Footer background color:','allmed'); ?></label></th>
                  <td><?php allmed_show_color_picker('ALLMED_FOOTER_BACKGROUND', 'ALLMED_FOOTER_BACKGROUND', ALLMED_FOOTER_BACKGROUND); ?></td>
                </tr>		

					<tr valign="top">
                  <th scope="row"><label><?php _e('Footer text color:','allmed'); ?></label></th>
                  <td><?php allmed_show_color_picker('ALLMED_FOOTER_COLOR', 'ALLMED_FOOTER_COLOR', ALLMED_FOOTER_COLOR); ?></td>
                </tr>				

					<tr valign="top">
                  <th scope="row"><label><?php _e('Wrapper background color:','allmed'); ?></label></th>
                  <td><?php allmed_show_color_picker('ALLMED_WRAPPER_BACKGROUND', 'ALLMED_WRAPPER_BACKGROUND', ALLMED_WRAPPER_BACKGROUND); ?></td>
                </tr>		

					<tr valign="top">
                  <th scope="row"><label><?php _e('Single post background color:','allmed'); ?></label></th>
                  <td><?php allmed_show_color_picker('ALLMED_SINGLE_BACKGROUND', 'ALLMED_SINGLE_BACKGROUND', ALLMED_WRAPPER_BACKGROUND); ?></td>
                </tr>

					<tr valign="top">
                  <th scope="row"><label><?php _e('Submit button color:','allmed'); ?></label></th>
                  <td><?php allmed_show_color_picker('ALLMED_SUBMIT_BACKGROUND', 'ALLMED_SUBMIT_BACKGROUND', ALLMED_SUBMIT_BACKGROUND); ?></td>
                </tr>		

					<tr valign="top">
                  <th scope="row"><label><?php _e('Line color:','allmed'); ?></label></th>
                  <td><?php allmed_show_color_picker('ALLMED_LINE_COLOR', 'ALLMED_LINE_COLOR', ALLMED_LINE_COLOR); ?></td>
                </tr>

					<tr valign="top">
                  <th scope="row"><label><?php _e('Menu background:','allmed'); ?></label></th>
                  <td><?php allmed_show_color_picker('ALLMED_MENU_BACKGROUND', 'ALLMED_MENU_BACKGROUND', ALLMED_MENU_BACKGROUND); ?></td>
                </tr>	

					<tr valign="top">
                  <th scope="row"><label><?php _e('Widget title:','allmed'); ?></label></th>
                  <td><?php allmed_show_color_picker('ALLMED_WIDGET_H', 'ALLMED_WIDGET_H', ALLMED_WIDGET_H); ?></td>
                </tr>	

					<tr valign="top">
                  <th scope="row"><label><?php _e('Excerpt link:','allmed'); ?></label></th>
                  <td><?php allmed_show_color_picker('ALLMED_ENTRY_LINK', 'ALLMED_ENTRY_LINK', ALLMED_ENTRY_LINK); ?></td>
                </tr>		

					<tr valign="top">
                  <th scope="row"><label><?php _e('Text color:','allmed'); ?></label></th>
                  <td><?php allmed_show_color_picker('ALLMED_ENTRY_TEXT', 'ALLMED_ENTRY_TEXT', ALLMED_ENTRY_TEXT); ?></td>
                </tr>	
		
			<tr valign="top">
                  <th scope="row"><label for="allm_footer_text"><?php _e('Footer text:', 'allmed'); ?></label></th>
                  <td><textarea style="width:100%" name="allm_footer_text"><?php echo sanitize_text_field(allmed_get_option('allm_footer_text', 
					  $allm_footer_text)); ?></textarea></td>
                </tr>					
				
                     </table>
	<input type="hidden" name="action" value="update" />
<input type="hidden" name="page_options" value="allmed_favicon_url,ALLMED_COLOR_LINK,ALLMED_COLOR_H,ALLMED_COLOR_TEXT,ALLMED_EXCERPT_BACKGROUND,ALLMED_EXCERPT_BORDER,ALLMED_WIDGET_BACKGROUND,ALLMED_WIDGET_TITLE_BACKGROUND,ALLMED_FOOTER_BACKGROUND,ALLMED_FOOTER_COLOR, ALLMED_WRAPPER_BACKGROUND, ALLMED_SINGLE_BACKGROUND, ALLMED_SUBMIT_BACKGROUND, ALLMED_LINE_COLOR, ALLMED_MENU_BACKGROUND, ALLMED_WIDGET_H, ALLMED_ENTRY_LINK,  ALLMED_ENTRY_TEXT, allm_footer_text" />
	<a href="https://twitter.com/wpmole" class="twitter-follow-button" data-show-count="false">Follow @wpmole</a>
<script>!function(d,s,id){var js,fjs=d.getElementsByTagName(s)[0],p=/^http:/.test(d.location)?'http':'https';if(!d.getElementById(id)){js=d.createElement(s);js.id=id;js.src=p+'://platform.twitter.com/widgets.js';fjs.parentNode.insertBefore(js,fjs);}}(document, 'script', 'twitter-wjs');</script> <a href="http://www.facebook.com/pages/WPMole/142454599181539" target="_blank"><img src="<?php echo get_template_directory_uri(); ?>/images/facebook.png" /></a>  <a href="http://wpmole.com" target="_blank">WPMole</a>
	<?php submit_button(); ?>
        </form>
		
    </div>
	<?php
if ( !empty($_POST) && check_admin_referer( 'update-options') ) {
}
  };


	function allm_list_pings($comment, $args, $depth) {
		$GLOBALS['comment'] = $comment; ?>
		<li id="comment-<?php comment_ID(); ?>"><?php comment_author_link(); ?> - <?php comment_excerpt(); ?>
	<?php }


add_filter( 'allm_get_additional_color_scheme', 'allm_remove_additional_stylesheet' );
function allm_remove_additional_stylesheet( $stylesheet ){
	global $default_colorscheme;
	return $default_colorscheme;
}


add_action( 'wp_enqueue_scripts', 'allmed_scripts' );
function allmed_scripts(){
	if ( ! is_admin() ){
		$template_dir = get_template_directory_uri();
		
		wp_enqueue_script('jplayer', $template_dir . '/js/jquery.jplayer.min.js', array('jquery'), '2.0.0', false);
		wp_enqueue_script('masonry', $template_dir . '/js/jquery.masonry.min.js', array('jquery'), '2.0.111015', true);
		wp_enqueue_script('custom', $template_dir . '/js/custom.js', array('jquery'), '1.0', true);
		wp_enqueue_script( 'jquery.easing.1.3', $template_dir .'/includes/js/jquery.easing.1.3.js', array( 'jquery' ), '1.0', true);
        wp_enqueue_script( 'jquery.scrollTo-1.4.2-min', $template_dir .'/includes/js/jquery.scrollTo-1.4.2-min.js', array( 'jquery' ), '1.0', true);	
	    wp_enqueue_script( 'jquery.serialScroll-1.2.2-min', $template_dir .'/includes/js/jquery.serialScroll-1.2.2-min.js', array( 'jquery' ), '1.0', true);	
        wp_enqueue_script( 'loopedslider.min', $template_dir .'/includes/js/loopedslider.min.js', array( 'jquery' ), '1.0', true);
        wp_enqueue_script( 'custom1', $template_dir .'/includes/js/custom.js', array( 'jquery' ), '1.0', true);	
		wp_enqueue_script( 'fancybox', $template_dir .'/fancybox/jquery.fancybox.pack.js', array( 'jquery' ));	
		wp_enqueue_style( 'fancybox', $template_dir .'/fancybox/jquery.fancybox.css');	
	}
	if ( is_singular() && get_option( 'thread_comments' ) ) wp_enqueue_script( 'comment-reply' );
}


	function allm_show_audio_interface(){
		global $post, $allm_jplayer_instances_on_page; 
		
		$allm_audiolink_mp3 = get_post_meta( $post->ID, '_et_allmed_audio_mp3_url', true );
		$allm_audiolink_ogg = get_post_meta( $post->ID, '_et_allmed_audio_ogg_url', true );
		$themepath = get_template_directory_uri();
		
		++$allm_jplayer_instances_on_page; ?>
		<script type="text/javascript">
			//<![CDATA[
			jQuery(document).ready(function($){
				$("<?php echo esc_js( "#jquery_jplayer_{$allm_jplayer_instances_on_page}" ); ?>").jPlayer({
					ready: function () {
						$(this).jPlayer("setMedia", {
							<?php
								if ( '' != $allm_audiolink_mp3 ) echo 'mp3:"' . esc_js( $allm_audiolink_mp3 ) . '"';
								if ( '' != $allm_audiolink_ogg ) echo ', oga:"' . esc_js( $allm_audiolink_ogg ) . '"';
							?>
						});
					},
					swfPath: "<?php echo esc_js( $themepath . '/js'); ?>",
					supplied: "<?php if ( '' != $allm_audiolink_ogg ) { echo 'oga, '; } echo 'mp3'; ?>",
					cssSelectorAncestor: "<?php echo esc_attr( "#jp_container_{$allm_jplayer_instances_on_page}" ); ?>",
					wmode: "window"
				});
			});
			//]]>
		</script>
		
		<div id="<?php echo esc_attr( "jquery_jplayer_{$allm_jplayer_instances_on_page}" ); ?>" class="jp-jplayer"></div>

		<div id="<?php echo esc_attr( "jp_container_{$allm_jplayer_instances_on_page}" ); ?>" class="jp-audio">
			<div class="jp-type-single">
				<div class="jp-gui jp-interface">
					<ul class="jp-controls">
						<li><a href="javascript:;" class="jp-play audio_play" tabindex="1"><?php esc_html_e('Play','allmed'); ?></a></li>
						<li><a href="javascript:;" class="jp-pause" tabindex="1"><?php esc_html_e('Pause','allmed'); ?></a></li>
					</ul>
										<div class="jp-progress">
						<div class="jp-seek-bar">
							<div class="jp-play-bar"></div>
						</div>
					</div>
				</div>
				<div class="jp-no-solution">
					<span><?php esc_html_e('Update Required','allmed'); ?></span>
					<?php printf( __('To play the media you will need to either update your browser to a recent version or update your %s.','allmed'), '<a href="http://get.adobe.com/flashplayer/" target="_blank">Flash plugin</a>' ); ?>
				</div>
			</div>
		</div>
<?php
	}



	function allm_display_single_post(){
		global $post;
		$format = get_post_format();
		if ( false === $format ) $format = 'standard';
		$allm_post_id = (int) get_the_ID();
		$add_permalink = 'on' == get_option('allmed_blog_style') && ! is_single();
	?>
		<article id="<?php echo esc_attr( "post-{$allm_post_id}" ); ?>" <?php post_class( 'single_view' ); ?>>
			<?php if (get_option('allmed_integration_single_top') <> '' && get_option('allmed_integrate_singletop_enable') == 'on') echo(get_option('allmed_integration_single_top')); ?>
			
			<h1 class="main_title"><?php if ( $add_permalink ) echo '<a href="' . esc_url( get_permalink() ) . '">'; ?><?php the_title(); ?><?php if ( $add_permalink ) echo '</a>';?></h1>
			<?php get_template_part('includes/postinfo','single'); ?>
			
			<div id="post_content">
				<?php 
					if ( in_array( $format, array( 'image' ) ) ) {
					 { ?>
					
	 <div id="slideshow">             
     
								<span class="post-overlay"></span>
							</div> 	<!-- end .post-thumbnail -->
						<?php }
					} elseif ( 'video' == $format ) { ?>
						<div class="video_box">
							<?php
								global $wp_embed;
								$video_width = apply_filters( 'allmed_single_video_width', 540 );
								$video_height = apply_filters( 'allmed_single_video_height', 389 );
								
								$video = get_post_meta($post->ID, '_et_allmed_video_url', true);
								$video = $wp_embed->shortcode( '', $video );
																							
								$video = preg_replace('/<embed /','<embed wmode="transparent" ',$video);
								$video = preg_replace('/<\/object>/','<param name="wmode" value="transparent" /></object>',$video); 

								$video = preg_replace("/width=\"[0-9]*\"/", "width={$video_width}", $video);
								$video = preg_replace("/height=\"[0-9]*\"/", "height={$video_height}", $video);
								
								echo $video;
							?>
						</div> <!-- end .video_box -->
					<?php } elseif ( 'audio' == $format ) { ?>
						<?php
							$thumb = '';
							$width = apply_filters( 'allm_audio_format_image_width', 176 );
							$height = apply_filters( 'allm_audio_format_image_height', 176 );
							$classtext = 'audio-image';
							$titletext = strip_tags( get_the_title() );
							$thumbnail = allm_get_thumbnail($width,$height,$classtext,$titletext,$titletext,false,'Audio');
							$thumb = $thumbnail["thumb"];
						?>
						<div class="entry audio">
							<?php if( '' != $thumb ) allm_print_thumbnail($thumb, $thumbnail["use_timthumb"], $titletext, $width, $height, $classtext); ?>
						
							<div class="content">
								<?php allm_show_audio_interface(); ?>
							</div> <!-- end .content -->
						</div>
					<?php } ?>
				<?php the_content(); ?>
<?php the_tags(); ?>
				<?php wp_link_pages(array('before' => '<p><strong>'.esc_attr__('Pages','allmed').':</strong> ', 'after' => '</p>', 'next_or_number' => 'number')); ?>
<div class="next-prev">			
				<?php previous_post_link('%link', __( '<span class="meta-nav">&larr;</span>Older post')) ?>
 	&nbsp;&nbsp;&nbsp;
<?php next_post_link('%link ',__('Newer post <span class="meta-nav">&rarr;</span>')) ?>
</div>
			</div> <!-- end #post_content -->
			
			<div class="post_bottom_bg"></div>
		</article> <!-- end .single_view -->
<?php }




add_action( 'wp_head', 'allm_set_bg_properties' );
function allm_set_bg_properties(){
	global $allm_bg_texture_urls;
	
	$bgcolor = '';
	$bgcolor = ( isset( $_COOKIE['allm_allmed_bgcolor'] ) && get_option('allmed_show_control_panel') == 'on' ) ? $_COOKIE['allm_allmed_bgcolor'] : get_option('allmed_bgcolor');
	
	$bgtexture_url = '';
	$bgimage_url = '';
	if ( get_option('allmed_bgimage') == '' ) {
		if ( isset( $_COOKIE['allm_allmed_texture_url'] ) && get_option('allmed_show_control_panel') == 'on' ) $bgtexture_url =  $_COOKIE['allm_allmed_texture_url'];
		
	} else {
		$bgimage_url = get_option('allmed_bgimage');
	}
	
	$style = '';
	$style .= '<style type="text/css">';
	if ( $bgcolor <> '' ) $style .= 'body { background-color: #' . esc_attr($bgcolor) . '; }';
	if ( $bgtexture_url <> '' ) $style .= 'body { background-image: url(' . esc_attr($bgtexture_url) . '); }';
	if ( $bgimage_url <> '' ) $style .= 'body { background-image: url(' . esc_attr($bgimage_url) . '); background-position: top center; background-repeat: no-repeat; }';
	$style .= '</style>';
	
	if ( $bgcolor <> '' || $bgtexture_url <> '' || $bgimage_url <> '' ) echo $style;
}



/**
   * Take all images from post
   */
function allm_catch_all_images() {
  global $post, $posts;
  ob_start();
  ob_end_clean();
  $output = preg_match_all('/<img.+src=[\'"]([^\'"]+)[\'"].*>/i', $post->post_content, $matches);
  foreach ($matches[1] as $value) { ?>
        <li><img src="<?php echo $value; ?>" /></li>
    <?php }
}


/**
   * Take first image from post
   * used for taking image from  post as thumbnail for front page
   */
function allm_catch_that_image() {
  global $post, $posts;
  $first_img = '';

    $attachments = get_children(array('post_parent' => $post->ID, 'post_type' => 'attachment', 'post_mime_type' => 'image', 'orderby' => 'menu_order'));

    if ( ! is_array($attachments) ) continue;
        $count = count($attachments);
        $first_attachment = array_shift($attachments);
        $temp_img = wp_get_attachment_image_src($first_attachment->ID,'full');
        $first_img = $temp_img[0];

  if(empty($first_img)){ //Defines a default image
        $first_img = get_template_directory_uri()."/img/default.jpg";
  }
  return $first_img;
}



if ( !is_admin() ) {
    function register_my_js() {
	
    }
    add_action('init', 'register_my_js');
}


 ?>