<?php 

/*this function allows for the auto-creation of post excerpts*/
if ( ! function_exists( 'allm_truncate_post' ) ){
	function allm_truncate_post($amount,$echo=true,$post='') {

		
		if ( $post == '' ) global $post;
			
		$postExcerpt = '';
		$postExcerpt = $post->post_excerpt;
		
		if (get_option('allmed'.'_use_excerpt') == 'on' && $postExcerpt <> '') { 
			if ($echo) echo $postExcerpt;
			else return $postExcerpt;	
		} else {
			$truncate = $post->post_content;
			
			$truncate = preg_replace('@\[caption[^\]]*?\].*?\[\/caption]@si', '', $truncate);
			
			if ( strlen($truncate) <= $amount ) $echo_out = ''; else $echo_out = '...';
			$truncate = apply_filters('the_content', $truncate);
			$truncate = preg_replace('@<script[^>]*?>.*?</script>@si', '', $truncate);
			$truncate = preg_replace('@<style[^>]*?>.*?</style>@si', '', $truncate);
			
			$truncate = strip_tags($truncate); 
			
			if ($echo_out == '...') $truncate = substr($truncate, 0, strrpos(substr($truncate, 0, $amount), ' '));
			else $truncate = substr($truncate, 0, $amount);

			if ($echo) echo $truncate,$echo_out;
			else return ($truncate . $echo_out);
		};
	}
}




/*this function truncates titles to create preview excerpts*/
if ( ! function_exists( 'allm_truncate_title' ) ){
	function allm_truncate_title($amount,$echo=true,$post='') {
		if ( $post == '' ) $truncate = get_the_title(); 
		else $truncate = $post->post_title; 
		if ( strlen($truncate) <= $amount ) $echo_out = ''; else $echo_out = '...';
		$truncate = mb_substr( $truncate, 0, $amount, 'UTF-8' );
		if ($echo) {
			echo $truncate;
			echo $echo_out;
		}
		else { return ($truncate . $echo_out); }
	}
}


/*this function allows users to use the first image in their post as their thumbnail*/
if ( ! function_exists( 'allm_first_image' ) ){
	function allm_first_image() {
		global $post;
		$img = '';
		$output = preg_match_all('/<img.+src=[\'"]([^\'"]+)[\'"].*>/i', $post->post_content, $matches);
		if ( isset($matches[1][0]) ) $img = $matches[1][0];

		return trim($img);
	}
}


/* this function gets thumbnail from Post Thumbnail or Custom field or First post image */
if ( ! function_exists( 'get_thumbnail' ) ){
	function allm_get_thumbnail($width=100, $height=100, $class='', $alttext='', $titletext='', $fullpath=false, $custom_field='', $post='')
	{
		if ( $post == '' ) global $post;

		
		$thumb_array['thumb'] = '';
		$thumb_array['use_timthumb'] = true;
		if ($fullpath) $thumb_array['fullpath'] = ''; //full image url for lightbox
		
		$new_method = true;
		
		if ( has_post_thumbnail( $post->ID ) && !( '' != $custom_field && get_post_meta( $post->ID, $custom_field, true ) ) ) {
			$thumb_array['use_timthumb'] = false;
			
			$allm_fullpath =  wp_get_attachment_image_src( get_post_thumbnail_id( $post->ID ), 'full' );
			$thumb_array['fullpath'] =  $allm_fullpath[0];
			$thumb_array['thumb'] = $thumb_array['fullpath'];
		}

		if ($thumb_array['thumb'] == '') {
			if ($custom_field == '') $thumb_array['thumb'] = esc_attr( get_post_meta($post->ID, 'Thumbnail', $single = true) );
			else {
				$thumb_array['thumb'] = esc_attr( get_post_meta($post->ID, $custom_field, $single = true) );
				if ($thumb_array['thumb'] == '') $thumb_array['thumb'] = esc_attr( get_post_meta($post->ID, 'Thumbnail', $single = true) );
			}
			
			if (($thumb_array['thumb'] == '') && ((get_option('allmed'.'_grab_image')) == 'on')) { 
				$thumb_array['thumb'] = esc_attr( allm_first_image() );
				if ( $fullpath ) $thumb_array['fullpath'] = $thumb_array['thumb'];
			}
			
			#if custom field used for small pre-cropped image, open Thumbnail custom field image in lightbox
			if ($fullpath) {
				$thumb_array['fullpath'] = $thumb_array['thumb'];
				if ($custom_field == '') $thumb_array['fullpath'] = apply_filters('allm_fullpath', allm_path_reltoabs(esc_attr($thumb_array['thumb'])));
				elseif ( $custom_field <> '' && get_post_meta($post->ID, 'Thumbnail', $single = true) ) $thumb_array['fullpath'] = apply_filters( 'allm_fullpath', allm_path_reltoabs(esc_attr(get_post_meta($post->ID, 'Thumbnail', $single = true))) );
			}
		}
		
		return $thumb_array;
	}
}

/* this function prints thumbnail from Post Thumbnail or Custom field or First post image */
if ( ! function_exists( 'allm_print_thumbnail' ) ){
	function allm_print_thumbnail($thumbnail = '', $use_timthumb = true, $alttext = '', $width = 100, $height = 100, $class = '', $echoout = true, $forstyle = false, $resize = true, $post='') {

		if ( $post == '' ) global $post;
		
		$output = '';
		$thumbnail_orig = $thumbnail;
		
		$thumbnail = allm_multisite_thumbnail( $thumbnail );
		
		$cropPosition = '';
		
		$allow_new_thumb_method = false;
		
		$new_method = true;
		$new_method_thumb = '';
		$external_source = false;
			
		$allow_new_thumb_method = !$external_source && $new_method && $cropPosition == '';
		
		if ( $allow_new_thumb_method && $thumbnail <> '' ){
			$allm_crop = get_post_meta( $post->ID, 'allm_nocrop', true ) == '' ? true : false; 
			$new_method_thumb =  allm_resize_image( allm_path_reltoabs($thumbnail), $width, $height, $allm_crop );
			if ( is_wp_error( $new_method_thumb ) ) $new_method_thumb = '';
		}
		
		if ($forstyle === false) {
			$output = '<img src="' . esc_url( $new_method_thumb ) . '"';
			
			if ($class <> '') $output .= " class='" . esc_attr( $class ) . "' ";

			$output .= " alt='" . esc_attr( strip_tags( $alttext ) ) . "' />";
			
			if (!$resize) $output = $thumbnail;
		} else {
			$output = $new_method_thumb;
		}
		
		if ($echoout) echo $output;
		else return $output;
	}
}

if ( ! function_exists( 'allm_new_thumb_resize' ) ){
	function allm_new_thumb_resize( $thumbnail, $width, $height, $alt='', $forstyle = false ){

			
		$new_method = true;
		$new_method_thumb = '';
		$external_source = false;
			
		$allow_new_thumb_method = !$external_source && $new_method;
		
		if ( $allow_new_thumb_method && $thumbnail <> '' ){
			$allm_crop = true;
			$new_method_thumb = allm_resize_image( $thumbnail, $width, $height, $allm_crop );
			if ( is_wp_error( $new_method_thumb ) ) $new_method_thumb = '';
		}
		
		$thumb = esc_attr( $new_method_thumb );
		
		$output = '<img src="' . esc_url( $thumb ) . '" alt="' . esc_attr( $alt ) . '" width =' . esc_attr( $width ) . ' height=' . esc_attr( $height ) . ' />';
		
		return ( !$forstyle ) ? $output : $thumb;
	}
}

if ( ! function_exists( 'allm_multisite_thumbnail' ) ){
	function allm_multisite_thumbnail( $thumbnail = '' ) {
		// do nothing if it's not a Multisite installation or current site is the main one
		if ( is_main_site() ) return $thumbnail;
		
		# get the real image url
		preg_match( '#([_0-9a-zA-Z-]+/)?files/(.+)#', $thumbnail, $matches );
		if ( isset( $matches[2] ) ){
			$file = rtrim( BLOGUPLOADDIR, '/' ) . '/' . str_replace( '..', '', $matches[2] );
			if ( is_file( $file ) ) $thumbnail = str_replace( ABSPATH, get_site_url( 1 ), $file );
			else $thumbnail = '';
		}

		return $thumbnail;
	}
}

if ( ! function_exists( 'allm_is_portrait' ) ){
	function allm_is_portrait($imageurl, $post='', $ignore_cfields = false){
		if ( $post == '' ) global $post;
		
		if ( get_post_meta($post->ID,'allm_disable_portrait',true) == 1 ) return false;
		
		if ( !$ignore_cfields ) {
			if ( get_post_meta($post->ID,'allm_imagetype',true) == 'l' ) return false;
			if ( get_post_meta($post->ID,'allm_imagetype',true) == 'p' ) return true;
		}
		
		$imageurl = allm_path_reltoabs(allm_multisite_thumbnail($imageurl));
		
		$allm_thumb_size = @getimagesize($imageurl);
		if ( empty($allm_thumb_size) ) {
			$allm_thumb_size = @getimagesize( str_replace( WP_CONTENT_URL, WP_CONTENT_DIR, $imageurl ) );
			if ( empty($allm_thumb_size) ) return false;
		}
		$allm_thumb_width = $allm_thumb_size[0];
		$allm_thumb_height = $allm_thumb_size[1];
		
		$result = ($allm_thumb_width < $allm_thumb_height) ? true : false;
		
		return $result;
	}
}

if ( ! function_exists( 'allm_path_reltoabs' ) ){
	function allm_path_reltoabs( $imageurl ){
		if ( strpos(strtolower($imageurl), 'http://') !== false || strpos(strtolower($imageurl), 'https://') !== false ) return $imageurl;
		
		if ( strpos( strtolower($imageurl), $_SERVER['HTTP_HOST'] ) !== false )
			return $imageurl;
		else {
			$imageurl = apply_filters( 'allm_path_relative_image', site_url() . '/' ) . $imageurl;
		}
		
		return $imageurl;
	}
}

if ( ! function_exists( 'allm_in_subcat' ) ){
	function allm_in_subcat($blogcat,$current_cat='') {
		$in_subcategory = false;
		
		if (cat_is_ancestor_of($blogcat,$current_cat) || $blogcat == $current_cat) $in_subcategory = true;
			
		return $in_subcategory;
	}
}

if ( ! function_exists( 'allm_show_page_menu' ) ){
	function allm_show_page_menu($customClass = 'nav clearfix', $addUlContainer = true, $addHomeLink = true){
		global  $exclude_pages, $strdepth, $page_menu, $is_footer;
		
		//excluded pages
		if (get_option('allmed'.'_menupages') <> '') $exclude_pages = implode(",", get_option('allmed'.'_menupages'));
		
		//dropdown for pages
		$strdepth = '';
		if (get_option('allmed'.'_enable_dropdowns') == 'on') $strdepth = "depth=".get_option('allmed'.'_tiers_shown_pages');
		if ($strdepth == '') $strdepth = "depth=1";
		
		if ($is_footer) { $strdepth="depth=1"; $strdepth2 = $strdepth; }
		
		$page_menu = wp_list_pages("sort_column=".get_option('allmed'.'_sort_pages')."&sort_order=".get_option('allmed'.'_order_page')."&".$strdepth."&exclude=".$exclude_pages."&title_li=&echo=0");
		
		if ($addUlContainer) echo('<ul class="'.$customClass.'">');
			if (get_option('allmed' . '_home_link') == 'on' && $addHomeLink) { ?> 
				<li <?php if (is_front_page() || is_home()) echo('class="current_page_item"') ?>><a href="<?php echo esc_url( home_url() ); ?>"><?php _e('Home','allmed'); ?></a></li>
			<?php };
			
			echo $page_menu;
		if ($addUlContainer) echo('</ul>');
	}
}

if ( ! function_exists( 'allm_show_categories_menu' ) ){
	function allm_show_categories_menu($customClass = 'nav clearfix', $addUlContainer = true){
		global $category_menu, $exclude_cats, $hide, $strdepth2, $projects_cat;
			
		//excluded categories
		if (get_option('allmed'.'_menucats') <> '') $exclude_cats = implode(",", get_option('allmed'.'_menucats')); 
		
		//hide empty categories
		if (get_option('allmed'.'_categories_empty') == 'on') $hide = '1';
		else $hide = '0';
		
		//dropdown for categories
		$strdepth2 = '';
		if (get_option('allmed'.'_enable_dropdowns_categories') == 'on') $strdepth2 = "depth=".get_option('allmed'.'_tiers_shown_categories'); 
		if ($strdepth2 == '') $strdepth2 = "depth=1";
		
		$args = "orderby=".get_option('allmed'.'_sort_cat')."&order=".get_option('allmed'.'_order_cat')."&".$strdepth2."&exclude=".$exclude_cats."&hide_empty=".$hide."&title_li=&echo=0";
		
		$categories = get_categories( $args );
		
		if ( !empty($categories) ) {
			$category_menu = wp_list_categories($args);	
			if ($addUlContainer) echo('<ul class="'.$customClass.'">');
				echo $category_menu; 
			if ($addUlContainer) echo('</ul>');
		}	
	}
}


function allm_integration_head(){

	if (get_option('allmed'.'_allm_integration_head') <> '' && get_option('allmed'.'_integrate_header_enable') == 'on') echo( get_option('allmed'.'_allm_integration_head') ); 
};
add_action('wp_head','allm_integration_head',12);

function allm_integration_body(){

	if (get_option('allmed'.'_allm_integration_body') <> '' && get_option('allmed'.'_integrate_body_enable') == 'on') echo( get_option('allmed'.'_allm_integration_body') ); 
};
add_action('wp_footer','allm_integration_body',12);

/*this function gets page name by its id*/
if ( ! function_exists( 'allm_get_pagename' ) ){
	function allm_get_pagename( $page_id )
	{
		$page_object = get_page( $page_id );
		
		return apply_filters( 'the_title', $page_object->post_title, $page_id );
	}
}

/*this function gets category name by its id*/
if ( ! function_exists( 'allm_get_categname' ) ){
	function allm_get_categname( $cat_id )
	{
		return get_cat_name( $cat_id );
	}
}

/*this function gets category id by its name*/
if ( ! function_exists( 'allm_get_catId' ) ){
	function allm_get_catId($cat_name)
	{
		$cat_name_id = get_cat_ID( html_entity_decode( $cat_name, ENT_QUOTES ) );
		return $cat_name_id;
	}
}

/*this function gets page id by its name*/
if ( ! function_exists( 'allm_get_pageId' ) ){
	function allm_get_pageId( $page_name )
	{
		global $wpdb;
		
		$page_name = html_entity_decode( $page_name, ENT_QUOTES );
		$page = get_page_by_title( $page_name );
		
		//fix for qtranslate plugin
		if ( ! $page ){
			$qt_page_name = '%<!--:en-->' . $page_name . '<!--:-->%';
			$qt_page_id = $wpdb->get_var( $wpdb->prepare( "SELECT ID FROM $wpdb->posts WHERE post_title LIKE %s AND post_type= %s", $qt_page_name, 'page' ) );

			if ( $qt_page_id ) return $qt_page_id;
			else return null;
		}

		return $page->ID;
	}
}


if ( ! function_exists( 'allm_resize_image' ) ){
	function allm_resize_image( $thumb, $new_width, $new_height, $crop ){
		if ( is_ssl() ) $thumb = preg_replace( '#^http://#', 'https://', $thumb );
		$info = pathinfo($thumb);
		$ext = $info['extension'];
		$name = wp_basename($thumb, ".$ext");
		$is_jpeg = false;
		$site_uri = apply_filters( 'allm_resize_image_site_uri', site_url() );
		$site_dir = apply_filters( 'allm_resize_image_site_dir', ABSPATH );
		
		#get main site url on multisite installation 
		if ( is_multisite() ){
			switch_to_blog(1);
			$site_uri = site_url();
			restore_current_blog();
		}
		
		if ( 'jpeg' == $ext ) {
			$ext = 'jpg';
			$name = preg_replace( '#.jpeg$#', '', $name );
			$is_jpeg = true;
		}
		
		$suffix = "{$new_width}x{$new_height}";
		
		$destination_dir = '' != get_option( 'allm_images_temp_folder' ) ? preg_replace( '#\/\/#', '/', get_option( 'allm_images_temp_folder' ) ) : null;
		
		$matches = apply_filters( 'allm_resize_image_site_dir', array(), $site_dir );
		if ( !empty($matches) ){
			preg_match( '#'.$matches[1].'$#', $site_uri, $site_uri_matches );
			if ( !empty($site_uri_matches) ){
				$site_uri = str_replace( $matches[1], '', $site_uri );
				$site_uri = preg_replace( '#/$#', '', $site_uri );
				$site_dir = str_replace( $matches[1], '', $site_dir );
				$site_dir = preg_replace( '#\\\/$#', '', $site_dir );
			}
		}
		
		#get local name for use in file_exists() and get_imagesize() functions
		$localfile = str_replace( apply_filters( 'allm_resize_image_localfile', $site_uri, $site_dir, allm_multisite_thumbnail($thumb) ), $site_dir, allm_multisite_thumbnail($thumb) );
		
		$add_to_suffix = '';
		if ( file_exists( $localfile ) ) $add_to_suffix = filesize( $localfile ) . '_';
		
		#prepend image filesize to be able to use images with the same filename
		$suffix = $add_to_suffix . $suffix;
		$destfilename_attributes = '-' . $suffix . '.' . $ext;
		
		$checkfilename = ( '' != $destination_dir && null !== $destination_dir ) ? path_join( $destination_dir, $name ) : path_join( dirname( $localfile ), $name );
		$checkfilename .= $destfilename_attributes;
		
		if ( $is_jpeg ) $checkfilename = preg_replace( '#.jpeg$#', '.jpg', $checkfilename );
		
		$uploads_dir = wp_upload_dir();
		$uploads_dir['basedir'] = preg_replace( '#\/\/#', '/', $uploads_dir['basedir'] );
		
		if ( null !== $destination_dir && '' != $destination_dir && apply_filters('allm_enable_uploads_detection', true) ){
			$site_dir = trailingslashit( preg_replace( '#\/\/#', '/', $uploads_dir['basedir'] ) );
			$site_uri = trailingslashit( $uploads_dir['baseurl'] );
		}
		
		#check if we have an image with specified width and height
		
		if ( file_exists( $checkfilename ) ) return str_replace( $site_dir, trailingslashit( $site_uri ), $checkfilename );

		$size = @getimagesize( $localfile );
		if ( !$size ) return new WP_Error('invalid_image_path', __('Image doesn\'t exist'), $thumb);
		list($orig_width, $orig_height, $orig_type) = $size;
		
		#check if we're resizing the image to smaller dimensions
		if ( $orig_width > $new_width || $orig_height > $new_height ){
			if ( $orig_width < $new_width || $orig_height < $new_height ){
				#don't resize image if new dimensions > than its original ones
				if ( $orig_width < $new_width ) $new_width = $orig_width;
				if ( $orig_height < $new_height ) $new_height = $orig_height;
				
				#regenerate suffix and appended attributes in case we changed new width or new height dimensions
				$suffix = "{$add_to_suffix}{$new_width}x{$new_height}";
				$destfilename_attributes = '-' . $suffix . '.' . $ext;
				
				$checkfilename = ( '' != $destination_dir && null !== $destination_dir ) ? path_join( $destination_dir, $name ) : path_join( dirname( $localfile ), $name );
				$checkfilename .= $destfilename_attributes;
				
				#check if we have an image with new calculated width and height parameters
				if ( file_exists($checkfilename) ) return str_replace( $site_dir, trailingslashit( $site_uri ), $checkfilename );
			}
			
	
		}
		
		#returns unmodified image, for example in case if the user is trying to resize 800x600px to 1920x1080px image
		return $thumb;
	}
}

add_action( 'pre_get_posts', 'allm_custom_posts_per_page' );
function allm_custom_posts_per_page( $query ) {

	
	if ( is_admin() ) return $query;
	
	if ( $query->is_category ) {
		$query->set( 'posts_per_page', get_option( 'allmed' . '_catnum_posts' ) );
	} elseif ( $query->is_tag ) {
		$query->set( 'posts_per_page', get_option( 'allmed' . '_tagnum_posts' ) );
	} elseif ( $query->is_search ) {
		if ( isset($_GET['allm_searchform_submit']) ) {			
			$postTypes = array();
			if ( !isset($_GET['et-inc-posts']) && !isset($_GET['et-inc-pages']) ) $postTypes = array('post');
			if ( isset($_GET['et-inc-pages']) ) $postTypes = array('page');
			if ( isset($_GET['et-inc-posts']) ) $postTypes[] = 'post';
			$query->set( 'post_type', $postTypes );
			
			if ( isset( $_GET['et-month-choice'] ) && $_GET['et-month-choice'] != 'no-choice' ) {
				$allm_year = substr($_GET['et-month-choice'],0,4);
				$allm_month = substr($_GET['et-month-choice'], 4, strlen($_GET['et-month-choice'])-4);

				$query->set( 'year', absint($allm_year) );
				$query->set( 'monthnum', absint($allm_month) );
			}
			
			if ( isset( $_GET['et-cat'] ) && $_GET['et-cat'] != 0 )
				$query->set( 'cat', absint($_GET['et-cat']) );
		}
		$query->set( 'posts_per_page', get_option( 'allmed' . '_searchnum_posts' ) );
	} elseif ( $query->is_archive ) {
		$query->set( 'posts_per_page', get_option( 'allmed' . '_archivenum_posts' ) );
	}

	return $query;
}



add_filter('site_transient_update_themes', 'allm_add_themes_to_update_notification');
function allm_add_themes_to_update_notification( $update_transient ){
	$allm_update_themes = get_site_transient( 'allm_update_themes' );
	if ( !is_object($allm_update_themes) || !isset($allm_update_themes->response) ) return $update_transient;
	$update_transient->response = array_merge(!empty($update_transient->response) ? $update_transient->response : array(), $allm_update_themes->response);
	
	return $update_transient;
}


add_filter( 'default_hidden_meta_boxes', 'allm_show_hidden_metaboxes', 10, 2 );
function allm_show_hidden_metaboxes( $hidden, $screen ){
	# make custom fields and excerpt meta boxes show by default
	if ( 'post' == $screen->base || 'page' == $screen->base )
		$hidden = array('slugdiv', 'trackbacksdiv', 'commentstatusdiv', 'commentsdiv', 'authordiv', 'revisionsdiv');
		
	return $hidden;
}

add_filter('widget_title','allm_widget_force_title');
function allm_widget_force_title( $title ){	
	#add an empty title for widgets ( otherwise it might break the sidebar layout )
	if ( $title == '' ) $title = ' ';
	
	return $title;
}

//modify the comment counts to only reflect the number of comments minus pings
if( version_compare( phpversion(), '4.4', '>=' ) ) add_filter('get_comments_number', 'allm_comment_count', 0);
function allm_comment_count( $count ) {
	if ( ! is_admin() ) {
		global $id;
		$get_comments = get_comments( array('post_id' => $id, 'status' => 'approve') );
		$comments_by_type = &separate_comments($get_comments);
		return count($comments_by_type['comment']);
	} else {
		return $count;
	}



} ?>