<?php 
/**
 * Template part for displaying Slider Section
 *
 * @package all-cleaning-services
 */

$data_slick_speed = all_cleaning_services_get_option('data_slick_speed');
$data_slick_infinite = all_cleaning_services_get_option('data_slick_infinite');
$data_slick_dots = all_cleaning_services_get_option('data_slick_dots');
$data_slick_autoplay = all_cleaning_services_get_option('data_slick_autoplay');
$data_slick_draggable = all_cleaning_services_get_option('data_slick_draggable');
$data_slick_fade = all_cleaning_services_get_option('data_slick_fade');
$featured_slider_content_type = all_cleaning_services_get_option('featured_slider_content_type');
$number_of_featured_slider_items = all_cleaning_services_get_option('number_of_featured_slider_items');
$slider_enable_section               = get_theme_mod('slider_enable_section', 'on');

?>
<?php if ($slider_enable_section == 'on') : ?>

<?php
// Convert numeric options to boolean strings for slick carousel
$data_slick_infinite = $data_slick_infinite ? 'true' : 'false';
$data_slick_dots = $data_slick_dots ? 'true' : 'false';
$data_slick_autoplay = $data_slick_autoplay ? 'true' : 'false';
$data_slick_draggable = $data_slick_draggable ? 'true' : 'false';
$data_slick_fade = $data_slick_fade ? 'true' : 'false';
?>


<?php if ($featured_slider_content_type == 'featured_slider_page') : ?>
<div id="featured-slider">
    <div class="section-content"
        data-slick='{"slidesToShow": 1, "slidesToScroll": 1, "infinite": <?php echo esc_attr($data_slick_infinite); ?>, "speed": <?php echo esc_attr($data_slick_speed); ?>, "dots": <?php echo esc_attr($data_slick_dots); ?>, "autoplay": <?php echo esc_attr($data_slick_autoplay); ?>, "draggable": <?php echo esc_attr($data_slick_draggable); ?>, "fade": <?php echo esc_attr($data_slick_fade); ?> }'>
        <?php
           $number_of_featured_slider_items = absint( get_theme_mod('number_of_featured_slider_items', 3) ); // Ensure the value is an integer

           // Ensure the number of posts starts from 1, and not showing any extras
           if ($number_of_featured_slider_items < 1) {
               $number_of_featured_slider_items = 1; // Ensure minimum value is 1
           }
           
           $all_cleaning_services_catquery = new WP_Query(array(
               'posts_per_page' => $number_of_featured_slider_items, // Limit the number of posts
               'cat' => '', // Add your category or modify query as needed
           ));
           $all_cleaning_services_catquery_counter = 0; // Initialize counter
           while ($all_cleaning_services_catquery->have_posts() && $all_cleaning_services_catquery_counter < $number_of_featured_slider_items) : $all_cleaning_services_catquery->the_post();
           $all_cleaning_services_catquery_counter++;
    ?>
        <article>
            <div class="opbg">
                <div class="slide-inner slide-bg-image">
                    <div class="sliderimg">
                        <?php if (has_post_thumbnail()) : ?>
                        <?php $total_slider_image = wp_get_attachment_image_src(get_post_thumbnail_id(), 'full'); ?>
                        <img class="slide-mainimg" alt="<?php echo esc_attr(get_the_title()); ?>"
                            src="<?php echo esc_url($total_slider_image[0]); ?>">
                        <?php endif; ?>
                    </div>
                    <div class="row d-flex align-items-center">
                        <div class="slider-inner-mainbox">
                            <?php if (get_theme_mod('featured_slider_overlayimg_enable', true)) : ?>
                            <!-- Additional content if enabled -->
                            <?php endif; ?>
                            <div class="col-xl-11 offset-xl-1 col-lg-11 offset-lg-1 col-md-11 offset-ms-1 col-sm-12 col-12 leftcontentbox <?php echo esc_attr(get_theme_mod('all_cleaning_services_featured_slider_onload_effects', 'wow zoomIn')); ?>"
                                data-wow-duration="2s">
                                <div class="wrapper animated <?php echo esc_attr(get_theme_mod('all_cleaning_services_featured_slider_onload_effects','wow Bounce In Up')); ?>"
                                    data-wow-duration="2s">
                                    <div class="entry-container"
                                        style="text-align: <?php echo (get_theme_mod('featured_slider_box_align', 'Left') == 'Left') ? 'left' : ((get_theme_mod('featured_slider_box_align', 'Center') == 'Center') ? 'center' : 'right'); ?>">
                                        <header class="entry-header header">
                                            <h2 class=" title"
                                                style="text-transform : <?php if(get_theme_mod('featured_slider_title_case','Uppercase') == 'Uppercase'){ ?> Uppercase <?php } elseif(get_theme_mod('featured_slider_title_case','Capitalize') == 'Capitalize'){ ?> Capitalize <?php } elseif(get_theme_mod('featured_slider_title_case','Lowercase') == 'Lowercase'){ ?> Lowercase <?php } elseif(get_theme_mod('featured_slider_title_case','None') == 'None'){ ?> none <?php } ?>">
                                                <?php the_title(); ?></h2>
                                        </header>
                                        <div class="entry-content content"
                                            style="text-align: <?php echo (get_theme_mod('featured_slider_box_align', 'Left') == 'Left') ? 'left' : ((get_theme_mod('featured_slider_box_align', 'Center') == 'Center') ? 'center' : 'right'); ?>">
                                            <?php
                                                the_content();
                                            ?>
                                            <div class="d-flex">
                                            <div class="read-more me-4 mt-2"><a href="" class="btn"><?php echo esc_html(get_theme_mod('all_cleaning_services_button_text','Read More')); ?></a></div>
                                            <div class="borderbtn">
                                                <div class="play-btn ">
                                                    <i class="fa-solid fa-play"></i>
                                                </div>
                                            </div>
                                            <div class="mx-2 mb-2 mt-3"><a href="" class="playbtntxt"></a></div>
                                        </div>
                                        </div>
                                        <!-- .entry-content -->
                                    </div><!-- .entry-container -->
                                </div><!-- .wrapper -->
                            </div><!-- .leftcontentbox -->
                        </div><!-- .slider-inner-mainbox -->
                    </div><!-- .row -->
                </div><!-- .slide-inner -->
            </div><!-- .opbg -->
        </article>
        <?php endwhile; ?>
        <?php endif; ?>
        <?php wp_reset_postdata(); ?>
    </div><!-- .section-content -->
</div>
<?php endif; ?>