
<?php
/**
 * Template part for displaying posts
 *
 * @link https://developer.wordpress.org/themes/basics/template-hierarchy/
 *
 * @package all-cleaning-services
 */

?>
<div class="maincontent">
     <header>
		
		<div class="post-details">
			<div class="d-flex">
				<?php $all_cleaning_services_author = get_theme_mod('all_cleaning_services_post_hide_author',false);
					if($all_cleaning_services_author === false){ ?>
					<span class="me-2 entry-by"><i class="fa-solid fa-user me-2 icon"></i><?php echo esc_html(get_theme_mod('all_cleaning_services_meta_field_by', 'By'));?></span><span class="entry-author"><a href="<?php echo esc_url( get_author_posts_url( get_the_author_meta( 'ID' )) ); ?>"><?php the_author(); ?><span class="screen-reader-text"><?php the_author(); ?></span></a></span>
				<?php } ?>
				<span class="mx-2">|</span>
				<?php $all_cleaning_services_comment = get_theme_mod('all_cleaning_services_post_comments',false);
					if($all_cleaning_services_comment === false){ ?>
					<span class="entry-comments"><i class="fa-solid fa-comments me-2 icon"></i><?php comments_number( __('Comment (0)', 'all-cleaning-services'), __('0 Comments', 'all-cleaning-services'), __('% Comments', 'all-cleaning-services') ); ?> </span>
				<?php } ?>
			</div>
		</div>

		<h2 class="page-title mb-0 mt-2">
			<?php
			// Wrap the post title in an anchor tag linking to the post
			echo '<a href="' . esc_url(get_permalink()) . '">' . esc_html(get_the_title()) . '</a>';
			?>
		</h2>

		<p><?php
			// Set a word limit, e.g., 40 words
			$content_limit = 40; 

			// Get the content and trim it
			echo wp_trim_words(get_the_content(), $content_limit, '...');

			// Optionally add a 'Read More' link
			echo '<a class="readbtn mx-1" href="' . get_permalink() . '">' . __('Read More....', 'all-cleaning-services') . '</a>';
		?></p>

		<div class="post-details mt-3 d-flex justify-content-between">
			<?php $all_cleaning_services_date = get_theme_mod('all_cleaning_services_post_hide_date',false);
						if($all_cleaning_services_date === false){ ?>
						<span class="entry-date"><i class="fa-solid fa-calendar-days me-2 icon"></i><a href="<?php echo esc_url(get_day_link(get_post_time('Y'), get_post_time('m'), get_post_time('j'))); ?>"><?php echo esc_html( get_the_date() ); ?><span class="screen-reader-text"><?php echo esc_html( get_the_date() ); ?></span></a></span>
			<?php } ?>
			<span><i class="fa-solid fa-arrow-up arrow"></i></span>             
		</div>
	</header>
	<!-- <//?php the_content(); ?> -->
</div>
